/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.headless;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class WorkspaceImporter {
    public static void importProjects() {
        File[] projectFolders;
        WorkspaceImporter.refreshWorkspace();
        File[] fileArray = projectFolders = WorkspaceImporter.getUnimportedProjectFoldersFromRoot();
        int n = projectFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File projectFolder = fileArray[n2];
            WorkspaceImporter.importProjectForFolder(projectFolder);
            ++n2;
        }
    }

    public static Set<File> getExistingProjectFolders() {
        IProject[] projects;
        HashSet<File> files = new HashSet<File>();
        IProject[] iProjectArray = projects = WorkspaceImporter.getWorkspaceRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            files.add(project.getLocation().toFile());
            ++n2;
        }
        return files;
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static File[] getUnimportedProjectFoldersFromRoot() {
        File[] files = null;
        File dir = WorkspaceImporter.getWorkspaceRoot().getLocation().toFile();
        final Set<File> projectDirs = WorkspaceImporter.getExistingProjectFolders();
        if (dir != null && dir.isDirectory()) {
            files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() && !f.getName().equals(".metadata") && !projectDirs.contains(f) && WorkspaceImporter.getMetadataFileForProject(f).isFile();
                }
            });
        }
        return files;
    }

    public static File getMetadataFileForProject(File dir) {
        return new File(dir, ".project");
    }

    public static IProject importProjectForFolder(File folder) {
        try {
            File projectFile = WorkspaceImporter.getMetadataFileForProject(folder);
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(projectFile.getAbsolutePath()));
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            project.create(description, null);
            project.open(null);
            System.out.println("Imported project " + project.getName());
            return project;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void refreshWorkspace() {
        final Semaphore s = new Semaphore(1);
        try {
            s.acquire();
        }
        catch (InterruptedException interruptedException) {}
        NullProgressMonitor pm = new NullProgressMonitor(){

            public void done() {
                s.release();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)pm);
        }
        catch (CoreException coreException) {}
        try {
            s.acquire();
        }
        catch (InterruptedException interruptedException) {}
    }
}

