/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import org.eclipse.xtext.common.types.access.impl.ClassNameUtil;
import org.eclipse.xtext.common.types.access.impl.Primitives;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder {
    private final ClassLoader classLoader;
    private final ClassNameUtil classNameUtil;

    public ClassFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classNameUtil = new ClassNameUtil();
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(this.classNameUtil.normalizeClassName(name), false, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            Class<?> result = Primitives.forName(name);
            if (result == null) {
                throw e;
            }
            return result;
        }
    }
}

