/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.computation;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.RawTypeHelper;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.computation.AbstractTypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.util.AbstractReentrantTypeReferenceProvider;
import org.eclipse.xtext.xbase.typesystem.util.ActualTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentMerger;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.MergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typing.Closures;
import org.eclipse.xtext.xbase.typing.NumberLiterals;
import org.eclipse.xtext.xtype.XComputedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XbaseTypeComputer
extends AbstractTypeComputer {
    @Inject
    private Closures closures;
    @Inject
    private NumberLiterals numberLiterals;
    @Inject
    private Primitives primitives;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private RawTypeHelper rawTypeHelper;
    @Inject
    private BoundTypeArgumentMerger typeArgumentMerger;

    protected TypeReferences getTypeReferences() {
        return this.services.getTypeReferences();
    }

    @Override
    public void computeTypes(XExpression expression, ITypeComputationState state) {
        if (expression instanceof XFeatureCall) {
            this._computeTypes((XFeatureCall)expression, state);
        } else if (expression instanceof XAbstractFeatureCall) {
            this._computeTypes((XAbstractFeatureCall)expression, state);
        } else if (expression instanceof XAbstractWhileExpression) {
            this._computeTypes((XAbstractWhileExpression)expression, state);
        } else if (expression instanceof XBlockExpression) {
            this._computeTypes((XBlockExpression)expression, state);
        } else if (expression instanceof XBooleanLiteral) {
            this._computeTypes((XBooleanLiteral)expression, state);
        } else if (expression instanceof XCastedExpression) {
            this._computeTypes((XCastedExpression)expression, state);
        } else if (expression instanceof XClosure) {
            this._computeTypes((XClosure)expression, state);
        } else if (expression instanceof XConstructorCall) {
            this._computeTypes((XConstructorCall)expression, state);
        } else if (expression instanceof XForLoopExpression) {
            this._computeTypes((XForLoopExpression)expression, state);
        } else if (expression instanceof XIfExpression) {
            this._computeTypes((XIfExpression)expression, state);
        } else if (expression instanceof XInstanceOfExpression) {
            this._computeTypes((XInstanceOfExpression)expression, state);
        } else if (expression instanceof XNumberLiteral) {
            this._computeTypes((XNumberLiteral)expression, state);
        } else if (expression instanceof XNullLiteral) {
            this._computeTypes((XNullLiteral)expression, state);
        } else if (expression instanceof XReturnExpression) {
            this._computeTypes((XReturnExpression)expression, state);
        } else if (expression instanceof XStringLiteral) {
            this._computeTypes((XStringLiteral)expression, state);
        } else if (expression instanceof XSwitchExpression) {
            this._computeTypes((XSwitchExpression)expression, state);
        } else if (expression instanceof XThrowExpression) {
            this._computeTypes((XThrowExpression)expression, state);
        } else if (expression instanceof XTryCatchFinallyExpression) {
            this._computeTypes((XTryCatchFinallyExpression)expression, state);
        } else if (expression instanceof XTypeLiteral) {
            this._computeTypes((XTypeLiteral)expression, state);
        } else if (expression instanceof XVariableDeclaration) {
            this._computeTypes((XVariableDeclaration)expression, state);
        } else {
            super.computeTypes(expression, state);
        }
    }

    protected void _computeTypes(XIfExpression object, ITypeComputationState state) {
        ITypeComputationState conditionExpectation = state.fork().withExpectation(this.getTypeReferences().getTypeForName(Boolean.TYPE, (Notifier)object, new JvmTypeReference[0]));
        conditionExpectation.computeTypes(object.getIf());
        state.computeTypes(object.getThen());
        XExpression elseExpression = object.getElse();
        if (elseExpression != null) {
            state.computeTypes(object.getElse());
        } else {
            JvmAnyTypeReference anyType = this.getTypeReferences().createAnyTypeReference((Notifier)object);
            state.acceptActualType((JvmTypeReference)anyType);
        }
    }

    protected void _computeTypes(XSwitchExpression object, ITypeComputationState state) {
        ITypeComputationState switchExpressionState = state.fork().withNonVoidExpectation();
        ITypeComputationResult computedType = switchExpressionState.computeTypes(object.getSwitch());
        ITypeComputationState allCasePartsState = state;
        if (object.getLocalVarName() != null) {
            allCasePartsState = allCasePartsState.assignType(object, computedType.getActualExpressionType());
        }
        for (XCasePart casePart : object.getCases()) {
            ITypeComputationState casePartState = allCasePartsState.fork().withTypeCheckpoint();
            if (object.getLocalVarName() != null) {
                casePartState.reassignType(object, casePart.getTypeGuard());
            } else {
                casePartState.reassignType(object.getSwitch(), casePart.getTypeGuard());
            }
            if (casePart.getCase() != null) {
                ITypeComputationState caseState = casePartState.fork().withNonVoidExpectation();
                caseState.computeTypes(casePart.getCase());
            }
            casePartState.computeTypes(casePart.getThen());
        }
        XExpression defaultCase = object.getDefault();
        if (defaultCase != null) {
            allCasePartsState.computeTypes(object.getDefault());
        } else {
            JvmAnyTypeReference anyType = this.getTypeReferences().createAnyTypeReference((Notifier)object);
            state.acceptActualType((JvmTypeReference)anyType);
        }
    }

    protected void _computeTypes(XBlockExpression object, ITypeComputationState state) {
        EList<XExpression> expressions = object.getExpressions();
        if (!expressions.isEmpty()) {
            for (XExpression expression : expressions.subList(0, expressions.size() - 1)) {
                ITypeComputationState expressionState = state.fork().withoutImmediateExpectation();
                expressionState.computeTypes(expression);
                if (!(expression instanceof XVariableDeclaration)) continue;
                state.addLocalToCurrentScope((XVariableDeclaration)expression);
            }
            state.computeTypes((XExpression)IterableExtensions.last(expressions));
        }
    }

    protected void _computeTypes(XVariableDeclaration object, ITypeComputationState state) {
        JvmTypeReference declaredType = object.getType();
        ITypeComputationState initializerState = declaredType != null ? state.fork().withExpectation(declaredType) : state.fork().withNonVoidExpectation();
        ITypeComputationResult computedType = initializerState.computeTypes(object.getRight());
        state.assignType(object, declaredType != null ? declaredType : computedType.getActualExpressionType());
        JvmTypeReference primitiveVoid = this.getPrimitiveVoid(object);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(XConstructorCall constructorCall, ITypeComputationState state) {
        List<IConstructorLinkingCandidate> candidates = state.getLinkingCandidates(constructorCall);
        IConstructorLinkingCandidate best = this.getBestCandidate(candidates);
        best.apply();
    }

    protected void _computeTypes(XBooleanLiteral object, ITypeComputationState state) {
        JvmTypeReference bool = this.getTypeReferences().getTypeForName(Boolean.TYPE, (Notifier)object, new JvmTypeReference[0]);
        state.acceptActualType(bool);
    }

    protected void _computeTypes(XNullLiteral object, ITypeComputationState state) {
        JvmAnyTypeReference any = this.getTypeReferences().createAnyTypeReference((Notifier)object);
        state.acceptActualType((JvmTypeReference)any);
    }

    protected void _computeTypes(XNumberLiteral object, ITypeComputationState state) {
        JvmTypeReference result = this.getTypeReferences().getTypeForName(this.numberLiterals.getJavaType(object), (Notifier)object, new JvmTypeReference[0]);
        state.acceptActualType(result);
    }

    protected void _computeTypes(XStringLiteral object, ITypeComputationState state) {
        JvmTypeReference result = this.getTypeReferences().getTypeForName(String.class, (Notifier)object, new JvmTypeReference[0]);
        state.acceptActualType(result);
    }

    protected void _computeTypes(final XClosure object, ITypeComputationState state) {
        for (ITypeExpectation expectation : state.getImmediateExpectations()) {
            JvmTypeReference operationReturnType;
            JvmTypeReference expectedClosureType = expectation.getExpectedType();
            HashMap expectedTypeParameterMapping = Collections.emptyMap();
            ITypeComputationState closureBodyState = state;
            JvmOperation operation = null;
            EList operationParameters = Collections.emptyList();
            TypeParameterSubstitutor substitutor = null;
            if (expectedClosureType != null) {
                operation = this.closures.findImplementingOperation(expectedClosureType, object.eResource());
                if (operation != null) {
                    List rawTypes = this.rawTypeHelper.getAllRawTypes(expectedClosureType, object.eResource());
                    ArrayList allTypeParameters = Lists.newArrayList();
                    for (JvmType rawType : rawTypes) {
                        if (!(rawType instanceof JvmTypeParameterDeclarator)) continue;
                        allTypeParameters.addAll(((JvmTypeParameterDeclarator)rawType).getTypeParameters());
                    }
                    allTypeParameters.addAll(operation.getTypeParameters());
                    ActualTypeArgumentCollector typeArgumentCollector = new ActualTypeArgumentCollector(allTypeParameters, this.services);
                    JvmParameterizedTypeReference operationTypeDeclarator = this.services.getTypeReferences().createTypeRef((JvmType)operation.getDeclaringType(), new JvmTypeReference[0]);
                    typeArgumentCollector.populateTypeParameterMapping((JvmTypeReference)operationTypeDeclarator, expectedClosureType);
                    ListMultimap<JvmTypeParameter, BoundTypeArgument> typeParameterMapping = typeArgumentCollector.getTypeParameterMapping();
                    expectedTypeParameterMapping = Maps.newHashMap();
                    for (JvmTypeParameter typeParamter : typeParameterMapping.keySet()) {
                        MergedBoundTypeArgument boundTypeArgument = this.typeArgumentMerger.merge(typeParameterMapping.get((Object)typeParamter));
                        if (boundTypeArgument == null) continue;
                        expectedTypeParameterMapping.put(typeParamter, boundTypeArgument.getTypeReference());
                    }
                    operationParameters = operation.getParameters();
                    substitutor = new TypeParameterSubstitutor(expectedTypeParameterMapping, this.services);
                    JvmTypeReference declaredReturnType = operation.getReturnType();
                    operationReturnType = substitutor.substitute(declaredReturnType);
                    if (operationReturnType == null) {
                        throw new IllegalStateException();
                    }
                    closureBodyState = closureBodyState.fork().withExpectation(operationReturnType);
                } else {
                    operationReturnType = null;
                }
            } else {
                operationReturnType = null;
            }
            if (substitutor == null) {
                substitutor = new TypeParameterSubstitutor(expectedTypeParameterMapping, this.services);
            }
            ITypeAssigner typeAssigner = closureBodyState.assignTypes();
            EList<JvmFormalParameter> closureParameters = object.getFormalParameters();
            int paramCount = Math.min(closureParameters.size(), operationParameters.size());
            int i = 0;
            while (i < paramCount) {
                JvmFormalParameter closureParameter = (JvmFormalParameter)closureParameters.get(i);
                JvmTypeReference declaredParameterType = ((JvmFormalParameter)operationParameters.get(i)).getParameterType();
                JvmTypeReference resolvedDeclaredType = substitutor.substitute(declaredParameterType);
                typeAssigner.assignType((JvmIdentifiableElement)closureParameter, closureParameter.getParameterType(), resolvedDeclaredType);
                ++i;
            }
            final JvmTypeReference[] closureType = new JvmTypeReference[1];
            int i2 = paramCount;
            while (i2 < closureParameters.size()) {
                JvmFormalParameter closureParameter = (JvmFormalParameter)closureParameters.get(i2);
                JvmTypeReference parameterType = closureParameter.getParameterType();
                if (parameterType != null) {
                    typeAssigner.assignType((JvmIdentifiableElement)closureParameter, parameterType);
                } else {
                    XComputedTypeReference computedParameterType = this.services.getXtypeFactory().createXComputedTypeReference();
                    final int parameterIndex = i2;
                    computedParameterType.setTypeProvider(new AbstractReentrantTypeReferenceProvider(){

                        protected JvmTypeReference doGetTypeReference() {
                            JvmTypeReference computedClosureType = closureType[0];
                            if (computedClosureType == null) {
                                return null;
                            }
                            JvmOperation operation = XbaseTypeComputer.this.closures.findImplementingOperation(computedClosureType, object.eResource());
                            if (operation == null) {
                                return null;
                            }
                            JvmFormalParameter operationParameter = (JvmFormalParameter)operation.getParameters().get(parameterIndex);
                            JvmTypeReference operationParameterType = operationParameter.getParameterType();
                            return operationParameterType;
                        }
                    });
                    typeAssigner.assignType((JvmIdentifiableElement)closureParameter, (JvmTypeReference)computedParameterType);
                }
                ++i2;
            }
            ITypeComputationResult expressionResult = typeAssigner.getForkedState().computeTypes(object.getExpression());
            if (expectedClosureType == null || operationReturnType == null) {
                final ArrayList closureParameterTypes = Lists.newArrayListWithCapacity((int)closureParameters.size());
                for (JvmFormalParameter parameter : closureParameters) {
                    closureParameterTypes.add(expressionResult.getActualType((JvmIdentifiableElement)parameter));
                }
                JvmTypeReference expressionResultType = expressionResult.getActualExpressionType();
                expressionResultType = (JvmTypeReference)new TypeParameterSubstitutor(Collections.emptyMap(), this.services){

                    @Override
                    public JvmTypeReference doVisitAnyTypeReference(JvmAnyTypeReference reference, Set<JvmTypeParameter> visited) {
                        return operationReturnType;
                    }

                    @Override
                    protected JvmTypeReference handleNullReference(Set<JvmTypeParameter> visited) {
                        return operationReturnType;
                    }

                    public JvmTypeReference doVisitSpecializedTypeReference(JvmSpecializedTypeReference reference, Set<JvmTypeParameter> visited) {
                        if (reference instanceof XComputedTypeReference && closureParameterTypes.contains(reference)) {
                            return reference;
                        }
                        return (JvmTypeReference)super.doVisitSpecializedTypeReference(reference, visited);
                    }
                }.visit(expressionResultType, Sets.newHashSet());
                if (expressionResultType == null) {
                    expressionResultType = this.services.getTypeReferences().getTypeForName(Object.class, (Notifier)object, new JvmTypeReference[0]);
                }
                closureType[0] = this.closures.createFunctionTypeRef(object, closureParameterTypes, expressionResultType, true);
                expectation.acceptActualType(closureType[0], ConformanceHint.DEMAND_CONVERSION);
                continue;
            }
            JvmTypeReference closureBodyType = expressionResult.getActualExpressionType();
            JvmType rawReturnType = operationReturnType.getType();
            if (rawReturnType instanceof JvmTypeParameter) {
                substitutor.enhanceMapping(Collections.singletonMap((JvmTypeParameter)rawReturnType, this.primitives.asWrapperTypeIfPrimitive(closureBodyType)));
            } else {
                substitutor.enhanceMapping(new DeclaratorTypeArgumentCollector().getTypeParameterMapping(closureBodyType));
            }
            JvmType expectedRawType = expectedClosureType.getType();
            closureType[0] = substitutor.substitute((JvmTypeReference)this.services.getTypeReferences().createTypeRef(expectedRawType, new JvmTypeReference[0]));
            expectation.acceptActualType(closureType[0], ConformanceHint.DEMAND_CONVERSION);
        }
    }

    protected void _computeTypes(XCastedExpression object, ITypeComputationState state) {
        JvmTypeReference objectType = this.getTypeReferences().getTypeForName(Object.class, (Notifier)object, new JvmTypeReference[0]);
        state.fork().withExpectation(objectType).computeTypes(object.getTarget());
        state.acceptActualType(object.getType());
    }

    protected void _computeTypes(final XForLoopExpression object, ITypeComputationState state) {
        ITypeComputationState iterableState;
        Object iterable;
        JvmFormalParameter declaredParam = object.getDeclaredParam();
        JvmTypeReference parameterType = declaredParam.getParameterType();
        if (parameterType != null) {
            iterable = null;
            iterable = this.primitives.isPrimitive(parameterType) ? this.getTypeReferences().createArrayType(parameterType) : this.getTypeReferences().getTypeForName(Iterable.class, (Notifier)object, new JvmTypeReference[]{parameterType});
            iterableState = state.fork().withExpectation((JvmTypeReference)iterable);
            iterableState.computeTypes(object.getForExpression());
        } else {
            iterable = this.getTypeReferences().getTypeForName(Iterable.class, (Notifier)object, new JvmTypeReference[]{this.getTypeReferences().wildCard()});
            iterableState = state.fork().withExpectation((JvmTypeReference)iterable);
            ITypeComputationResult forExpressionResult = iterableState.computeTypes(object.getForExpression());
            JvmTypeReference forExpressionType = forExpressionResult.getActualExpressionType();
            parameterType = (JvmTypeReference)new AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference>(){

                public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                    JvmTypeReference iterableWithTypeParam;
                    DeclaratorTypeArgumentCollector typeArgumentCollector = new DeclaratorTypeArgumentCollector();
                    Map<JvmTypeParameter, JvmTypeReference> typeParameterMapping = typeArgumentCollector.getTypeParameterMapping((JvmTypeReference)reference);
                    TypeParameterSubstitutor substitutor = new TypeParameterSubstitutor(typeParameterMapping, XbaseTypeComputer.this.services);
                    JvmTypeReference substitutedIterable = substitutor.substitute(iterableWithTypeParam = XbaseTypeComputer.this.getTypeReferences().getTypeForName(Iterable.class, (Notifier)object, new JvmTypeReference[0]));
                    if (substitutedIterable instanceof JvmParameterizedTypeReference) {
                        return (JvmTypeReference)((JvmParameterizedTypeReference)substitutedIterable).getArguments().get(0);
                    }
                    return XbaseTypeComputer.this.services.getTypesFactory().createJvmUnknownTypeReference();
                }

                public JvmTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
                    return reference.getComponentType();
                }
            }.visit(forExpressionType);
        }
        ITypeComputationState eachState = state.fork().withoutImmediateExpectation().assignType((JvmIdentifiableElement)declaredParam, parameterType);
        eachState.computeTypes(object.getEachExpression());
        JvmTypeReference primitiveVoid = this.getPrimitiveVoid(object);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(XAbstractWhileExpression object, ITypeComputationState state) {
        ITypeComputationState conditionExpectation = state.fork().withExpectation(this.getTypeReferences().getTypeForName(Boolean.TYPE, (Notifier)object, new JvmTypeReference[0]));
        conditionExpectation.computeTypes(object.getPredicate());
        state.fork().withoutImmediateExpectation().computeTypes(object.getBody());
        JvmTypeReference primitiveVoid = this.getPrimitiveVoid(object);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(XTypeLiteral object, ITypeComputationState state) {
        JvmParameterizedTypeReference typeRef = this.services.getTypesFactory().createJvmParameterizedTypeReference();
        typeRef.setType(object.getType());
        state.acceptActualType(this.getTypeReferences().getTypeForName(Class.class, (Notifier)object, new JvmTypeReference[]{typeRef}));
    }

    protected void _computeTypes(XInstanceOfExpression object, ITypeComputationState state) {
        ITypeComputationState expressionState = state.fork().withExpectation(this.getTypeReferences().getTypeForName(Object.class, (Notifier)object, new JvmTypeReference[0]));
        expressionState.computeTypes(object.getExpression());
        JvmTypeReference bool = this.getTypeReferences().getTypeForName(Boolean.TYPE, (Notifier)object, new JvmTypeReference[0]);
        state.acceptActualType(bool);
    }

    protected void _computeTypes(XThrowExpression object, ITypeComputationState state) {
        JvmTypeReference throwable = this.getTypeReferences().getTypeForName(Throwable.class, (Notifier)object, new JvmTypeReference[0]);
        ITypeComputationState expressionState = state.fork().withExpectation(throwable);
        expressionState.computeTypes(object.getExpression());
        state.acceptActualType(this.getPrimitiveVoid(object));
    }

    protected void _computeTypes(XReturnExpression object, ITypeComputationState state) {
        ITypeComputationState expressionState = state.fork().withReturnExpectation();
        expressionState.computeTypes(object.getExpression());
        state.acceptActualType(this.getPrimitiveVoid(object));
    }

    protected JvmTypeReference getPrimitiveVoid(XExpression object) {
        return this.getTypeReferences().getTypeForName(Void.TYPE, (Notifier)object, new JvmTypeReference[0]);
    }

    protected void _computeTypes(XTryCatchFinallyExpression object, ITypeComputationState state) {
        state.computeTypes(object.getExpression());
        for (XCatchClause catchClause : object.getCatchClauses()) {
            JvmFormalParameter catchClauseParam = catchClause.getDeclaredParam();
            ITypeComputationState catchClauseState = state.assignType((JvmIdentifiableElement)catchClauseParam, catchClauseParam.getParameterType());
            catchClauseState.computeTypes(catchClause.getExpression());
        }
        state.fork().withoutImmediateExpectation().computeTypes(object.getFinallyExpression());
    }

    protected void _computeTypes(XAbstractFeatureCall featureCall, ITypeComputationState state) {
        List<IFeatureLinkingCandidate> candidates = state.getLinkingCandidates(featureCall);
        IFeatureLinkingCandidate best = this.getBestCandidate(candidates);
        best.apply();
    }

    protected <Candidate extends ILinkingCandidate<Candidate>> Candidate getBestCandidate(List<Candidate> candidates) {
        ILinkingCandidate result = (ILinkingCandidate)candidates.get(0);
        int i = 1;
        while (i < candidates.size()) {
            ILinkingCandidate candidate = (ILinkingCandidate)candidates.get(i);
            if (result.compareTo(candidate) > 0) {
                result = candidate;
            }
            ++i;
        }
        return (Candidate)result;
    }

    @Override
    public JvmIdentifiableElement getRefinableCandidate(XExpression object, ITypeComputationState state) {
        JvmIdentifiableElement linkedFeature;
        List<IFeatureLinkingCandidate> candidates;
        if (object instanceof XSwitchExpression) {
            return (XSwitchExpression)object;
        }
        if (object instanceof XFeatureCall && (candidates = state.getLinkingCandidates((XFeatureCall)object)).size() == 1 && ((linkedFeature = candidates.get(0).getFeature()) instanceof XVariableDeclaration || linkedFeature instanceof JvmFormalParameter || linkedFeature instanceof JvmField)) {
            return linkedFeature;
        }
        return null;
    }
}

