/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.core.scoping.NestedTypeAwareImportNormalizer;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendImport;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;
import org.eclipse.xtext.scoping.impl.ScopeBasedSelectable;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.XbaseImportedNamespaceScopeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendImportedNamespaceScopeProvider
extends XbaseImportedNamespaceScopeProvider {
    @Inject
    private IQualifiedNameConverter nameConverter;

    public IScope getScope(EObject context, EReference reference) {
        if (context instanceof XtendImport) {
            return this.getResourceScope(context.eResource(), reference);
        }
        return super.getScope(context, reference);
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        if (!(context instanceof XtendFile)) {
            return Collections.emptyList();
        }
        XtendFile file = (XtendFile)context;
        ArrayList importedNamespaceResolvers = Lists.newArrayList();
        for (XtendImport imp : file.getImports()) {
            ImportNormalizer resolver;
            if (imp.isStatic()) continue;
            String value = imp.getImportedNamespace();
            if (value == null) {
                value = imp.getImportedTypeName();
            }
            if ((resolver = this.createImportedNamespaceResolver(value, ignoreCase)) == null) continue;
            importedNamespaceResolvers.add(resolver);
        }
        if (!Strings.isEmpty((String)((XtendFile)context).getPackage())) {
            importedNamespaceResolvers.add(new ImportNormalizer(this.nameConverter.toQualifiedName(((XtendFile)context).getPackage()), true, ignoreCase));
        }
        return importedNamespaceResolvers;
    }

    protected ImportNormalizer createImportedNamespaceResolver(String namespace, boolean ignoreCase) {
        boolean hasWildCard;
        if (Strings.isEmpty((String)namespace)) {
            return null;
        }
        QualifiedName importedNamespace = this.nameConverter.toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.getSegmentCount() < 1) {
            return null;
        }
        boolean bl = hasWildCard = ignoreCase ? importedNamespace.getLastSegment().equalsIgnoreCase(this.getWildCard()) : importedNamespace.getLastSegment().equals(this.getWildCard());
        if (hasWildCard) {
            if (importedNamespace.getSegmentCount() <= 1) {
                return null;
            }
            return this.doCreateImportNormalizer(importedNamespace.skipLast(1), true, ignoreCase);
        }
        return this.doCreateImportNormalizer(importedNamespace, false, ignoreCase);
    }

    protected List<ImportNormalizer> getImplicitImports(boolean ignoreCase) {
        return Collections.emptyList();
    }

    protected List<ImportNormalizer> getDefaultImports() {
        return Lists.newArrayList((Object[])new ImportNormalizer[]{new ImportNormalizer(QualifiedName.create((String[])new String[]{"java", "lang"}), true, false), new ImportNormalizer(QualifiedName.create((String[])new String[]{"org", "eclipse", "xtend", "lib"}), true, false)});
    }

    protected ImportNormalizer doCreateImportNormalizer(QualifiedName importedNamespace, boolean wildcard, boolean ignoreCase) {
        return new NestedTypeAwareImportNormalizer(importedNamespace, wildcard, ignoreCase);
    }

    protected IScope getLocalElementsScope(IScope parent, EObject context, EReference reference) {
        ImportNormalizer localNormalizer;
        List namespaceResolvers;
        IScope result = parent;
        ISelectable allDescriptions = this.getAllDescriptions(context.eResource());
        ScopeBasedSelectable parentSelectable = new ScopeBasedSelectable(parent);
        QualifiedName name = this.getQualifiedNameOfLocalElement(context);
        boolean ignoreCase = this.isIgnoreCase(reference);
        if (context instanceof XtendFile) {
            List<ImportNormalizer> defaultImports = this.getDefaultImports();
            result = this.createImportScope(result, defaultImports, (ISelectable)parentSelectable, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        if (!(namespaceResolvers = this.getImportedNamespaceResolvers(context, ignoreCase)).isEmpty()) {
            if (this.isRelativeImport() && name != null) {
                localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
                result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), this.isIgnoreCase(reference));
            }
            result = this.createImportScope(result, namespaceResolvers, (ISelectable)parentSelectable, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        if (name != null) {
            localNormalizer = this.doCreateImportNormalizer(name, true, ignoreCase);
            result = this.createImportScope(result, Collections.singletonList(localNormalizer), allDescriptions, reference.getEReferenceType(), this.isIgnoreCase(reference));
        }
        return result;
    }

    protected boolean isRelativeImport() {
        return false;
    }

    protected ImportScope createImportScope(IScope parent, List<ImportNormalizer> namespaceResolvers, ISelectable importFrom, EClass type, boolean ignoreCase) {
        return new ImportScope(namespaceResolvers, parent, importFrom, type, ignoreCase){

            protected IEObjectDescription getSingleLocalElementByName(QualifiedName name) {
                if (name.getSegmentCount() > 1) {
                    return null;
                }
                return super.getSingleLocalElementByName(name);
            }

            protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
                if (name.getSegmentCount() > 1) {
                    return Collections.emptyList();
                }
                return super.getLocalElementsByName(name);
            }
        };
    }
}

