/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.LinearLeastSquaresFit;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.stem.util.analysis.ParameterEstimator;

public class SIRparameterEstimator
extends ParameterEstimator {
    double[] r;
    static final double MINCUTOFF = 0.005;

    public SIRparameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        super(data);
        ArrayList<Double> sToFit = new ArrayList<Double>();
        ArrayList<Double> iToFit = new ArrayList<Double>();
        ArrayList<Double> rToFit = new ArrayList<Double>();
        List sList = data.getStotals();
        List iList = data.getItotals();
        List rList = data.getRtotals();
        int icount = 1;
        while (icount < iList.size()) {
            iToFit.add((Double)iList.get(icount));
            sToFit.add((Double)sList.get(icount));
            rToFit.add((Double)rList.get(icount));
            ++icount;
        }
        this.numDataPoints = iToFit.size();
        if (this.numDataPoints < 7) {
            return;
        }
        this.dataValid = true;
        this.p = new double[this.numDataPoints];
        this.s = new double[this.numDataPoints];
        this.i = new double[this.numDataPoints];
        this.r = new double[this.numDataPoints];
        this.t = new double[this.numDataPoints];
        icount = 0;
        while (icount < this.numDataPoints) {
            this.s[icount] = (Double)sToFit.get(icount);
            this.i[icount] = (Double)iToFit.get(icount);
            this.r[icount] = (Double)rToFit.get(icount);
            this.p[icount] = this.s[icount] + this.i[icount] + this.r[icount];
            this.t[icount] = icount;
            ++icount;
        }
    }

    @Override
    public ModelParameters estimate(double localDensity, double localPopulation, String locationID) {
        ModelParameters fittedParms = new ModelParameters();
        int npts = this.s.length;
        assert (npts == this.i.length);
        assert (npts == this.r.length);
        double[] lnS = new double[npts];
        double[] dlnS = new double[npts - 1];
        double[] lnI = new double[npts];
        double[] dlnI = new double[npts - 1];
        double[] lnR = new double[npts];
        double[] dlnR = new double[npts - 1];
        double[] sAvg = new double[npts - 1];
        double[] iAvg = new double[npts - 1];
        double[] rAvg = new double[npts - 1];
        double[] pAvg = new double[npts - 1];
        double[][] dataS = new double[2][npts - 1];
        double[][] dataI = new double[2][npts - 1];
        double[][] dataR = new double[2][npts - 1];
        double cutoff = 5.0E-10;
        int j = 0;
        while (j < npts) {
            lnS[j] = this.s[j] >= cutoff ? Math.log(this.s[j]) : Math.log(cutoff);
            lnI[j] = this.i[j] >= cutoff ? Math.log(this.i[j]) : Math.log(cutoff);
            lnR[j] = this.r[j] >= cutoff ? Math.log(this.r[j]) : Math.log(cutoff);
            ++j;
        }
        double sMax = 0.0;
        double iMax = 0.0;
        double rMax = 0.0;
        int j2 = 1;
        while (j2 < npts - 1) {
            dlnS[j2 - 1] = lnS[j2] - lnS[j2 - 1];
            dlnI[j2 - 1] = lnI[j2] - lnI[j2 - 1];
            dlnR[j2 - 1] = lnR[j2] - lnR[j2 - 1];
            sAvg[j2 - 1] = (this.s[j2] + this.s[j2 - 1]) / 2.0;
            iAvg[j2 - 1] = (this.i[j2] + this.i[j2 - 1]) / 2.0;
            rAvg[j2 - 1] = (this.r[j2] + this.r[j2 - 1]) / 2.0;
            if (sAvg[j2 - 1] >= sMax) {
                sMax = sAvg[j2 - 1];
            }
            if (iAvg[j2 - 1] >= iMax) {
                iMax = iAvg[j2 - 1];
            }
            if (rAvg[j2 - 1] >= rMax) {
                rMax = rAvg[j2 - 1];
            }
            pAvg[j2 - 1] = (this.p[j2] + this.p[j2 - 1]) / 2.0;
            ++j2;
        }
        ArrayList<Double> xList1 = new ArrayList<Double>();
        ArrayList<Double> yList1 = new ArrayList<Double>();
        ArrayList<Double> fitList1 = new ArrayList<Double>();
        int j3 = 0;
        while (j3 < npts - 1) {
            double sNorm = sAvg[j3] / sMax;
            double iNorm = iAvg[j3] / iMax;
            double rNorm = rAvg[j3] / rMax;
            dataS[0][j3] = sNorm;
            dataI[0][j3] = iNorm;
            dataR[0][j3] = rNorm;
            dataS[1][j3] = sNorm;
            dataI[1][j3] = iNorm;
            dataR[1][j3] = rNorm;
            if (sNorm <= maxSthreshold && sNorm >= minSthreshold && iNorm >= minIthreshold && rNorm <= maxRthreshold) {
                double numer = pAvg[j3] * rAvg[j3] / sAvg[j3];
                xList1.add(new Double(numer / iAvg[j3]));
                yList1.add(new Double(dlnS[j3] * (pAvg[j3] / iAvg[j3])));
            } else {
                dataS[1][j3] = 0.0;
                dataI[1][j3] = 0.0;
                dataR[1][j3] = 0.0;
            }
            ++j3;
        }
        LinearLeastSquaresFit lineFit1 = null;
        if (xList1.size() > 2) {
            lineFit1 = new LinearLeastSquaresFit(xList1, yList1);
            double beta = -1.0 * lineFit1.getIntercept();
            double varBeta = lineFit1.getInterceptVariance();
            double stdBeta = lineFit1.getInterceptStdDev();
            double alpha = lineFit1.getSlope();
            double varAlpha = lineFit1.getSlopeVariance();
            double stdAlpha = lineFit1.getSlopeStdDev();
            double newbeta = beta;
            if (!useFreqDependantBeta) {
                newbeta *= 100.0 / localDensity;
            }
            fittedParms.addParameter("beta", new Parameter("beta", newbeta, stdBeta, varBeta));
            fittedParms.addParameter("alpha", new Parameter("alpha", alpha, stdAlpha, varAlpha));
            int i = 0;
            while (i < xList1.size()) {
                double val = -lineFit1.getSlope() * (Double)xList1.get(i) + lineFit1.getIntercept();
                fitList1.add(new Double(val));
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> xList2 = new ArrayList<Double>();
        ArrayList<Double> yList2 = new ArrayList<Double>();
        ArrayList<Double> fitList2 = new ArrayList<Double>();
        int j4 = 0;
        while (j4 < npts - 1) {
            double sNorm = sAvg[j4] / sMax;
            double iNorm = iAvg[j4] / iMax;
            if (sNorm <= maxSthreshold && sNorm >= minSthreshold && iNorm >= minIthreshold) {
                double ratio = pAvg[j4] / sAvg[j4];
                xList2.add(new Double(ratio));
                yList2.add(new Double(ratio * dlnI[j4]));
            }
            ++j4;
        }
        LinearLeastSquaresFit lineFit2 = null;
        if (xList2.size() > 2) {
            lineFit2 = new LinearLeastSquaresFit(xList2, yList2);
            double gamma = -1.0 * lineFit2.getSlope();
            double varGamma = lineFit2.getSlopeVariance();
            double stdGamma = lineFit2.getSlopeStdDev();
            double beta2 = lineFit2.getIntercept();
            double varBeta2 = lineFit2.getInterceptVariance();
            double stdBeta2 = lineFit2.getInterceptStdDev();
            double newbeta2 = beta2;
            if (!useFreqDependantBeta) {
                newbeta2 *= 100.0 / localDensity;
            }
            fittedParms.addParameter("beta2", new Parameter("beta2", newbeta2, stdBeta2, varBeta2));
            fittedParms.addParameter("gamma", new Parameter("gamma", gamma, stdGamma, varGamma));
            int i = 0;
            while (i < xList2.size()) {
                double val = lineFit2.getSlope() * (Double)xList2.get(i) + lineFit2.getIntercept();
                fitList2.add(new Double(val));
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        ArrayList<Double> xList3 = new ArrayList<Double>();
        ArrayList<Double> yList3 = new ArrayList<Double>();
        ArrayList<Double> fitList3 = new ArrayList<Double>();
        int j5 = 0;
        while (j5 < npts - 1) {
            double iNorm = iAvg[j5] / iMax;
            double rNorm = rAvg[j5] / rMax;
            if (iNorm >= minIthreshold && rNorm >= minRthreshold && rNorm <= maxRthreshold) {
                xList3.add(new Double(iAvg[j5] / rAvg[j5]));
                yList3.add(new Double(dlnR[j5]));
            }
            ++j5;
        }
        LinearLeastSquaresFit lineFit3 = null;
        if (xList3.size() > 2) {
            lineFit3 = new LinearLeastSquaresFit(xList3, yList3);
            double alpha2 = Math.abs(-1.0 * lineFit3.getIntercept());
            double varAlpha2 = lineFit3.getInterceptVariance();
            double stdAlpha2 = lineFit3.getInterceptStdDev();
            double gamma2 = lineFit3.getSlope();
            double varGamma2 = lineFit3.getSlopeVariance();
            double stdGamma2 = lineFit3.getSlopeStdDev();
            fittedParms.addParameter("alpha2", new Parameter("alpha2", alpha2, stdAlpha2, varAlpha2));
            fittedParms.addParameter("gamma2", new Parameter("gamma2", gamma2, stdGamma2, varGamma2));
            int i = 0;
            while (i < xList3.size()) {
                double val = lineFit3.getSlope() * (Double)xList3.get(i) + lineFit3.getIntercept();
                fitList3.add(new Double(val));
                ++i;
            }
        } else {
            this.rejectCount += 1.0;
        }
        fittedParms.addParameter("rejected", new Parameter("rejected", this.rejectCount));
        this.dataToPlot.add(dataS);
        this.dataToPlot.add(dataI);
        this.dataToPlot.add(dataR);
        fittedParms.addSelectedData(locationID, this.dataToPlot);
        double[][] regression1 = this.getSortedRegression(xList1, yList1);
        double[][] regression2 = this.getSortedRegression(xList2, yList2);
        double[][] regression3 = this.getSortedRegression(xList3, yList3);
        double[][] fit1 = this.getSortedRegression(xList1, fitList1);
        double[][] fit2 = this.getSortedRegression(xList2, fitList2);
        double[][] fit3 = this.getSortedRegression(xList3, fitList3);
        this.regressionValues.add(regression1);
        this.regressionValues.add(regression2);
        this.regressionValues.add(regression3);
        this.fittedValues.add(fit1);
        this.fittedValues.add(fit2);
        this.fittedValues.add(fit3);
        fittedParms.addRegressionData(locationID, this.regressionValues);
        fittedParms.addFittedData(locationID, this.fittedValues);
        return fittedParms;
    }

    @Override
    public int getNumProperties() {
        return 3;
    }
}

