/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util.jdt;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.TypesSwitch;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;

public class JavaElementFinder
implements IJavaElementFinder {
    @Inject
    private IJavaProjectProvider projectProvider;

    public IJavaElement findElementFor(JvmIdentifiableElement element) {
        return this.internalFindElementFor(element, false);
    }

    public IJavaElement findExactElementFor(JvmIdentifiableElement element) {
        return this.internalFindElementFor(element, true);
    }

    protected IJavaElement internalFindElementFor(JvmIdentifiableElement element, boolean isExactMatchOnly) {
        if (element == null || element.eResource() == null) {
            return null;
        }
        Implementation implementation = new Implementation(this.projectProvider.getJavaProject(element.eResource().getResourceSet()), isExactMatchOnly);
        IJavaElement result = implementation.doSwitch((EObject)element);
        return result;
    }

    public void setProjectProvider(IJavaProjectProvider projectProvider) {
        this.projectProvider = projectProvider;
    }

    public IJavaProjectProvider getProjectProvider() {
        return this.projectProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Implementation
    extends TypesSwitch<IJavaElement> {
        private final IJavaProject javaProject;
        private final boolean isExactMatchOnly;

        public Implementation(IJavaProject javaProject, boolean isExactMatchOnly) {
            this.javaProject = javaProject;
            this.isExactMatchOnly = isExactMatchOnly;
        }

        public Implementation(IJavaProject javaProject) {
            this(javaProject, false);
        }

        public IJavaElement caseJvmPrimitiveType(JvmPrimitiveType object) {
            return null;
        }

        public IJavaElement caseJvmArrayType(JvmArrayType object) {
            return this.doSwitch((EObject)object.getComponentType());
        }

        public IJavaElement caseJvmMember(JvmMember object) {
            return this.isExactMatchOnly ? null : this.getDeclaringTypeElement(object);
        }

        public IJavaElement getDeclaringTypeElement(JvmMember object) {
            if (object.getDeclaringType() != null) {
                IJavaElement typeElement = this.doSwitch((EObject)object.getDeclaringType());
                return typeElement;
            }
            return null;
        }

        public IJavaElement caseJvmField(JvmField object) {
            IType type;
            IField result;
            IJavaElement parent = this.getDeclaringTypeElement((JvmMember)object);
            if (parent instanceof IType && (result = (type = (IType)parent).getField(object.getSimpleName())) != null) {
                return result;
            }
            return this.isExactMatchOnly ? null : parent;
        }

        public IJavaElement caseJvmOperation(JvmOperation object) {
            IJavaElement parent = this.getDeclaringTypeElement((JvmMember)object);
            if (parent instanceof IType) {
                IType type = (IType)parent;
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean match;
                        IMethod method = iMethodArray[n2];
                        if (!method.isConstructor() && object.getSimpleName().equals(method.getElementName()) && object.getParameters().size() == method.getNumberOfParameters() && (match = this.doParametersMatch((JvmExecutable)object, method, type))) {
                            return method;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    return this.isExactMatchOnly ? null : parent;
                }
            }
            return this.isExactMatchOnly ? null : parent;
        }

        private boolean doParametersMatch(JvmExecutable object, IMethod method, IType declaringType) throws JavaModelException {
            int numberOfParameters = method.getNumberOfParameters();
            String[] parameterTypes = method.getParameterTypes();
            boolean match = true;
            int i = 0;
            while (i < numberOfParameters && match) {
                String qualifiedParameterType;
                JvmFormalParameter formalParameter = (JvmFormalParameter)object.getParameters().get(i);
                String parameterType = parameterTypes[i];
                String readable = this.toQualifiedRawTypeName(parameterType, declaringType);
                if (!readable.equals(qualifiedParameterType = formalParameter.getParameterType().getType().getQualifiedName('.'))) {
                    if (qualifiedParameterType.endsWith("$") && qualifiedParameterType.startsWith(readable)) {
                        int c = readable.length();
                        while (c < qualifiedParameterType.length() && match) {
                            if (qualifiedParameterType.charAt(c) != '$') {
                                match = false;
                            }
                            ++c;
                        }
                    } else {
                        match = false;
                    }
                }
                ++i;
            }
            return match;
        }

        private String toQualifiedRawTypeName(String parameterType, IType context) throws JavaModelException {
            StringBuilder resultBuilder = new StringBuilder();
            this.toQualifiedTypeName(Signature.getTypeErasure((String)parameterType), context, resultBuilder);
            String result = resultBuilder.toString();
            return result;
        }

        private void toQualifiedTypeName(String signature, IType context, StringBuilder result) throws JavaModelException {
            switch (Signature.getTypeSignatureKind((String)signature)) {
                case 4: {
                    this.toQualifiedTypeName(Signature.getElementType((String)signature), context, result);
                    int i = 0;
                    while (i < Signature.getArrayCount((String)signature)) {
                        result.append("[]");
                        ++i;
                    }
                    return;
                }
                case 1: {
                    if (signature.charAt(0) == 'Q') {
                        String[][] resolved = context.resolveType(Signature.toString((String)signature));
                        if (resolved != null && resolved.length == 1) {
                            if (resolved[0][0] != null) {
                                result.append(resolved[0][0]);
                            }
                            if (result.length() > 0) {
                                result.append('.');
                            }
                            result.append(resolved[0][1]);
                        } else {
                            result.append(Signature.toString((String)signature));
                        }
                    } else {
                        result.append(Signature.toString((String)signature));
                    }
                    return;
                }
            }
            result.append(Signature.toString((String)signature));
        }

        public IJavaElement caseJvmConstructor(JvmConstructor object) {
            IJavaElement parent = this.getDeclaringTypeElement((JvmMember)object);
            if (parent instanceof IType) {
                IType type = (IType)parent;
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean match;
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor() && object.getParameters().size() == method.getNumberOfParameters() && (match = this.doParametersMatch((JvmExecutable)object, method, type))) {
                            return method;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    return this.isExactMatchOnly ? null : parent;
                }
            }
            return this.isExactMatchOnly ? null : parent;
        }

        public IJavaElement caseJvmDeclaredType(JvmDeclaredType object) {
            try {
                String canonicalName = object.getQualifiedName('.');
                IType result = this.javaProject.findType(canonicalName);
                return result;
            }
            catch (JavaModelException e) {
                return null;
            }
        }

        public IJavaElement doSwitch(EObject theEObject) {
            if (this.javaProject == null) {
                return null;
            }
            return (IJavaElement)super.doSwitch(theEObject);
        }
    }
}

