/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.stem.graphsynchronizer.Messenger;
import org.eclipse.stem.graphsynchronizer.MessengerException;
import org.eclipse.stem.jobs.Activator;

public class NetworkMessenger
implements Messenger {
    public static String REMOTEHOSTSKEY = "REMOTEHOSTS";
    public static String PORTKEY = "PORT";
    public static int DEFAULT_PORT = 1211;
    private String[] hosts;
    private byte[][] recvMessages;
    protected InetAddress[] hostAddresses;
    private int com_port;
    protected static Job acceptJob;
    protected static CyclicBarrier[] dataReceivedBarriers;

    @Override
    public void initialize(Properties p) throws MessengerException {
        String remoteHosts = p.getProperty(REMOTEHOSTSKEY);
        if (remoteHosts == null) {
            throw new MessengerException("Missing remote hosts specification");
        }
        String port = p.getProperty(PORTKEY);
        this.com_port = port == null ? DEFAULT_PORT : Integer.parseInt(port);
        StringTokenizer st = new StringTokenizer(remoteHosts, ";");
        this.hosts = new String[st.countTokens()];
        int n = 0;
        while (st.hasMoreTokens()) {
            this.hosts[n++] = st.nextToken();
        }
        dataReceivedBarriers = new CyclicBarrier[this.hosts.length];
        this.recvMessages = new byte[this.hosts.length][];
        this.hostAddresses = new InetAddress[this.hosts.length];
        int i = 0;
        while (i < this.hosts.length) {
            NetworkMessenger.dataReceivedBarriers[i] = new CyclicBarrier(2);
            try {
                this.hostAddresses[i] = InetAddress.getByName(this.hosts[i]);
            }
            catch (UnknownHostException e) {
                throw new MessengerException("Unable to resolve host " + this.hosts[i], e);
            }
            ++i;
        }
    }

    @Override
    public void start() throws MessengerException {
        try {
            ServerSocket serverSocket = new ServerSocket(this.com_port);
            acceptJob = new SocketListenerJob("Socket listener ", serverSocket);
            acceptJob.schedule();
        }
        catch (Exception e) {
            throw new MessengerException("Unable to start messenger", e);
        }
    }

    @Override
    public void stop() throws MessengerException {
        this.wakeupBlockedRecv();
        acceptJob.cancel();
    }

    @Override
    public void sendMsg(byte[] msg, int n) throws MessengerException {
        try {
            InetAddress otherHost = this.hostAddresses[n];
            Socket soc = new Socket(otherHost.getHostName(), this.com_port);
            ObjectOutputStream oos = new ObjectOutputStream(soc.getOutputStream());
            oos.writeObject(msg);
            oos.close();
            soc.close();
        }
        catch (Exception e) {
            throw new MessengerException("Exception encountered sending message to " + this.hostAddresses[n], e);
        }
    }

    @Override
    public byte[] recvMsg(int n) throws MessengerException {
        try {
            dataReceivedBarriers[n].await();
        }
        catch (Exception exception) {
            throw new MessengerException("Problem receiving message from host " + n);
        }
        return this.recvMessages[n];
    }

    @Override
    public void wakeupBlockedRecv() throws MessengerException {
        int n = 0;
        CyclicBarrier[] cyclicBarrierArray = dataReceivedBarriers;
        int n2 = dataReceivedBarriers.length;
        int n3 = 0;
        while (n3 < n2) {
            CyclicBarrier cb = cyclicBarrierArray[n3];
            if (cb.getNumberWaiting() == 1) {
                this.recvMessages[n] = null;
                try {
                    cb.await();
                }
                catch (Exception e) {
                    throw new MessengerException("Problem waking up blocked receiver", e);
                }
            }
            ++n;
            ++n3;
        }
    }

    protected class ConnectionHandler
    extends Job {
        private Socket soc;
        private int otherRank;

        public ConnectionHandler(String n) {
            super(n);
        }

        public ConnectionHandler(String n, Socket s, int h) {
            super(n);
            this.soc = s;
            this.otherRank = h;
            this.schedule();
        }

        protected IStatus run(IProgressMonitor monitor) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(this.soc.getInputStream());
            }
            catch (IOException e1) {
                Activator.logError((String)"Error reading data on socket", (Throwable)e1);
            }
            try {
                byte[] msg = (byte[])ois.readObject();
                ((NetworkMessenger)NetworkMessenger.this).recvMessages[this.otherRank] = msg;
                ois.close();
                this.soc.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dataReceivedBarriers[this.otherRank].await();
            }
            catch (BrokenBarrierException bbe) {
                Activator.logError((String)"Broken barrier waiting for data", (Throwable)bbe);
            }
            catch (InterruptedException ie) {
                Activator.logError((String)"Interrupted waiting for data", (Throwable)ie);
            }
            return Status.OK_STATUS;
        }
    }

    protected class SocketListenerJob
    extends Job {
        ServerSocket socket;

        public SocketListenerJob(String name) {
            super(name);
        }

        public SocketListenerJob(String name, ServerSocket socket) {
            super(name);
            this.socket = socket;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                while (!this.socket.isClosed()) {
                    Socket s = this.socket.accept();
                    if (!this.socket.isClosed()) {
                        InetAddress addr = s.getInetAddress();
                        int h = -1;
                        int i = 0;
                        while (i < NetworkMessenger.this.hostAddresses.length) {
                            if (addr.equals(NetworkMessenger.this.hostAddresses[i])) {
                                h = i;
                            }
                            ++i;
                        }
                        if (h == -1) {
                            throw new MessengerException("Unable to determine which host connected, address was " + addr);
                        }
                        new ConnectionHandler("Accepting connection", s, h);
                        continue;
                    }
                    break;
                }
            }
            catch (SocketException socketException) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (MessengerException me) {
                me.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            try {
                this.socket.close();
                this.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

