/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;

public class CommentAwareSourceRangeComputer
extends TargetSourceRangeComputer {
    protected static final Set<Integer> NODE_TYPES_WITH_SPECIAL_RANGE = new HashSet<Integer>();
    protected Comment[] commentArray = null;
    protected int[] commentStartPositions = null;
    protected int[] commentEndPositions = null;
    protected CompilationUnit compilationUnit = null;
    protected Map<ASTNode, Comment> includeTrailingCommentMapper = new HashMap<ASTNode, Comment>();
    protected Set<ASTNode> nodesWithDefaultRange = new HashSet<ASTNode>();
    protected String source = null;

    static {
        NODE_TYPES_WITH_SPECIAL_RANGE.add(81);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(82);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(55);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(71);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(72);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(8);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(79);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(77);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(78);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(31);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(23);
        NODE_TYPES_WITH_SPECIAL_RANGE.add(26);
    }

    public CommentAwareSourceRangeComputer(CompilationUnit compilationUnit, String source) {
        this.compilationUnit = compilationUnit;
        this.source = source;
        List commentList = compilationUnit.getCommentList();
        if (commentList != null) {
            this.commentArray = (Comment[])commentList.toArray();
            this.commentStartPositions = new int[commentList.size()];
            this.commentEndPositions = new int[commentList.size()];
            int i = 0;
            for (Comment comment : commentList) {
                this.commentStartPositions[i] = comment.getStartPosition();
                this.commentEndPositions[i] = this.commentStartPositions[i] + comment.getLength();
                ++i;
            }
        } else {
            this.commentArray = new Comment[0];
            this.commentStartPositions = new int[0];
            this.commentEndPositions = new int[0];
        }
    }

    protected Comment findTrailingComments(ASTNode node, ASTNode nextNode, boolean includeHangingCommentsOnly) {
        if (node == null || nextNode == null) {
            return null;
        }
        int rangeStartPos = this.compilationUnit.getExtendedStartPosition(node) + this.compilationUnit.getExtendedLength(node);
        int rangeEndPos = includeHangingCommentsOnly ? this.compilationUnit.getExtendedStartPosition(nextNode) : nextNode.getStartPosition();
        int commentIndex = this.findLastCommentInRangeIndex(rangeStartPos, rangeEndPos);
        return commentIndex == -1 ? null : this.commentArray[commentIndex];
    }

    protected Comment findLeadingComment(ASTNode node, ASTNode previousNode, boolean includeHangingCommentsOnly) {
        int rangeStartPos;
        if (node == null || previousNode == null) {
            return null;
        }
        if (includeHangingCommentsOnly) {
            rangeStartPos = this.compilationUnit.getExtendedStartPosition(previousNode) + this.compilationUnit.getExtendedLength(previousNode);
        } else {
            TargetSourceRangeComputer.SourceRange range = this.computeDefaultSourceRange(previousNode);
            rangeStartPos = range.getStartPosition() + range.getLength();
        }
        int rangeEndPos = this.compilationUnit.getExtendedStartPosition(node);
        int commentIndex = this.findFirstCommentInRangeIndex(rangeStartPos, rangeEndPos);
        return commentIndex == -1 ? null : this.commentArray[commentIndex];
    }

    protected final int findLastCommentInRangeIndex(int rangeStartPos, int rangeEndPos) {
        int commentIndex = Arrays.binarySearch(this.commentEndPositions, rangeEndPos);
        if (commentIndex < 0 ? (commentIndex = -commentIndex - 1) > 0 && this.commentStartPositions[--commentIndex] >= rangeStartPos : this.commentStartPositions[commentIndex] >= rangeStartPos) {
            return commentIndex;
        }
        return -1;
    }

    protected final int findFirstCommentInRangeIndex(int rangeStartPos, int rangeEndPos) {
        int commentIndex = Arrays.binarySearch(this.commentStartPositions, rangeStartPos);
        if (commentIndex < 0 ? (commentIndex = -commentIndex - 1) < this.commentArray.length && this.commentEndPositions[commentIndex] <= rangeEndPos : this.commentEndPositions[commentIndex] <= rangeEndPos) {
            return commentIndex;
        }
        return -1;
    }

    protected TargetSourceRangeComputer.SourceRange extendRangeForward(ASTNode nodeToAdd, TargetSourceRangeComputer.SourceRange range) {
        if (nodeToAdd != null && nodeToAdd.getStartPosition() > range.getStartPosition() + range.getLength()) {
            return new TargetSourceRangeComputer.SourceRange(range.getStartPosition(), nodeToAdd.getStartPosition() + nodeToAdd.getLength() - range.getStartPosition());
        }
        return range;
    }

    protected TargetSourceRangeComputer.SourceRange extendRangeBackward(ASTNode nodeToAdd, TargetSourceRangeComputer.SourceRange range) {
        int nodeEndPos;
        if (nodeToAdd != null && (nodeEndPos = nodeToAdd.getStartPosition() + nodeToAdd.getLength()) >= 0 && nodeEndPos < range.getStartPosition()) {
            return new TargetSourceRangeComputer.SourceRange(nodeToAdd.getStartPosition(), range.getStartPosition() + range.getLength() - nodeToAdd.getStartPosition());
        }
        return range;
    }

    protected int computeStartOfPrecedingComments(ASTNode node) {
        int nodeStartPosition = this.compilationUnit.getExtendedStartPosition(node);
        if (nodeStartPosition >= 0) {
            ASTNode prevNode = this.getPreviousNode(node);
            int minStartPosition = prevNode == null ? 0 : this.compilationUnit.getExtendedStartPosition(prevNode) + this.compilationUnit.getExtendedLength(prevNode);
            int commentIndex = this.findLastCommentInRangeIndex(minStartPosition, nodeStartPosition);
            while (commentIndex >= 0) {
                int commentStartPosition = this.commentArray[commentIndex].getStartPosition();
                int commentEndPosition = commentStartPosition + this.commentArray[commentIndex].getLength();
                if (commentStartPosition < minStartPosition || !this.isWhitespace(commentEndPosition, nodeStartPosition)) break;
                nodeStartPosition = commentStartPosition;
                --commentIndex;
            }
        }
        return nodeStartPosition;
    }

    protected int computeEndOfTrailingComments(ASTNode node) {
        int nodeEndPosition = this.compilationUnit.getExtendedStartPosition(node) + this.compilationUnit.getExtendedLength(node);
        if (nodeEndPosition >= 0) {
            ASTNode nextNode = this.getNextNode(node);
            int maxEndPosition = nextNode == null ? this.source.length() : this.compilationUnit.getExtendedStartPosition(nextNode);
            int commentIndex = this.findFirstCommentInRangeIndex(nodeEndPosition, maxEndPosition);
            while (commentIndex >= 0 && commentIndex < this.commentArray.length) {
                int commentStartPosition = this.commentArray[commentIndex].getStartPosition();
                int commentEndPosition = commentStartPosition + this.commentArray[commentIndex].getLength();
                if (commentEndPosition > maxEndPosition || !this.isWhitespace(nodeEndPosition, commentStartPosition)) break;
                nodeEndPosition = commentEndPosition;
                ++commentIndex;
            }
        }
        return nodeEndPosition;
    }

    protected ASTNode getNextNode(ASTNode node) {
        ASTNode parent;
        List siblings;
        int index;
        if (node == null) {
            return null;
        }
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent != null && locationInParent.isChildListProperty() && (index = (siblings = (List)(parent = node.getParent()).getStructuralProperty(locationInParent)).indexOf(node)) >= 0 && index < siblings.size() - 1) {
            return (ASTNode)siblings.get(index + 1);
        }
        return null;
    }

    protected ASTNode getPreviousNode(ASTNode node) {
        ASTNode parent;
        List siblings;
        int index;
        if (node == null) {
            return null;
        }
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent != null && locationInParent.isChildListProperty() && (index = (siblings = (List)(parent = node.getParent()).getStructuralProperty(locationInParent)).indexOf(node)) > 0 && index < siblings.size()) {
            return (ASTNode)siblings.get(index - 1);
        }
        return null;
    }

    public void markNodeForRemoval(ASTNode node) {
        Comment trailingComment;
        this.nodesWithDefaultRange.add(node);
        ASTNode keyNode = this.getPreviousNode(node);
        if (keyNode != null && (trailingComment = this.findTrailingComments(keyNode, node, true)) != null) {
            this.includeTrailingCommentMapper.put(keyNode, trailingComment);
        }
    }

    public void unmarkNodeForRemoval(ASTNode node) {
        this.nodesWithDefaultRange.remove(node);
        this.includeTrailingCommentMapper.remove(this.getPreviousNode(node));
    }

    protected int determineEndPositionOfLineComment(int position) {
        int firstTrailingCommentIndex;
        if (position >= 0 && (firstTrailingCommentIndex = this.findFirstCommentInRangeIndex(position, Integer.MAX_VALUE)) >= 0 && this.commentArray[firstTrailingCommentIndex].isLineComment()) {
            int commentStartPos = this.commentArray[firstTrailingCommentIndex].getStartPosition();
            int commentEndPos = commentStartPos + this.commentArray[firstTrailingCommentIndex].getLength();
            if (this.compilationUnit.getLineNumber(commentStartPos) == this.compilationUnit.getLineNumber(position) && this.isWhitespace(position, commentStartPos)) {
                return commentEndPos;
            }
        }
        return position;
    }

    protected int determineEndPositionOfLineComment(int nodeEnd, int nodeExtendedEnd) {
        if (nodeEnd < 0) {
            return nodeEnd;
        }
        if (nodeExtendedEnd < 0) {
            return nodeExtendedEnd;
        }
        int firstTrailingCommentIndex = this.findFirstCommentInRangeIndex(nodeEnd, nodeExtendedEnd);
        if (firstTrailingCommentIndex >= 0 && this.commentArray[firstTrailingCommentIndex].isLineComment()) {
            int commentStartPos = this.commentArray[firstTrailingCommentIndex].getStartPosition();
            int commentEndPos = commentStartPos + this.commentArray[firstTrailingCommentIndex].getLength();
            if (this.compilationUnit.getLineNumber(commentStartPos) == this.compilationUnit.getLineNumber(nodeEnd)) {
                return commentEndPos;
            }
        }
        return nodeEnd;
    }

    protected boolean isWhitespace(int startPosition, int endPosition) {
        return this.source != null && startPosition >= 0 && endPosition < this.source.length() && this.source.substring(startPosition, endPosition).matches("\\s*");
    }

    protected TargetSourceRangeComputer.SourceRange getEnumConstantSourceRange(ASTNode node) {
        int extendedStartPosition = this.computeStartOfPrecedingComments(node);
        int extendedEndPosition = this.computeEndOfTrailingComments(node);
        extendedEndPosition = this.addWhitespaceAfterPosition(extendedEndPosition);
        return new TargetSourceRangeComputer.SourceRange(extendedStartPosition, extendedEndPosition - extendedStartPosition);
    }

    protected int addWhitespaceAfterPosition(int position) {
        if (this.source != null && position >= 0) {
            while (position < this.source.length() && Character.isWhitespace(this.source.charAt(position++))) {
            }
            return position - 1;
        }
        return position;
    }

    public TargetSourceRangeComputer.SourceRange computeDefaultSourceRange(ASTNode node) {
        if (!NODE_TYPES_WITH_SPECIAL_RANGE.contains(node.getNodeType())) {
            return super.computeSourceRange(node);
        }
        if (node.getNodeType() == 72) {
            return this.getEnumConstantSourceRange(node);
        }
        int nodeStartPos = node.getStartPosition();
        int nodeEndPos = nodeStartPos + node.getLength();
        int extendedStartPos = this.compilationUnit.getExtendedStartPosition(node);
        int extendedEndPos = extendedStartPos + this.compilationUnit.getExtendedLength(node);
        if (node.getNodeType() == 26) {
            extendedStartPos = nodeStartPos;
        }
        extendedEndPos = node instanceof Annotation ? this.determineEndPositionOfLineComment(nodeEndPos) : this.determineEndPositionOfLineComment(nodeEndPos, extendedEndPos);
        int extendedLength = extendedEndPos - extendedStartPos;
        return new TargetSourceRangeComputer.SourceRange(extendedStartPos, extendedLength);
    }

    protected boolean shouldHaveExtendedRange(ASTNode node) {
        return node.getNodeType() != 72 && !this.nodesWithDefaultRange.contains(node);
    }

    public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
        if (!NODE_TYPES_WITH_SPECIAL_RANGE.contains(node.getNodeType())) {
            return super.computeSourceRange(node);
        }
        TargetSourceRangeComputer.SourceRange sourceRange = this.computeDefaultSourceRange(node);
        if (this.shouldHaveExtendedRange(node)) {
            ASTNode prevNode = this.getPreviousNode(node);
            if (prevNode != null) {
                sourceRange = this.extendRangeBackward((ASTNode)this.findLeadingComment(node, prevNode, false), sourceRange);
            }
            sourceRange = this.extendRangeForward((ASTNode)this.includeTrailingCommentMapper.get(node), sourceRange);
        }
        return sourceRange;
    }
}

