/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.contentassist.IContentAssistantFactory;

public class DefaultContentAssistantFactory
implements IContentAssistantFactory {
    @Inject(optional=true)
    private IContentAssistProcessor contentAssistProcessor;
    @Inject(optional=true)
    private IDialogSettings dialogSettings;
    @Inject(optional=true)
    @Named(value="xtext.enable.styledLables")
    private boolean enableStyledLabels = true;

    public IContentAssistant createConfiguredAssistant(SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        ContentAssistant assistant = this.createAssistant();
        this.configureContentAssistant(assistant, configuration, sourceViewer);
        return assistant;
    }

    protected ContentAssistant createAssistant() {
        return new ContentAssistant();
    }

    protected void configureContentAssistant(ContentAssistant assistant, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        this.configureDefaults(assistant, configuration, sourceViewer);
        this.loadPreferences(assistant);
    }

    protected void loadPreferences(ContentAssistant assistant) {
    }

    private void configureDefaults(ContentAssistant assistant, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        this.setAutoInsert(assistant);
        this.setAutoActivation(assistant);
        this.setContentAssistProcessor(assistant, configuration, sourceViewer);
        this.setInformationControlCreator(assistant, configuration, sourceViewer);
        this.setDialogSettings(assistant);
        this.setColoredLabels(assistant);
    }

    private void setDialogSettings(ContentAssistant assistant) {
        if (this.dialogSettings != null) {
            assistant.setRestoreCompletionProposalSize(this.dialogSettings);
        }
    }

    private void setInformationControlCreator(ContentAssistant assistant, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        if (configuration != null && sourceViewer != null) {
            assistant.setInformationControlCreator(configuration.getInformationControlCreator(sourceViewer));
        }
    }

    protected void setAutoInsert(ContentAssistant assistant) {
        assistant.enableAutoInsert(true);
    }

    protected void setAutoActivation(ContentAssistant assistant) {
        if (this.contentAssistProcessor != null) {
            boolean activated = this.contentAssistProcessor.getCompletionProposalAutoActivationCharacters() != null;
            assistant.enableAutoActivation(activated);
        }
    }

    protected void setContentAssistProcessor(ContentAssistant assistant, SourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        if (this.contentAssistProcessor != null) {
            String[] stringArray = configuration.getConfiguredContentTypes(sourceViewer);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                assistant.setContentAssistProcessor(this.contentAssistProcessor, contentType);
                ++n2;
            }
            if (this.contentAssistProcessor instanceof ICompletionListener) {
                assistant.setRepeatedInvocationMode(true);
                assistant.setStatusLineVisible(true);
                assistant.addCompletionListener((ICompletionListener)this.contentAssistProcessor);
            }
        }
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    protected void setColoredLabels(ContentAssistant assistant) {
        assistant.enableColoredLabels(this.enableStyledLabels);
    }
}

