/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

public final class ProfileModifiers {
    public static final int NO_PROFILE_VALUE = 0;
    public static final String CDC_1_0_FOUNDATION_1_0_NAME = "CDC-1.0/Foundation-1.0";
    public static final String CDC_1_1_FOUNDATION_1_1_NAME = "CDC-1.1/Foundation-1.1";
    public static final String J2SE_1_2_NAME = "J2SE-1.2";
    public static final String J2SE_1_3_NAME = "J2SE-1.3";
    public static final String J2SE_1_4_NAME = "J2SE-1.4";
    public static final String J2SE_1_5_NAME = "J2SE-1.5";
    public static final String JAVASE_1_6_NAME = "JavaSE-1.6";
    public static final String JAVASE_1_7_NAME = "JavaSE-1.7";
    public static final String JRE_1_1_NAME = "JRE-1.1";
    public static final String OSGI_MINIMUM_1_0_NAME = "OSGi/Minimum-1.0";
    public static final String OSGI_MINIMUM_1_1_NAME = "OSGi/Minimum-1.1";
    public static final String OSGI_MINIMUM_1_2_NAME = "OSGi/Minimum-1.2";
    public static final int CDC_1_0_FOUNDATION_1_0 = 1;
    public static final int CDC_1_1_FOUNDATION_1_1 = 2;
    public static final int JRE_1_1 = 4;
    public static final int J2SE_1_2 = 8;
    public static final int J2SE_1_3 = 16;
    public static final int J2SE_1_4 = 32;
    public static final int J2SE_1_5 = 64;
    public static final int JAVASE_1_6 = 128;
    public static final int JAVASE_1_7 = 256;
    public static final int OSGI_MINIMUM_1_0 = 512;
    public static final int OSGI_MINIMUM_1_1 = 1024;
    public static final int OSGI_MINIMUM_1_2 = 2048;
    public static final int OSGI_MINIMUM_MASK = 3584;
    public static final int CDC_FOUNDATION_MAX = 3;
    public static final int JRES_MAX = 508;

    private ProfileModifiers() {
    }

    public static boolean isCDC_1_0_FOUNDATION_1_0(int modifiers) {
        return (modifiers & 1) > 0;
    }

    public static boolean isCDC_1_1_FOUNDATION_1_1(int modifiers) {
        return (modifiers & 2) > 0;
    }

    public static boolean isJ2SE_1_2(int modifiers) {
        return (modifiers & 8) > 0;
    }

    public static boolean isJ2SE_1_3(int modifiers) {
        return (modifiers & 0x10) > 0;
    }

    public static boolean isJ2SE_1_4(int modifiers) {
        return (modifiers & 0x20) > 0;
    }

    public static boolean isJ2SE_1_5(int modifiers) {
        return (modifiers & 0x40) > 0;
    }

    public static boolean isJAVASE_1_6(int modifiers) {
        return (modifiers & 0x80) > 0;
    }

    public static boolean isJAVASE_1_7(int modifiers) {
        return (modifiers & 0x100) > 0;
    }

    public static boolean isJRE_1_1(int modifiers) {
        return (modifiers & 4) > 0;
    }

    public static boolean isOSGI_MINIMUM_1_0(int modifiers) {
        return (modifiers & 0x200) > 0;
    }

    public static boolean isOSGI_MINIMUM_1_1(int modifiers) {
        return (modifiers & 0x400) > 0;
    }

    public static boolean isOSGI_MINIMUM_1_2(int modifiers) {
        return (modifiers & 0x800) > 0;
    }

    public static int getValue(String profileName) {
        if (profileName == null) {
            return 0;
        }
        if (CDC_1_0_FOUNDATION_1_0_NAME.equals(profileName)) {
            return 1;
        }
        if (CDC_1_1_FOUNDATION_1_1_NAME.equals(profileName)) {
            return 2;
        }
        if (J2SE_1_2_NAME.equals(profileName)) {
            return 8;
        }
        if (J2SE_1_3_NAME.equals(profileName)) {
            return 16;
        }
        if (J2SE_1_4_NAME.equals(profileName)) {
            return 32;
        }
        if (J2SE_1_5_NAME.equals(profileName)) {
            return 64;
        }
        if (JAVASE_1_6_NAME.equals(profileName)) {
            return 128;
        }
        if (JAVASE_1_7_NAME.equals(profileName)) {
            return 256;
        }
        if (JRE_1_1_NAME.equals(profileName)) {
            return 4;
        }
        if (OSGI_MINIMUM_1_0_NAME.equals(profileName)) {
            return 512;
        }
        if (OSGI_MINIMUM_1_1_NAME.equals(profileName)) {
            return 1024;
        }
        if (OSGI_MINIMUM_1_2_NAME.equals(profileName)) {
            return 2048;
        }
        return 0;
    }

    public static String getName(int profile) {
        switch (profile) {
            case 1: {
                return CDC_1_0_FOUNDATION_1_0_NAME;
            }
            case 2: {
                return CDC_1_1_FOUNDATION_1_1_NAME;
            }
            case 8: {
                return J2SE_1_2_NAME;
            }
            case 16: {
                return J2SE_1_3_NAME;
            }
            case 32: {
                return J2SE_1_4_NAME;
            }
            case 64: {
                return J2SE_1_5_NAME;
            }
            case 128: {
                return JAVASE_1_6_NAME;
            }
            case 256: {
                return JAVASE_1_7_NAME;
            }
            case 4: {
                return JRE_1_1_NAME;
            }
            case 512: {
                return OSGI_MINIMUM_1_0_NAME;
            }
            case 1024: {
                return OSGI_MINIMUM_1_1_NAME;
            }
            case 2048: {
                return OSGI_MINIMUM_1_2_NAME;
            }
        }
        return null;
    }

    public static boolean isJRE(int value) {
        return (value & 0x1FC) != 0;
    }

    public static boolean isJRE(String name) {
        int value = ProfileModifiers.getValue(name);
        return ProfileModifiers.isJRE(value);
    }

    public static boolean isOSGi(String name) {
        int value = ProfileModifiers.getValue(name);
        return ProfileModifiers.isOSGi(value);
    }

    public static boolean isOSGi(int value) {
        return (value & 0xE00) != 0;
    }

    public static boolean isCDC_Foundation(String name) {
        int value = ProfileModifiers.getValue(name);
        return ProfileModifiers.isCDC_Foundation(value);
    }

    public static boolean isCDC_Foundation(int value) {
        return (value & 3) != 0;
    }

    public static int[] getAllIds() {
        return new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048};
    }
}

