/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.emf.common.util.EMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDataSetHints {
    private String[] keys;
    private DataSetIterator[] dsis;

    public UserDataSetHints(EMap<String, DataSet> allSeriesDataSets) throws ChartException {
        this(allSeriesDataSets, false);
    }

    public UserDataSetHints(EMap<String, DataSet> allSeriesDataSets, boolean bReverse) throws ChartException {
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<DataSetIterator> dsiList = new ArrayList<DataSetIterator>();
        for (Map.Entry entry : allSeriesDataSets.entrySet()) {
            if (entry.getKey() == null) continue;
            String key = (String)entry.getKey();
            DataSet ds = (DataSet)entry.getValue();
            DataSetIterator dsi = new DataSetIterator(ds);
            dsi.reverse(bReverse);
            keyList.add(key);
            dsiList.add(dsi);
        }
        this.keys = keyList.toArray(new String[keyList.size()]);
        this.dsis = dsiList.toArray(new DataSetIterator[dsiList.size()]);
    }

    public final void reset() {
        int i = 0;
        while (i < this.dsis.length) {
            this.dsis[i].reset();
            ++i;
        }
    }

    public final void next(DataPointHints dph) {
        int i = 0;
        while (i < this.keys.length) {
            if (this.dsis[i].hasNext()) {
                Object val = this.dsis[i].next();
                if (dph != null) {
                    dph.setUserValue(this.keys[i], val);
                }
            }
            ++i;
        }
    }
}

