/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;

public class GEData {
    private String name = "";
    private String description = "";
    private String id = "";
    private static final DecimalFormat df = new DecimalFormat("####.##");
    private LatLong polygons = null;
    private final Map<String, Double> valueMap = new HashMap<String, Double>(8);
    private Rectangle bBox = null;
    private double[] placemark = null;

    public GEData(String name, LatLong areas) {
        this.name = name;
        this.id = name;
        this.polygons = areas;
        if (GEPreferencePage.isBBOX()) {
            this.bBox = GEData.getBBox(areas);
        }
    }

    public GEData(String id, String name, LatLong areas) {
        this.name = name;
        this.id = id;
        this.polygons = areas;
        if (GEPreferencePage.isBBOX()) {
            this.bBox = GEData.getBBox(areas);
        }
    }

    public String getCoordinatesAsString(int numArea) {
        LatLong.Segment segment = (LatLong.Segment)this.polygons.getSegments().get(numArea);
        StringBuffer strbuf = new StringBuffer(400);
        int size = segment.size();
        int i = 0;
        while (i < size) {
            strbuf.append(df.format(segment.longitude(i)));
            strbuf.append(",");
            strbuf.append(df.format(segment.latitude(i)));
            strbuf.append(" ");
            ++i;
        }
        return strbuf.toString();
    }

    public String getValuesAsString() {
        StringBuffer strbuf = new StringBuffer(64);
        for (Map.Entry<String, Double> entry : this.valueMap.entrySet()) {
            strbuf.append(entry.getKey());
            strbuf.append(":");
            strbuf.append(df.format(entry.getValue()));
            strbuf.append(" ");
        }
        return strbuf.toString();
    }

    public int getNumAreas() {
        if (this.polygons != null) {
            return this.polygons.size();
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public Rectangle getBBox() {
        return this.bBox;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPoint(double latitude, double longitude) {
        this.placemark = new double[2];
        this.placemark[0] = latitude;
        this.placemark[1] = longitude;
    }

    public double[] getPoint() {
        return this.placemark;
    }

    private static Rectangle getBBox(LatLong latLong) {
        List list = latLong.getSegments();
        int numareas = list.size();
        Rectangle bBox = null;
        int i = 0;
        while (i < numareas) {
            Polygon polygon = new Polygon();
            LatLong.Segment segment = (LatLong.Segment)list.get(i);
            int size = segment.size();
            int p = 0;
            while (p < size) {
                double x = segment.longitude(p);
                double y = segment.latitude(p);
                int xint = (int)((x + 180.0) * 1000.0);
                int yint = (int)((y + 90.0) * 1000.0);
                polygon.addPoint(xint, yint);
                ++p;
            }
            bBox = bBox == null ? polygon.getBounds() : bBox.union(polygon.getBounds());
            ++i;
        }
        return bBox;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GEData: ");
        sb.append(this.getValuesAsString());
        sb.append(" BBox:" + this.bBox);
        sb.append(" : ");
        int i = 0;
        while (i < this.polygons.size()) {
            sb.append(this.getCoordinatesAsString(i));
            ++i;
        }
        return sb.toString();
    }

    public Map<String, Double> getValueMap() {
        return this.valueMap;
    }

    public double getValue(Aspect aspect) {
        return this.valueMap.get(aspect.getCode());
    }

    public void setValue(Aspect aspect, double value) {
        this.valueMap.put(aspect.getCode(), value);
    }

    public double[] getBBoxCenter() {
        if (this.bBox == null) {
            this.bBox = GEData.getBBox(this.polygons);
        }
        if (this.bBox != null) {
            double longitude = this.bBox.getCenterX();
            longitude = (longitude - 180000.0) / 1000.0;
            double latitude = this.bBox.getCenterY();
            latitude = (latitude - 90000.0) / 1000.0;
            double[] center = new double[]{longitude, latitude};
            return center;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

