/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.Resources;

class ReadOnlyResourceFinder {
    private ReadOnlyResourceFinder() {
    }

    static boolean confirmDeleteOfReadOnlyElements(IJavaElement[] javaElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = RefactoringCoreMessages.ReadOnlyResourceFinder_0;
        String question = RefactoringCoreMessages.ReadOnlyResourceFinder_1;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, javaElements, resources, queries);
    }

    static boolean confirmMoveOfReadOnlyElements(IJavaElement[] javaElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = RefactoringCoreMessages.ReadOnlyResourceFinder_2;
        String question = RefactoringCoreMessages.ReadOnlyResourceFinder_3;
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, javaElements, resources, queries);
    }

    private static boolean confirmOperationOnReadOnlyElements(String queryTitle, String question, IJavaElement[] javaElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        boolean hasReadOnlyResources = ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(javaElements, resources);
        if (hasReadOnlyResources) {
            IConfirmQuery query = queries.createYesNoQuery(queryTitle, false, 5);
            return query.confirm(question);
        }
        return true;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement[] javaElements, IResource[] resources) throws CoreException {
        return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources) || ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(javaElements);
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement[] javaElements) throws CoreException {
        int i = 0;
        while (i < javaElements.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(javaElements[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement javaElement) throws CoreException {
        switch (javaElement.getElementType()) {
            case 5: 
            case 6: {
                IResource resource = ReorgUtils.getResource(javaElement);
                Assert.isTrue((boolean)(resource instanceof IFile));
                return resource != null && Resources.isReadOnly(resource);
            }
            case 4: {
                IResource packResource = ReorgUtils.getResource(javaElement);
                if (packResource == null) {
                    return false;
                }
                IPackageFragment pack = (IPackageFragment)javaElement;
                if (Resources.isReadOnly(packResource)) {
                    return true;
                }
                Object[] nonJava = pack.getNonJavaResources();
                int i = 0;
                while (i < nonJava.length) {
                    Object object = nonJava[i];
                    if (object instanceof IResource && ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) {
                        return true;
                    }
                    ++i;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(pack.getChildren());
            }
            case 3: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isArchive() || root.isExternal()) {
                    return false;
                }
                IResource pfrResource = ReorgUtils.getResource(javaElement);
                if (pfrResource == null) {
                    return false;
                }
                if (Resources.isReadOnly(pfrResource)) {
                    return true;
                }
                Object[] nonJava1 = root.getNonJavaResources();
                int i = 0;
                while (i < nonJava1.length) {
                    Object object = nonJava1[i];
                    if (object instanceof IResource && ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) {
                        return true;
                    }
                    ++i;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(root.getChildren());
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return false;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource[] resources) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            if (ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource resource) throws CoreException {
        if (resource.isLinked()) {
            return false;
        }
        if (Resources.isReadOnly(resource)) {
            return true;
        }
        if (resource instanceof IContainer) {
            return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(((IContainer)resource).members());
        }
        return false;
    }
}

