/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.versioning.VersioningUtil;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewNonIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.stem.ui.wizards.STEMWizardNewProjectCreationPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Version;

public class NewSTEMProjectWizard
extends NewNonIdentifiableWizard
implements INewWizard,
IExecutableExtension {
    public static final String ID_STEM_PROJECT_WIZARD = "org.eclipse.stem.ui.wizards.newstemproject";
    public static final String GRAPHS_FOLDER_NAME = "graphs";
    public static final String RECORDED_SIMULATIONS_FOLDER_NAME = "Recorded Simulations";
    public static final String MODELS_FOLDER_NAME = "models";
    public static final String SCEANARIOS_FOLDER_NAME = "scenarios";
    public static final String SOLVERS_FOLDER_NAME = "solvers";
    public static final String DECORATORS_FOLDER_NAME = "decorators";
    public static final String SEQUENCERS_FOLDER_NAME = "sequencers";
    public static final String EXPERIMENTS_FOLDER_NAME = "experiments";
    public static final String MODIFIERS_FOLDER_NAME = "modifiers";
    public static final String TRIGGERS_FOLDER_NAME = "triggers";
    public static final String PREDICATES_FOLDER_NAME = "predicates";
    public static final String LOGGERS_FOLDER_NAME = "loggers";
    public static final String GML_FOLDER_NAME = ".gml";
    WizardNewProjectCreationPage newProjectPage = null;
    private final String[] defaultFolders = new String[]{"graphs", "models", "scenarios", "solvers", "decorators", "sequencers", "experiments", "modifiers", "triggers", "predicates", "Recorded Simulations", "loggers", ".gml"};

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
        this.setHelpContextId("org.eclipse.stem.doc.newstemproject_contextid");
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(Messages.getString("NSTEMProWiz.title"));
        this.newProjectPage = new STEMWizardNewProjectCreationPage(Messages.getString("NSTEMProWiz.title"));
        this.newProjectPage.setTitle(Messages.getString("NSTEMProWiz.page_title"));
        this.newProjectPage.setDescription(Messages.getString("NSTEMProWiz.page_description"));
        this.addPage((IWizardPage)this.newProjectPage);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    NewSTEMProjectWizard.this.createProject((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
                }
            };
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Activator.logError(ID_STEM_PROJECT_WIZARD, e);
        }
        catch (InterruptedException e) {
            Activator.logInformation(ID_STEM_PROJECT_WIZARD, e);
        }
        return true;
    }

    void createProject(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.getString("NSTEMProWiz.title"), 1 + this.defaultFolders.length);
        try {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                monitor.subTask(Messages.getString("NSTEMProWiz.creating_project"));
                IProject project = root.getProject(this.newProjectPage.getProjectName());
                IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
                if (!Platform.getLocation().equals((Object)this.newProjectPage.getLocationPath())) {
                    projectDescription.setLocation(this.newProjectPage.getLocationPath());
                }
                projectDescription.setNatureIds(new String[]{"org.eclipse.stem.stemnature"});
                project.create(projectDescription, monitor);
                monitor.worked(1);
                monitor.subTask(Messages.getString("NSTEMProWiz.creating_directories"));
                project.open(monitor);
                IPath projectPath = project.getFullPath();
                String[] stringArray = this.defaultFolders;
                int n = this.defaultFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    String folderName = stringArray[n2];
                    IPath fullFolderPath = projectPath.append(folderName);
                    IFolder folder = root.getFolder(fullFolderPath);
                    this.createFolder(folder, monitor);
                    monitor.worked(1);
                    ++n2;
                }
                Version v = VersioningUtil.getSTEMVersion();
                VersioningUtil.setSTEMProjectVersion(project, v.toString());
            }
            catch (CoreException ce) {
                Activator.logError(Messages.getString("NSTEMProWiz.Create_Problem"), ce);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder && !((IFolder)parent).exists()) {
                this.createFolder((IFolder)parent, monitor);
            }
            folder.create(false, true, monitor);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public static class NewSTEMProjectWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewSTEMProjectWizard wizard = new NewSTEMProjectWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

