/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.refactoring.descriptors;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;

public class JavaRefactoringDescriptorUtil {
    private static final String LOWER_CASE_FALSE = Boolean.FALSE.toString().toLowerCase();
    private static final String LOWER_CASE_TRUE = Boolean.TRUE.toString().toLowerCase();

    public static String elementToHandle(String project, IJavaElement element) {
        IJavaProject javaProject;
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IJavaProject) && project.equals((javaProject = element.getJavaProject()).getElementName())) {
            String id = javaProject.getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    public static String resourcePathToHandle(String project, IPath resourcePath) {
        if (project != null && !"".equals(project) && resourcePath.segmentCount() != 1 && resourcePath.segment(0).equals(project)) {
            return resourcePath.removeFirstSegments(1).toPortableString();
        }
        return resourcePath.toPortableString();
    }

    public static IJavaElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IMethod method;
        IMethod[] methods;
        IJavaElement element = null;
        element = owner != null ? JavaCore.create((String)handle, (WorkingCopyOwner)owner) : JavaCore.create((String)handle);
        if (element == null && project != null) {
            IJavaProject javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(project);
            String identifier = javaProject.getHandleIdentifier();
            element = owner != null ? JavaCore.create((String)(String.valueOf(identifier) + handle), (WorkingCopyOwner)owner) : JavaCore.create((String)(String.valueOf(identifier) + handle));
        }
        if (check && element instanceof IMethod && (methods = (method = (IMethod)element).getDeclaringType().findMethods(method)) != null && methods.length > 0) {
            element = methods[0];
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    public static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    public static IPath handleToResourcePath(String project, String handle) {
        IPath path = Path.fromPortableString((String)handle);
        if (project != null && !"".equals(project) && !path.isAbsolute()) {
            return new Path(project).append(path).makeAbsolute();
        }
        return path;
    }

    public static String getString(Map map, String attribute, boolean allowNull) throws IllegalArgumentException {
        Object object = map.get(attribute);
        if (object == null) {
            if (allowNull) {
                return null;
            }
            throw new IllegalArgumentException("The map does not contain the attribute '" + attribute + "'");
        }
        if (object instanceof String) {
            String value = (String)object;
            return value;
        }
        throw new IllegalArgumentException("The provided map does not contain a string for attribute '" + attribute + "'");
    }

    public static String getString(Map map, String attribute) throws IllegalArgumentException {
        return JavaRefactoringDescriptorUtil.getString(map, attribute, false);
    }

    public static String[] getStringArray(Map map, String countAttribute, String arrayAttribute, int offset) throws IllegalArgumentException {
        int count = JavaRefactoringDescriptorUtil.getInt(map, countAttribute);
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = JavaRefactoringDescriptorUtil.getString(map, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset));
            ++i;
        }
        return result;
    }

    public static int getInt(Map map, String attribute) throws IllegalArgumentException {
        String value = JavaRefactoringDescriptorUtil.getString(map, attribute);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid int '" + value + "'");
        }
    }

    public static int getInt(Map map, String attribute, int defaultValue) throws IllegalArgumentException {
        String value = JavaRefactoringDescriptorUtil.getString(map, attribute, true);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid int '" + value + "'");
        }
    }

    public static int[] getIntArray(Map map, String countAttribute, String arrayAttribute) throws IllegalArgumentException {
        int count = JavaRefactoringDescriptorUtil.getInt(map, countAttribute);
        int[] result = new int[count];
        int i = 0;
        while (i < count) {
            result[i] = JavaRefactoringDescriptorUtil.getInt(map, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, i));
            ++i;
        }
        return result;
    }

    public static String getAttributeName(String attribute, int index) {
        return String.valueOf(attribute) + index;
    }

    public static IJavaElement getJavaElement(Map map, String attribute, String project) throws IllegalArgumentException {
        return JavaRefactoringDescriptorUtil.getJavaElement(map, attribute, project, false);
    }

    public static IJavaElement getJavaElement(Map map, String attribute, String project, boolean allowNull) throws IllegalArgumentException {
        String handle = JavaRefactoringDescriptorUtil.getString(map, attribute, allowNull);
        if (handle != null) {
            return JavaRefactoringDescriptorUtil.handleToElement(null, project, handle, false);
        }
        return null;
    }

    public static IJavaElement[] getJavaElementArray(Map map, String countAttribute, String arrayAttribute, int offset, String project, Class arrayClass) throws IllegalArgumentException {
        if (countAttribute != null) {
            int count = JavaRefactoringDescriptorUtil.getInt(map, countAttribute);
            IJavaElement[] result = (IJavaElement[])Array.newInstance(arrayClass, count);
            int i = 0;
            while (i < count) {
                result[i] = JavaRefactoringDescriptorUtil.getJavaElement(map, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), project);
                ++i;
            }
            return result;
        }
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        IJavaElement element = null;
        while ((element = JavaRefactoringDescriptorUtil.getJavaElement(map, arrayAttribute, project, true)) != null) {
            result.add(element);
        }
        return (IJavaElement[])result.toArray((Object[])Array.newInstance(arrayClass, result.size()));
    }

    public static IPath getResourcePath(Map map, String attribute, String project) throws IllegalArgumentException {
        String handle = JavaRefactoringDescriptorUtil.getString(map, attribute);
        return JavaRefactoringDescriptorUtil.handleToResourcePath(project, handle);
    }

    public static IPath[] getResourcePathArray(Map map, String countAttribute, String arrayAttribute, int offset, String project) throws IllegalArgumentException {
        int count = JavaRefactoringDescriptorUtil.getInt(map, countAttribute);
        IPath[] result = new IPath[count];
        int i = 0;
        while (i < count) {
            result[i] = JavaRefactoringDescriptorUtil.getResourcePath(map, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), project);
            ++i;
        }
        return result;
    }

    public static boolean[] getBooleanArray(Map map, String countAttribute, String arrayAttribute, int offset) throws IllegalArgumentException {
        int count = JavaRefactoringDescriptorUtil.getInt(map, countAttribute);
        boolean[] result = new boolean[count];
        int i = 0;
        while (i < count) {
            result[i] = JavaRefactoringDescriptorUtil.getBoolean(map, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset));
            ++i;
        }
        return result;
    }

    public static boolean getBoolean(Map map, String attribute) throws IllegalArgumentException {
        String value = JavaRefactoringDescriptorUtil.getString(map, attribute).toLowerCase();
        if (LOWER_CASE_TRUE.equals(value)) {
            return true;
        }
        if (LOWER_CASE_FALSE.equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid boolean: '" + value + "'");
    }

    public static boolean hasBoolean(Map map, String attribute) throws IllegalArgumentException {
        String string = JavaRefactoringDescriptorUtil.getString(map, attribute, true);
        if (string == null) {
            return false;
        }
        String value = string.toLowerCase();
        if (LOWER_CASE_TRUE.equals(value)) {
            return true;
        }
        if (LOWER_CASE_FALSE.equals(value)) {
            return true;
        }
        throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid boolean: '" + value + "'");
    }

    public static boolean getBoolean(Map map, String attribute, boolean defaultValue) throws IllegalArgumentException {
        String value = JavaRefactoringDescriptorUtil.getString(map, attribute, true);
        if (value == null) {
            return defaultValue;
        }
        if (LOWER_CASE_TRUE.equals(value = value.toLowerCase())) {
            return true;
        }
        if (LOWER_CASE_FALSE.equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("The attribute '" + attribute + "' does not contain a valid boolean: '" + value + "'");
    }

    public static void setJavaElement(Map arguments, String attribute, String project, IJavaElement element) throws IllegalArgumentException {
        if (element == null) {
            throw new IllegalArgumentException("The element for attribute '" + attribute + "' may not be null");
        }
        JavaRefactoringDescriptorUtil.setString(arguments, attribute, JavaRefactoringDescriptorUtil.elementToHandle(project, element));
    }

    public static void setResourcePath(Map arguments, String attribute, String project, IPath resourcePath) throws IllegalArgumentException {
        if (resourcePath == null) {
            throw new IllegalArgumentException("The resource for attribute '" + attribute + "' may not be null");
        }
        JavaRefactoringDescriptorUtil.setString(arguments, attribute, JavaRefactoringDescriptorUtil.resourcePathToHandle(project, resourcePath));
    }

    public static void setInt(Map arguments, String attribute, int value) throws IllegalArgumentException {
        JavaRefactoringDescriptorUtil.setString(arguments, attribute, Integer.toString(value));
    }

    public static void setBoolean(Map arguments, String attribute, boolean value) throws IllegalArgumentException {
        JavaRefactoringDescriptorUtil.setString(arguments, attribute, value ? LOWER_CASE_TRUE : LOWER_CASE_FALSE);
    }

    public static void setBooleanArray(Map arguments, String countAttribute, String arrayAttribute, boolean[] value, int offset) {
        if (value == null) {
            throw new IllegalArgumentException("The values for arrayAttribute '" + arrayAttribute + "' may not be null");
        }
        if (countAttribute != null) {
            JavaRefactoringDescriptorUtil.setInt(arguments, countAttribute, value.length);
        }
        int i = 0;
        while (i < value.length) {
            JavaRefactoringDescriptorUtil.setBoolean(arguments, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), value[i]);
            ++i;
        }
    }

    public static void setString(Map arguments, String attribute, String value) throws IllegalArgumentException {
        if (attribute == null || "".equals(attribute) || attribute.indexOf(32) != -1) {
            throw new IllegalArgumentException("Attribute '" + attribute + "' is not valid: '" + value + "'");
        }
        if (value != null) {
            arguments.put(attribute, value);
        } else {
            arguments.remove(attribute);
        }
    }

    public static void setStringArray(Map arguments, String countAttribute, String arrayAttribute, String[] value, int offset) {
        if (value == null) {
            throw new IllegalArgumentException("The values for arrayAttribute '" + arrayAttribute + "' may not be null");
        }
        if (countAttribute != null) {
            JavaRefactoringDescriptorUtil.setInt(arguments, countAttribute, value.length);
        }
        int i = 0;
        while (i < value.length) {
            String string = value[i];
            JavaRefactoringDescriptorUtil.setString(arguments, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, i + offset), string);
            ++i;
        }
    }

    public static void setSelection(Map arguments, String attribute, int offset, int length) throws IllegalArgumentException {
        String value = String.valueOf(Integer.toString(offset)) + " " + Integer.toString(length);
        JavaRefactoringDescriptorUtil.setString(arguments, attribute, value);
    }

    public static void setResourcePathArray(Map arguments, String countAttribute, String arrayAttribute, String project, IPath[] resourcePaths, int offset) throws IllegalArgumentException {
        if (resourcePaths == null) {
            throw new IllegalArgumentException("The resources for arrayAttribute '" + arrayAttribute + "' may not be null");
        }
        if (countAttribute != null) {
            JavaRefactoringDescriptorUtil.setInt(arguments, countAttribute, resourcePaths.length);
        }
        int i = 0;
        while (i < resourcePaths.length) {
            IPath resourcePath = resourcePaths[i];
            JavaRefactoringDescriptorUtil.setResourcePath(arguments, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttribute, offset + i), project, resourcePath);
            ++i;
        }
    }

    public static void setJavaElementArray(Map arguments, String countAttribute, String arrayAttributePrefix, String project, IJavaElement[] elements, int offset) throws IllegalArgumentException {
        if (elements == null) {
            throw new IllegalArgumentException("The elements for arrayAttribute '" + arrayAttributePrefix + "' may not be null");
        }
        if (countAttribute != null) {
            JavaRefactoringDescriptorUtil.setInt(arguments, countAttribute, elements.length);
        }
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            JavaRefactoringDescriptorUtil.setJavaElement(arguments, JavaRefactoringDescriptorUtil.getAttributeName(arrayAttributePrefix, offset + i), project, element);
            ++i;
        }
    }
}

