/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.macbundler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.macbundler.BundleAttributes;
import org.eclipse.jdt.internal.ui.macbundler.BundleDescription;
import org.eclipse.jdt.internal.ui.macbundler.ResourceInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BundleBuilder
implements BundleAttributes {
    private List<Process> fProcesses = new ArrayList<Process>();
    private BundleDescription fBundleDescription;

    public void createBundle(BundleDescription bd, IProgressMonitor pm) throws IOException {
        String app_dir_name;
        this.fBundleDescription = bd;
        File tmp_dir = new File(bd.get("DestinationDirectory"));
        File app_dir = new File(tmp_dir, app_dir_name = String.valueOf(bd.get("AppName")) + ".app");
        if (app_dir.exists()) {
            BundleBuilder.deleteDir(app_dir);
        }
        app_dir = this.createDir(tmp_dir, app_dir_name, false);
        File contents_dir = this.createDir(app_dir, "Contents", false);
        this.createPkgInfo(contents_dir);
        File macos_dir = this.createDir(contents_dir, "MacOS", false);
        String launcher_path = bd.get("CFBundleExecutable");
        if (launcher_path == null) {
            throw new IOException();
        }
        String launcher = this.copyFile(macos_dir, launcher_path, null);
        File resources_dir = this.createDir(contents_dir, "Resources", false);
        File java_dir = this.createDir(resources_dir, "Java", false);
        this.createInfoPList(contents_dir, resources_dir, java_dir, launcher);
        for (Process p : this.fProcesses) {
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void createInfoPList(File contents_dir, File resources_dir, File java_dir, String launcher) throws IOException {
        String arguments;
        String fname;
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("createInfoPList: could not get XML builder");
            throw new IOException("Could not get XML builder");
        }
        Document doc = docBuilder.newDocument();
        Element plist = doc.createElement("plist");
        doc.appendChild(plist);
        plist.setAttribute("version", "1.0");
        Element dict = doc.createElement("dict");
        plist.appendChild(dict);
        this.pair(dict, "CFBundleExecutable", null, launcher);
        this.pair(dict, "CFBundleGetInfoString", "GetInfo", null);
        this.pair(dict, "CFBundleInfoDictionaryVersion", null, "6.0");
        String iconName = null;
        String appName = this.fBundleDescription.get("AppName", null);
        if (appName != null) {
            iconName = String.valueOf(appName) + ".icns";
        }
        if ((fname = this.copyFile(resources_dir, this.fBundleDescription.get("IconFile", null), iconName)) != null) {
            this.pair(dict, "CFBundleIconFile", null, fname);
        }
        this.pair(dict, "CFBundleIdentifier", "Identifier", null);
        this.pair(dict, "CFBundleName", "AppName", null);
        this.pair(dict, "CFBundlePackageType", null, "APPL");
        this.pair(dict, "CFBundleShortVersionString", "Version", null);
        this.pair(dict, "CFBundleSignature", "Signature", "????");
        this.pair(dict, "CFBundleVersion", null, "1.0.1");
        Element jdict = doc.createElement("dict");
        this.add(dict, "Java", jdict);
        this.pair(jdict, "JVMVersion", "JVMVersion", null);
        this.pair(jdict, "MainClass", "MainClass", null);
        this.pair(jdict, "WorkingDirectory", "WorkingDir", null);
        if (this.fBundleDescription.get("UsesSWT", false)) {
            this.addTrue(jdict, "StartOnMainThread");
        }
        if ((arguments = this.fBundleDescription.get("Arguments", null)) != null) {
            Element argArray = doc.createElement("array");
            this.add(jdict, "Arguments", argArray);
            StringTokenizer st = new StringTokenizer(arguments);
            while (st.hasMoreTokens()) {
                String arg = st.nextToken();
                Element type = doc.createElement("string");
                argArray.appendChild(type);
                type.appendChild(doc.createTextNode(arg));
            }
        }
        this.pair(jdict, "VMOptions", "VMOptions", null);
        int[] id = new int[1];
        ResourceInfo[] ris = this.fBundleDescription.getResources(true);
        if (ris.length > 0) {
            StringBuffer cp = new StringBuffer();
            int i = 0;
            while (i < ris.length) {
                ResourceInfo ri = ris[i];
                String e = this.processClasspathEntry(java_dir, ri.fPath, id);
                if (cp.length() > 0) {
                    cp.append(':');
                }
                cp.append(e);
                ++i;
            }
            this.add(jdict, "ClassPath", cp.toString());
        }
        if ((ris = this.fBundleDescription.getResources(false)).length > 0) {
            int i = 0;
            while (i < ris.length) {
                ResourceInfo ri = ris[i];
                this.processClasspathEntry(java_dir, ri.fPath, id);
                ++i;
            }
        }
        File info = new File(contents_dir, "Info.plist");
        FileOutputStream fos = new FileOutputStream(info);
        BufferedOutputStream fOutputStream = new BufferedOutputStream(fos);
        try {
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("doctype-public", "-//Apple Computer//DTD PLIST 1.0//EN");
                transformer.setOutputProperty("doctype-system", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(fOutputStream);
                transformer.transform(source, result);
            }
            catch (TransformerException transformerException) {
                System.err.println("createInfoPList: could not transform to XML");
                fOutputStream.close();
            }
        }
        finally {
            fOutputStream.close();
        }
    }

    private void add(Element dict, String key, Element value) {
        Document document = dict.getOwnerDocument();
        Element k = document.createElement("key");
        dict.appendChild(k);
        k.appendChild(document.createTextNode(key));
        dict.appendChild(value);
    }

    private void create(Element parent, String s) {
        Document document = parent.getOwnerDocument();
        Element type = document.createElement("string");
        parent.appendChild(type);
        type.appendChild(document.createTextNode(s));
    }

    private void createTrue(Element parent) {
        Document document = parent.getOwnerDocument();
        Element type = document.createElement("true");
        parent.appendChild(type);
    }

    private void add(Element dict, String key, String value) {
        Document document = dict.getOwnerDocument();
        Element k = document.createElement("key");
        dict.appendChild(k);
        k.appendChild(document.createTextNode(key));
        this.create(dict, value);
    }

    private void addTrue(Element dict, String key) {
        Document document = dict.getOwnerDocument();
        Element k = document.createElement("key");
        dict.appendChild(k);
        k.appendChild(document.createTextNode(key));
        this.createTrue(dict);
    }

    private void pair(Element dict, String outkey, String inkey, String dflt) {
        String value = null;
        value = inkey != null ? this.fBundleDescription.get(inkey, dflt) : dflt;
        if (value != null && value.trim().length() > 0) {
            this.add(dict, outkey, value);
        }
    }

    private String processClasspathEntry(File java_dir, String name, int[] id_ref) throws IOException {
        File f = new File(name);
        if (f.isDirectory()) {
            int n = id_ref[0];
            id_ref[0] = n + 1;
            int id = n;
            String archivename = "jar_" + id + ".jar";
            File to = new File(java_dir, archivename);
            this.zip(name, to.getAbsolutePath());
            name = archivename;
        } else {
            name = this.copyFile(java_dir, name, null);
        }
        return "$JAVAROOT/" + name;
    }

    private void createPkgInfo(File contents_dir) throws IOException {
        File pkgInfo = new File(contents_dir, "PkgInfo");
        FileOutputStream os = new FileOutputStream(pkgInfo);
        os.write(("APPL" + this.fBundleDescription.get("Signature", "????")).getBytes());
        os.close();
    }

    private static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                BundleBuilder.deleteDir(files[i]);
                ++i;
            }
        }
        dir.delete();
    }

    private File createDir(File parent_dir, String dir_name, boolean remove) throws IOException {
        File dir = new File(parent_dir, dir_name);
        if (dir.exists()) {
            if (!remove) {
                return dir;
            }
            BundleBuilder.deleteDir(dir);
        }
        if (!dir.mkdir()) {
            throw new IOException("cannot create dir " + dir_name);
        }
        return dir;
    }

    private String copyFile(File todir, String fromPath, String toname) throws IOException {
        if (toname == null) {
            int pos = fromPath.lastIndexOf(47);
            toname = pos >= 0 ? fromPath.substring(pos + 1) : fromPath;
        }
        File to = new File(todir, toname);
        this.fProcesses.add(Runtime.getRuntime().exec(new String[]{"/bin/cp", fromPath, to.getAbsolutePath()}));
        return toname;
    }

    private void zip(String dir, String dest) throws IOException {
        this.fProcesses.add(Runtime.getRuntime().exec(new String[]{"/usr/bin/jar", "cf", dest, "-C", dir, "."}));
    }
}

