/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.macosx;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacOSXLaunchingPlugin
extends Plugin {
    private static MacOSXLaunchingPlugin fgPlugin;
    private static final String RESOURCE_BUNDLE = "org.eclipse.jdt.internal.launching.macosx.MacOSXLauncherMessages";
    private static ResourceBundle fgResourceBundle;

    static {
        fgResourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
    }

    public MacOSXLaunchingPlugin() {
        Assert.isTrue((fgPlugin == null ? 1 : 0) != 0);
        fgPlugin = this;
    }

    public static MacOSXLaunchingPlugin getDefault() {
        return fgPlugin;
    }

    static String getString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
    }

    static String getUniqueIdentifier() {
        if (MacOSXLaunchingPlugin.getDefault() == null) {
            return "org.eclipse.jdt.launching.macosx";
        }
        return MacOSXLaunchingPlugin.getDefault().getBundle().getSymbolicName();
    }

    static String[] wrap(Class<?> clazz, String[] cmdLine) {
        int i = 0;
        while (i < cmdLine.length) {
            if (MacOSXLaunchingPlugin.useSWT(cmdLine[i])) {
                return MacOSXLaunchingPlugin.createSWTlauncher(clazz, cmdLine, cmdLine[0]);
            }
            ++i;
        }
        return cmdLine;
    }

    private static boolean useSWT(String arg) {
        return arg.indexOf("swt.jar") >= 0 || arg.indexOf("org.eclipse.swt") >= 0 || "-ws".equals(arg);
    }

    static String[] createSWTlauncher(Class<?> clazz, String[] cmdLine, String vmVersion) {
        String java_swt = System.getProperty("org.eclipse.swtlauncher");
        if (java_swt == null) {
            String[] newCmdLine = new String[cmdLine.length + 1];
            int argCount = 0;
            newCmdLine[argCount++] = cmdLine[0];
            newCmdLine[argCount++] = "-XstartOnFirstThread";
            int i = 1;
            while (i < cmdLine.length) {
                newCmdLine[argCount++] = cmdLine[i];
                ++i;
            }
            return newCmdLine;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/cp", java_swt, "/tmp"});
            process.waitFor();
            java_swt = "/tmp/java_swt";
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
        String[] newCmdLine = new String[cmdLine.length + 1];
        int argCount = 0;
        newCmdLine[argCount++] = java_swt;
        newCmdLine[argCount++] = "-XXvm=" + vmVersion;
        int i = 1;
        while (i < cmdLine.length) {
            newCmdLine[argCount++] = cmdLine[i];
            ++i;
        }
        return newCmdLine;
    }
}

