/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsModelMessages;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;

public class ImageDescriptorRegistry {
    private HashMap fRegistry = new HashMap(10);
    private Display fDisplay;

    public ImageDescriptorRegistry() {
        this(ExternalToolsPlugin.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.fDisplay == ExternalToolsPlugin.getStandardDisplay() ? 1 : 0) != 0, (String)ExternalToolsModelMessages.ImageDescriptorRegistry_Allocating_image_for_wrong_display_1);
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.fRegistry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.disposeExec(new Runnable(){

            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }
}

