/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.ui.internal.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.apt.ui.internal.preferences.AdvancedFactoryPathOptionsDialog;
import org.eclipse.jdt.apt.ui.internal.preferences.BaseConfigurationBlock;
import org.eclipse.jdt.apt.ui.internal.preferences.Messages;
import org.eclipse.jdt.apt.ui.internal.util.ExceptionHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryPathConfigurationBlock
extends BaseConfigurationBlock {
    private static final int IDX_UP = 0;
    private static final int IDX_DOWN = 1;
    private static final int IDX_ADDJAR = 3;
    private static final int IDX_ADDEXTJAR = 4;
    private static final int IDX_ADDVAR = 5;
    private static final int IDX_EDIT = 7;
    private static final int IDX_ADVANCED = 8;
    private static final int IDX_REMOVE = 9;
    private static final int IDX_ENABLEALL = 11;
    private static final int IDX_DISABLEALL = 12;
    private static final String[] buttonLabels;
    private PixelConverter fPixelConverter;
    private Composite fBlockControl;
    private List<FactoryPathEntry> fOriginalPath;
    private final IJavaProject fJProj;
    private CheckedListDialogField<FactoryPathEntry> fFactoryPathList;
    private boolean fSettingListContents = false;

    static {
        String[] stringArray = new String[13];
        stringArray[0] = Messages.FactoryPathConfigurationBlock_up;
        stringArray[1] = Messages.FactoryPathConfigurationBlock_down;
        stringArray[3] = Messages.FactoryPathConfigurationBlock_addJars;
        stringArray[4] = Messages.FactoryPathConfigurationBlock_addExternalJars;
        stringArray[5] = Messages.FactoryPathConfigurationBlock_addVariable;
        stringArray[7] = Messages.FactoryPathConfigurationBlock_edit;
        stringArray[8] = Messages.FactoryPathConfigurationBlock_advanced;
        stringArray[9] = Messages.FactoryPathConfigurationBlock_remove;
        stringArray[11] = Messages.FactoryPathConfigurationBlock_enableAll;
        stringArray[12] = Messages.FactoryPathConfigurationBlock_disableAll;
        buttonLabels = stringArray;
    }

    public FactoryPathConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, new BaseConfigurationBlock.Key[0], container);
        this.fJProj = JavaCore.create((IProject)project);
        FactoryPathAdapter adapter = new FactoryPathAdapter();
        FactoryPathLabelProvider labelProvider = new FactoryPathLabelProvider();
        this.fFactoryPathList = new CheckedListDialogField((IListAdapter)adapter, buttonLabels, (ILabelProvider)labelProvider);
        this.fFactoryPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fFactoryPathList.setLabelText(Messages.FactoryPathConfigurationBlock_pluginsAndJars);
        this.fFactoryPathList.setUpButtonIndex(0);
        this.fFactoryPathList.setDownButtonIndex(1);
        this.fFactoryPathList.setRemoveButtonIndex(9);
        this.fFactoryPathList.setCheckAllButtonIndex(11);
        this.fFactoryPathList.setUncheckAllButtonIndex(12);
    }

    private void updateFactoryPathEntries() {
        for (FactoryPathEntry fpe : this.getListContents()) {
            boolean checked = this.fFactoryPathList.isChecked((Object)fpe);
            if (checked == fpe._attr.isEnabled()) continue;
            fpe._attr.setEnabled(checked);
        }
    }

    public void customButtonPressed(int index) {
        FactoryPathEntry[] newEntries = null;
        switch (index) {
            case 3: {
                newEntries = this.openJarFileDialog(null);
                this.addEntries(newEntries);
                break;
            }
            case 4: {
                newEntries = this.openExtJarFileDialog(null);
                this.addEntries(newEntries);
                break;
            }
            case 5: {
                newEntries = this.openVariableSelectionDialog(null);
                this.addEntries(newEntries);
                break;
            }
            case 7: {
                if (!this.canEdit()) break;
                this.editSelectedItem();
                break;
            }
            case 8: {
                this.advancedOptionsDialog();
            }
        }
    }

    private boolean canRemove() {
        List<FactoryPathEntry> selected = this.getSelectedListContents();
        boolean containsPlugin = false;
        for (FactoryPathEntry fpe : selected) {
            if (fpe._fc.getType() != FactoryContainer.FactoryType.PLUGIN) continue;
            containsPlugin = true;
            break;
        }
        return !containsPlugin;
    }

    private boolean canEdit() {
        List<FactoryPathEntry> selected = this.getSelectedListContents();
        if (selected.size() != 1) {
            return false;
        }
        FactoryContainer fc = selected.get((int)0)._fc;
        return fc.getType() != FactoryContainer.FactoryType.PLUGIN;
    }

    private boolean canAdvanced() {
        List<FactoryPathEntry> selected = this.getSelectedListContents();
        return selected.size() == 1;
    }

    private void editSelectedItem() {
        List<FactoryPathEntry> selected = this.getSelectedListContents();
        if (selected.size() != 1) {
            return;
        }
        FactoryPathEntry original = selected.get(0);
        FactoryPathEntry[] edited = null;
        switch (original._fc.getType()) {
            case PLUGIN: {
                return;
            }
            case EXTJAR: {
                edited = this.openExtJarFileDialog(original);
                break;
            }
            case VARJAR: {
                edited = this.openVariableSelectionDialog(original);
                break;
            }
            case WKSPJAR: {
                edited = this.openJarFileDialog(original);
            }
        }
        if (edited != null && edited.length > 0) {
            this.fFactoryPathList.replaceElement((Object)original, (Object)edited[0]);
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.fBlockControl = new Composite(parent, 0);
        this.fBlockControl.setFont(parent.getFont());
        Dialog.applyDialogFont((Control)this.fBlockControl);
        LayoutUtil.doDefaultLayout((Composite)this.fBlockControl, (DialogField[])new DialogField[]{this.fFactoryPathList}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fFactoryPathList.getListControl(null));
        this.fFactoryPathList.enableButton(3, this.fJProj != null);
        this.fFactoryPathList.enableButton(8, false);
        this.fFactoryPathList.enableButton(7, false);
        int buttonBarWidth = this.fPixelConverter.convertWidthInCharsToPixels(24);
        this.fFactoryPathList.setButtonsMinWidth(buttonBarWidth);
        return this.fBlockControl;
    }

    @Override
    public boolean hasProjectSpecificOptionsNoCache(IProject project) {
        return project == null ? false : AptConfig.hasProjectSpecificFactoryPath((IJavaProject)JavaCore.create((IProject)project));
    }

    @Override
    protected void initContents() {
        this.setListContents(this.fOriginalPath);
    }

    @Override
    protected void cacheOriginalValues() {
        IFactoryPath ifp = AptConfig.getFactoryPath((IJavaProject)this.fJProj);
        FactoryPath fp = (FactoryPath)ifp;
        Map path = fp.getAllContainers();
        this.fOriginalPath = FactoryPathEntry.pathListFromMap(path);
        super.cacheOriginalValues();
    }

    private List<FactoryPathEntry> getListContents() {
        List contents = this.fFactoryPathList.getElements();
        return contents;
    }

    private List<FactoryPathEntry> getSelectedListContents() {
        List contents = this.fFactoryPathList.getSelectedElements();
        return contents;
    }

    private void addEntries(FactoryPathEntry[] entries) {
        if (entries == null) {
            return;
        }
        List<FactoryPathEntry> selectedElements = this.getSelectedListContents();
        int insertAt = selectedElements.size() == 1 ? this.fFactoryPathList.getIndexOfElement((Object)selectedElements.get(0)) + 1 : this.fFactoryPathList.getSize();
        try {
            this.fSettingListContents = true;
            int i = 0;
            while (i < entries.length) {
                this.fFactoryPathList.addElement((Object)entries[i], insertAt + i);
                this.fFactoryPathList.setChecked((Object)entries[i], entries[i]._attr.isEnabled());
                ++i;
            }
        }
        finally {
            this.fSettingListContents = false;
        }
    }

    private void setListContents(List<FactoryPathEntry> fpeList) {
        try {
            this.fSettingListContents = true;
            this.fFactoryPathList.removeAllElements();
            if (fpeList == null) {
                return;
            }
            for (FactoryPathEntry originalFpe : fpeList) {
                FactoryPathEntry fpe = new FactoryPathEntry(originalFpe._fc, new FactoryPath.Attributes(originalFpe._attr));
                this.fFactoryPathList.addElement((Object)fpe);
                this.fFactoryPathList.setChecked((Object)fpe, fpe._attr.isEnabled());
            }
        }
        finally {
            this.fSettingListContents = false;
        }
    }

    private IPath[] getExistingPaths(FactoryContainer.FactoryType type, FactoryContainer ignore) {
        if (type == FactoryContainer.FactoryType.PLUGIN) {
            throw new IllegalArgumentException();
        }
        List<FactoryPathEntry> all = this.getListContents();
        int countType = 0;
        for (FactoryPathEntry fpe : all) {
            FactoryContainer fc = fpe._fc;
            if (fc.getType() != type || fc == ignore) continue;
            ++countType;
        }
        IPath[] some = new IPath[countType];
        int i = 0;
        for (FactoryPathEntry fpe : all) {
            FactoryContainer fc = fpe._fc;
            if (fc.getType() != type || fc == ignore) continue;
            some[i++] = new Path(fc.getId());
        }
        return some;
    }

    private void advancedOptionsDialog() {
        List<FactoryPathEntry> selected = this.getSelectedListContents();
        if (selected.size() != 1) {
            return;
        }
        FactoryPathEntry original = selected.get(0);
        AdvancedFactoryPathOptionsDialog dialog = new AdvancedFactoryPathOptionsDialog(this.getShell(), original._fc, original._attr);
        if (dialog.open() == 0) {
            original._attr = dialog.getResult();
        }
    }

    private FactoryPathEntry[] openJarFileDialog(FactoryPathEntry original) {
        if (this.fJProj == null) {
            return null;
        }
        IWorkspaceRoot root = this.fJProj.getProject().getWorkspace().getRoot();
        if (original == null) {
            IPath[] results = BuildPathDialogAccess.chooseJAREntries((Shell)this.getShell(), (IPath)this.fJProj.getPath(), (IPath[])new IPath[0]);
            if (results == null) {
                return null;
            }
            ArrayList<FactoryPathEntry> res = new ArrayList<FactoryPathEntry>();
            int i = 0;
            while (i < results.length) {
                IResource resource = root.findMember(results[i]);
                if (resource instanceof IFile) {
                    FactoryContainer fc = FactoryPathUtil.newWkspJarFactoryContainer((IPath)results[i]);
                    FactoryPath.Attributes attr = new FactoryPath.Attributes(true, false);
                    FactoryPathEntry fpe = new FactoryPathEntry(fc, attr);
                    res.add(fpe);
                }
                ++i;
            }
            return res.toArray(new FactoryPathEntry[res.size()]);
        }
        IPath[] existingPaths = this.getExistingPaths(FactoryContainer.FactoryType.WKSPJAR, original._fc);
        IPath result = BuildPathDialogAccess.configureJAREntry((Shell)this.getShell(), (IPath)new Path(original._fc.getId()), (IPath[])existingPaths);
        if (result == null) {
            return null;
        }
        IResource resource = root.findMember(result);
        if (resource instanceof IFile) {
            FactoryPathEntry[] edited = new FactoryPathEntry[1];
            FactoryContainer fc = FactoryPathUtil.newWkspJarFactoryContainer((IPath)result);
            FactoryPath.Attributes attr = new FactoryPath.Attributes(original._attr.isEnabled(), false);
            edited[0] = new FactoryPathEntry(fc, attr);
            return edited;
        }
        return null;
    }

    private FactoryPathEntry[] openExtJarFileDialog(FactoryPathEntry original) {
        if (original == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries((Shell)this.getShell());
            if (selected == null) {
                return null;
            }
            ArrayList<FactoryPathEntry> res = new ArrayList<FactoryPathEntry>();
            int i = 0;
            while (i < selected.length) {
                FactoryContainer fc = FactoryPathUtil.newExtJarFactoryContainer((File)selected[i].toFile());
                FactoryPath.Attributes attr = new FactoryPath.Attributes(true, false);
                FactoryPathEntry fpe = new FactoryPathEntry(fc, attr);
                res.add(fpe);
                ++i;
            }
            return res.toArray(new FactoryPathEntry[res.size()]);
        }
        IPath result = BuildPathDialogAccess.configureExternalJAREntry((Shell)this.getShell(), (IPath)new Path(original._fc.getId()));
        if (result == null) {
            return null;
        }
        FactoryPathEntry[] edited = new FactoryPathEntry[1];
        FactoryContainer fc = FactoryPathUtil.newExtJarFactoryContainer((File)result.toFile());
        FactoryPath.Attributes attr = new FactoryPath.Attributes(original._attr.isEnabled(), false);
        edited[0] = new FactoryPathEntry(fc, attr);
        return edited;
    }

    private FactoryPathEntry[] openVariableSelectionDialog(FactoryPathEntry original) {
        if (original == null) {
            IPath[] selected = BuildPathDialogAccess.chooseVariableEntries((Shell)this.getShell(), (IPath[])new IPath[0]);
            if (selected == null) {
                return null;
            }
            ArrayList<FactoryPathEntry> res = new ArrayList<FactoryPathEntry>();
            int i = 0;
            while (i < selected.length) {
                FactoryContainer fc = FactoryPathUtil.newVarJarFactoryContainer((IPath)selected[i]);
                FactoryPath.Attributes attr = new FactoryPath.Attributes(true, false);
                FactoryPathEntry fpe = new FactoryPathEntry(fc, attr);
                res.add(fpe);
                ++i;
            }
            return res.toArray(new FactoryPathEntry[res.size()]);
        }
        IPath[] existingPaths = this.getExistingPaths(FactoryContainer.FactoryType.VARJAR, original._fc);
        IPath result = BuildPathDialogAccess.configureVariableEntry((Shell)this.getShell(), (IPath)new Path(original._fc.getId()), (IPath[])existingPaths);
        if (result == null) {
            return null;
        }
        FactoryPathEntry[] edited = new FactoryPathEntry[1];
        FactoryContainer fc = FactoryPathUtil.newVarJarFactoryContainer((IPath)result);
        FactoryPath.Attributes attr = new FactoryPath.Attributes(original._attr.isEnabled(), false);
        edited[0] = new FactoryPathEntry(fc, attr);
        return edited;
    }

    @Override
    protected void updateModel(DialogField field) {
    }

    @Override
    protected void validateSettings(BaseConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    @Override
    protected void saveSettings() {
        FactoryPath fp;
        if (this.fJProj != null && !this.fBlockControl.isEnabled()) {
            fp = null;
        } else {
            List<FactoryPathEntry> containers = this.getListContents();
            Map<FactoryContainer, FactoryPath.Attributes> map = FactoryPathEntry.pathMapFromList(containers);
            fp = new FactoryPath();
            fp.setContainers(map);
        }
        try {
            AptConfig.setFactoryPath((IJavaProject)this.fJProj, (IFactoryPath)fp);
        }
        catch (CoreException e) {
            String title = Messages.FactoryPathConfigurationBlock_unableToSaveFactorypath_title;
            String message = Messages.FactoryPathConfigurationBlock_unableToSaveFactorypath_message;
            ExceptionHandler.handle(e, this.fBlockControl.getShell(), title, message);
        }
        super.saveSettings();
    }

    @Override
    public void performDefaults() {
        IFactoryPath ifp = AptConfig.getDefaultFactoryPath((IJavaProject)this.fJProj);
        FactoryPath fp = (FactoryPath)ifp;
        Map map = fp.getAllContainers();
        List<FactoryPathEntry> defaults = FactoryPathEntry.pathListFromMap(map);
        this.setListContents(defaults);
        super.performDefaults();
    }

    @Override
    protected boolean settingsChanged(IScopeContext currContext) {
        if (this.fOriginalPath == null) {
            return true;
        }
        List<FactoryPathEntry> newPath = this.getListContents();
        return !this.fOriginalPath.equals(newPath);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FactoryPathAdapter
    implements IListAdapter<FactoryPathEntry>,
    IDialogFieldListener {
        private FactoryPathAdapter() {
        }

        public void customButtonPressed(ListDialogField<FactoryPathEntry> field, int index) {
            FactoryPathConfigurationBlock.this.customButtonPressed(index);
        }

        public void selectionChanged(ListDialogField<FactoryPathEntry> field) {
            boolean enableRemove = FactoryPathConfigurationBlock.this.canRemove();
            field.enableButton(9, enableRemove);
            boolean enableEdit = FactoryPathConfigurationBlock.this.canEdit();
            field.enableButton(7, enableEdit);
            boolean enableAdvanced = FactoryPathConfigurationBlock.this.canAdvanced();
            field.enableButton(8, enableAdvanced);
        }

        public void dialogFieldChanged(DialogField field) {
            if (!FactoryPathConfigurationBlock.this.fSettingListContents) {
                FactoryPathConfigurationBlock.this.updateFactoryPathEntries();
            }
        }

        public void doubleClicked(ListDialogField<FactoryPathEntry> field) {
            if (FactoryPathConfigurationBlock.this.canEdit()) {
                FactoryPathConfigurationBlock.this.editSelectedItem();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FactoryPathEntry {
        public final FactoryContainer _fc;
        public FactoryPath.Attributes _attr;

        public FactoryPathEntry(FactoryContainer fc, FactoryPath.Attributes attr) {
            this._fc = fc;
            this._attr = attr;
        }

        public static Map<FactoryContainer, FactoryPath.Attributes> pathMapFromList(List<FactoryPathEntry> list) {
            LinkedHashMap<FactoryContainer, FactoryPath.Attributes> map = new LinkedHashMap<FactoryContainer, FactoryPath.Attributes>(list.size());
            for (FactoryPathEntry fpe : list) {
                map.put(fpe._fc, fpe._attr);
            }
            return map;
        }

        public static List<FactoryPathEntry> pathListFromMap(Map<FactoryContainer, FactoryPath.Attributes> map) {
            ArrayList<FactoryPathEntry> list = new ArrayList<FactoryPathEntry>(map.size());
            for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : map.entrySet()) {
                FactoryPathEntry fpe = new FactoryPathEntry(entry.getKey(), entry.getValue());
                list.add(fpe);
            }
            return list;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FactoryPathEntry)) {
                return false;
            }
            FactoryPathEntry fpe = (FactoryPathEntry)obj;
            return this._fc.equals((Object)fpe._fc) && this._attr.equals((Object)fpe._attr);
        }

        public int hashCode() {
            return this._fc.hashCode() ^ this._attr.hashCode();
        }
    }

    private class FactoryPathLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FactoryPathLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof FactoryPathEntry)) {
                return "";
            }
            FactoryPathEntry fpe = (FactoryPathEntry)element;
            if (columnIndex == 0) {
                return fpe._fc.toString();
            }
            return "";
        }
    }
}

