/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestCaseElement;

public class TestRunListenerAdapter
implements ITestSessionListener {
    private final TestRunSession fSession;

    public TestRunListenerAdapter(TestRunSession session) {
        this.fSession = session;
    }

    private Object[] getListeners() {
        return JUnitCorePlugin.getDefault().getNewTestRunListeners().getListeners();
    }

    private void fireSessionStarted() {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((TestRunListener)listeners[i]).sessionStarted(this.fSession);
            ++i;
        }
    }

    private void fireSessionFinished() {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((TestRunListener)listeners[i]).sessionFinished(this.fSession);
            ++i;
        }
    }

    private void fireTestCaseStarted(ITestCaseElement testCaseElement) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((TestRunListener)listeners[i]).testCaseStarted(testCaseElement);
            ++i;
        }
    }

    private void fireTestCaseFinished(ITestCaseElement testCaseElement) {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((TestRunListener)listeners[i]).testCaseFinished(testCaseElement);
            ++i;
        }
    }

    public void sessionStarted() {
    }

    public void sessionEnded(long elapsedTime) {
        this.fireSessionFinished();
        this.fSession.swapOut();
    }

    public void sessionStopped(long elapsedTime) {
        this.fireSessionFinished();
        this.fSession.swapOut();
    }

    public void sessionTerminated() {
        this.fSession.swapOut();
    }

    public void testAdded(TestElement testElement) {
    }

    public void runningBegins() {
        this.fireSessionStarted();
    }

    public void testStarted(TestCaseElement testCaseElement) {
        this.fireTestCaseStarted(testCaseElement);
    }

    public void testEnded(TestCaseElement testCaseElement) {
        this.fireTestCaseFinished(testCaseElement);
    }

    public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
    }

    public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
    }

    public boolean acceptsSwapToDisk() {
        return true;
    }
}

