/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.util.DeclarationVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationMirrorImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.env.AnnotationInvocationHandler;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EclipseDeclarationImpl
implements Declaration,
EclipseMirrorObject {
    final BaseProcessorEnv _env;

    EclipseDeclarationImpl(BaseProcessorEnv env) {
        assert (env != null) : "missing environment";
        this._env = env;
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitDeclaration(this);
    }

    <A extends Annotation> A _getAnnotation(Class<A> annotationClass, IAnnotationBinding[] annoInstances) {
        if (annoInstances == null || annoInstances.length == 0 || annotationClass == null) {
            return null;
        }
        String annoTypeName = annotationClass.getName();
        if (annoTypeName == null) {
            return null;
        }
        annoTypeName = annoTypeName.replace('$', '.');
        IAnnotationBinding[] iAnnotationBindingArray = annoInstances;
        int n = annoInstances.length;
        int n2 = 0;
        while (n2 < n) {
            String curTypeName;
            ITypeBinding binding;
            IAnnotationBinding annoInstance = iAnnotationBindingArray[n2];
            if (annoInstance != null && (binding = annoInstance.getAnnotationType()) != null && binding.isAnnotation() && annoTypeName.equals(curTypeName = binding.getQualifiedName())) {
                AnnotationMirrorImpl annoMirror = (AnnotationMirrorImpl)Factory.createAnnotationMirror(annoInstance, this, this._env);
                AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annoMirror, annotationClass);
                return (A)((Annotation)Proxy.newProxyInstance(annotationClass.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)handler));
            }
            ++n2;
        }
        return null;
    }

    Collection<AnnotationMirror> _getAnnotationMirrors(IAnnotationBinding[] annoInstances) {
        if (annoInstances == null || annoInstances.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>(annoInstances.length);
        IAnnotationBinding[] iAnnotationBindingArray = annoInstances;
        int n = annoInstances.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annoInstance = iAnnotationBindingArray[n2];
            if (annoInstance != null) {
                AnnotationMirrorImpl annoMirror = (AnnotationMirrorImpl)Factory.createAnnotationMirror(annoInstance, this, this._env);
                result.add(annoMirror);
            }
            ++n2;
        }
        return result;
    }

    Collection<AnnotationMirror> _getAnnotationMirrors(List<org.eclipse.jdt.core.dom.Annotation> annoInstances) {
        if (annoInstances == null || annoInstances.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>(annoInstances.size());
        for (org.eclipse.jdt.core.dom.Annotation annoInstance : annoInstances) {
            if (annoInstance == null) continue;
            AnnotationMirrorImpl annoMirror = (AnnotationMirrorImpl)Factory.createAnnotationMirror(annoInstance.resolveAnnotationBinding(), this, this._env);
            result.add(annoMirror);
        }
        return result;
    }

    abstract ASTNode getAstNode();

    abstract CompilationUnit getCompilationUnit();

    public abstract IFile getResource();

    public abstract boolean isFromSource();

    public abstract boolean isBindingBased();

    @Override
    public BaseProcessorEnv getEnvironment() {
        return this._env;
    }

    protected ASTNode getRangeNode() {
        ASTNode node = this.getAstNode();
        if (node == null) {
            return null;
        }
        SimpleName name = null;
        block0 : switch (node.getNodeType()) {
            case 55: 
            case 71: 
            case 81: {
                name = ((AbstractTypeDeclaration)node).getName();
                break;
            }
            case 82: {
                name = ((AnnotationTypeMemberDeclaration)node).getName();
                break;
            }
            case 31: {
                name = ((MethodDeclaration)node).getName();
                break;
            }
            case 44: {
                name = ((SingleVariableDeclaration)node).getName();
                break;
            }
            case 23: {
                String declName = this.getSimpleName();
                if (declName == null) {
                    return node;
                }
                for (Object obj : ((FieldDeclaration)node).fragments()) {
                    VariableDeclarationFragment frag = (VariableDeclarationFragment)obj;
                    if (!declName.equals(frag.getName())) continue;
                    name = frag.getName();
                    break block0;
                }
                break;
            }
            case 72: {
                name = ((EnumConstantDeclaration)node).getName();
                break;
            }
            default: {
                return node;
            }
        }
        if (name == null) {
            return node;
        }
        return name;
    }

    protected String getDocComment(BodyDeclaration decl) {
        Javadoc javaDoc = decl.getJavadoc();
        if (javaDoc == null) {
            return "";
        }
        return javaDoc.toString();
    }
}

