/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.AbstractConformanceVisitor;
import org.eclipse.xtext.common.types.util.AnyTypeConformanceStrategy;
import org.eclipse.xtext.common.types.util.GenericArrayConformanceStrategy;
import org.eclipse.xtext.common.types.util.MultiTypeConformanceStrategy;
import org.eclipse.xtext.common.types.util.ParameterizedTypeConformanceStrategy;
import org.eclipse.xtext.common.types.util.SynonymConformanceStrategy;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.common.types.util.TypeConformanceStrategy;
import org.eclipse.xtext.common.types.util.UnknownConformanceStrategy;
import org.eclipse.xtext.common.types.util.WildcardConformanceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConformanceStrategySelector
extends AbstractConformanceVisitor<JvmTypeReference> {
    private final TypeConformanceComputer conformanceComputer;
    private final TypeConformanceStrategy<JvmAnyTypeReference> anyTypeDispatcher;
    private final TypeConformanceStrategy<JvmGenericArrayTypeReference> genericArrayTypeDispatcher;
    private final TypeConformanceStrategy<JvmMultiTypeReference> multiTypeDispatcher;
    private final TypeConformanceStrategy<JvmParameterizedTypeReference> parameterizedTypeDispatcher;
    private final TypeConformanceStrategy<JvmSynonymTypeReference> synonymTypeDispatcher;
    private final TypeConformanceStrategy<JvmUnknownTypeReference> unknownTypeDispatcher;
    private final TypeConformanceStrategy<JvmWildcardTypeReference> wildcardTypeDispatcher;

    public TypeConformanceStrategySelector(TypeConformanceComputer typeConformanceComputer) {
        this.conformanceComputer = typeConformanceComputer;
        this.anyTypeDispatcher = this.createAnyTypeDispatcher();
        this.genericArrayTypeDispatcher = this.createGenericArrayTypeDispatcher();
        this.multiTypeDispatcher = this.createMultiTypeDispatcher();
        this.parameterizedTypeDispatcher = this.createParameterizedTypeDispatcher();
        this.synonymTypeDispatcher = this.createSynonymTypeDispatcher();
        this.unknownTypeDispatcher = this.createUnknownTypeDispatcher();
        this.wildcardTypeDispatcher = this.createWildcardTypeDispatcher();
    }

    protected <T extends JvmTypeReference> TypeConformanceComputationArgument.Internal<T> copyArgument(T t, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return TypeConformanceComputationArgument.Internal.create(t, param.rawType, param.asTypeArgument, param.allowPrimitiveConversion);
    }

    @Override
    public TypeConformanceResult doVisitAnyTypeReference(JvmAnyTypeReference reference, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return (TypeConformanceResult)this.anyTypeDispatcher.visit((JvmTypeReference)param.reference, this.copyArgument(reference, param));
    }

    @Override
    public TypeConformanceResult doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return (TypeConformanceResult)this.genericArrayTypeDispatcher.visit((JvmTypeReference)param.reference, this.copyArgument(reference, param));
    }

    @Override
    public TypeConformanceResult doVisitMultiTypeReference(JvmMultiTypeReference reference, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return (TypeConformanceResult)this.multiTypeDispatcher.visit((JvmTypeReference)param.reference, this.copyArgument(reference, param));
    }

    @Override
    public TypeConformanceResult doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return (TypeConformanceResult)this.parameterizedTypeDispatcher.visit((JvmTypeReference)param.reference, this.copyArgument(reference, param));
    }

    @Override
    public TypeConformanceResult doVisitSynonymTypeReference(JvmSynonymTypeReference reference, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return (TypeConformanceResult)this.synonymTypeDispatcher.visit((JvmTypeReference)param.reference, this.copyArgument(reference, param));
    }

    @Override
    public TypeConformanceResult doVisitUnknownTypeReference(JvmUnknownTypeReference reference, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return (TypeConformanceResult)this.unknownTypeDispatcher.visit((JvmTypeReference)param.reference, this.copyArgument(reference, param));
    }

    @Override
    public TypeConformanceResult doVisitWildcardTypeReference(JvmWildcardTypeReference reference, TypeConformanceComputationArgument.Internal<JvmTypeReference> param) {
        return (TypeConformanceResult)this.wildcardTypeDispatcher.visit((JvmTypeReference)param.reference, this.copyArgument(reference, param));
    }

    protected TypeConformanceStrategy<JvmAnyTypeReference> createAnyTypeDispatcher() {
        return new AnyTypeConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<JvmGenericArrayTypeReference> createGenericArrayTypeDispatcher() {
        return new GenericArrayConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<JvmMultiTypeReference> createMultiTypeDispatcher() {
        return new MultiTypeConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<JvmParameterizedTypeReference> createParameterizedTypeDispatcher() {
        return new ParameterizedTypeConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<JvmSynonymTypeReference> createSynonymTypeDispatcher() {
        return new SynonymConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<JvmUnknownTypeReference> createUnknownTypeDispatcher() {
        return new UnknownConformanceStrategy(this.conformanceComputer);
    }

    protected TypeConformanceStrategy<JvmWildcardTypeReference> createWildcardTypeDispatcher() {
        return new WildcardConformanceStrategy(this.conformanceComputer);
    }
}

