/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import java.util.ArrayList;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperimentManager;
import org.eclipse.stem.analysis.automaticexperiment.SimplexAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.SimplexFunction;

public class NelderMeadAlgorithm
implements SimplexAlgorithm {
    double ccoeff = 0.5;
    double del;
    double dn;
    double dnn;
    double ecoeff = 2.0;
    double eps = 0.001;
    int i;
    int ihi;
    int ilo;
    int j;
    int jcount;
    int l;
    int nn;
    double[] p;
    double[] p2star;
    double[] pbar;
    double[] pstar;
    double rcoeff = 1.0;
    double rq;
    double x;
    ErrorResult[] y;
    ErrorResult y2star;
    ErrorResult ylo;
    ErrorResult ystar;
    double z;
    int ifault = -1;
    int numres = -1;
    int icount = -1;
    ErrorResult ynewlo;
    double[] xmin;
    ArrayList<Double> minParamValues = new ArrayList();
    ArrayList<Double> maxParamValues = new ArrayList();

    @Override
    public void execute(SimplexFunction fn, double[] startPoint, double[] step, double terminatingVariance, long maxIter) {
        this.execute(fn, startPoint, terminatingVariance, step, 1, (int)maxIter);
    }

    private void execute(SimplexFunction fn, double[] start, double reqmin, double[] step, int konvge, int kcount) {
        int n = start.length;
        if (reqmin <= 0.0) {
            this.ifault = 1;
            return;
        }
        if (n < 1) {
            this.ifault = 1;
            return;
        }
        if (konvge < 1) {
            this.ifault = 1;
            return;
        }
        this.p = new double[n * (n + 1)];
        this.pstar = new double[n];
        this.p2star = new double[n];
        this.pbar = new double[n];
        this.y = new ErrorResult[n + 1];
        this.xmin = new double[n];
        this.icount = 0;
        this.numres = 0;
        this.jcount = konvge;
        this.dn = n;
        this.nn = n + 1;
        this.dnn = this.nn;
        this.del = 1.0;
        this.rq = reqmin * this.dn;
        if (!AutomaticExperimentManager.QUIT_NOW) {
            this.i = 0;
            while (this.i < n) {
                this.p[this.i + n * n] = start[this.i];
                ++this.i;
            }
            this.limit(start);
            this.y[n] = fn.getValue(start).copy();
            ++this.icount;
            this.j = 0;
            while (this.j < n) {
                this.x = start[this.j];
                start[this.j] = start[this.j] + step[this.j] * this.del;
                this.i = 0;
                while (this.i < n) {
                    this.p[this.i + this.j * n] = start[this.i];
                    ++this.i;
                }
                this.limit(start);
                this.y[this.j] = fn.getValue(start).copy();
                ++this.icount;
                start[this.j] = this.x;
                if (AutomaticExperimentManager.QUIT_NOW) break;
                ++this.j;
            }
            if (!AutomaticExperimentManager.QUIT_NOW) {
                this.ylo = this.y[0].copy();
                this.ilo = 0;
                this.i = 1;
                while (this.i < this.nn) {
                    if (this.y[this.i].getError() < this.ylo.getError()) {
                        this.ylo = this.y[this.i].copy();
                        this.ilo = this.i;
                    }
                    ++this.i;
                }
                while (!(AutomaticExperimentManager.QUIT_NOW || kcount != -1 && kcount <= this.icount)) {
                    this.ynewlo = this.y[0].copy();
                    this.ihi = 0;
                    this.i = 1;
                    while (this.i < this.nn) {
                        if (this.ynewlo.getError() < this.y[this.i].getError()) {
                            this.ynewlo = this.y[this.i].copy();
                            this.ihi = this.i;
                        }
                        ++this.i;
                    }
                    this.i = 0;
                    while (this.i < n) {
                        this.z = 0.0;
                        this.j = 0;
                        while (this.j < this.nn) {
                            this.z += this.p[this.i + this.j * n];
                            ++this.j;
                        }
                        this.z -= this.p[this.i + this.ihi * n];
                        this.pbar[this.i] = this.z / this.dn;
                        ++this.i;
                    }
                    this.i = 0;
                    while (this.i < n) {
                        this.pstar[this.i] = this.pbar[this.i] + this.rcoeff * (this.pbar[this.i] - this.p[this.i + this.ihi * n]);
                        ++this.i;
                    }
                    this.limit(this.pstar);
                    this.ystar = fn.getValue(this.pstar).copy();
                    ++this.icount;
                    if (this.ystar.getError() < this.ylo.getError()) {
                        this.i = 0;
                        while (this.i < n) {
                            this.p2star[this.i] = this.pbar[this.i] + this.ecoeff * (this.pstar[this.i] - this.pbar[this.i]);
                            ++this.i;
                        }
                        this.limit(this.p2star);
                        this.y2star = fn.getValue(this.p2star).copy();
                        ++this.icount;
                        if (this.ystar.getError() < this.y2star.getError()) {
                            this.i = 0;
                            while (this.i < n) {
                                this.p[this.i + this.ihi * n] = this.pstar[this.i];
                                ++this.i;
                            }
                            this.y[this.ihi] = this.ystar.copy();
                        } else {
                            this.i = 0;
                            while (this.i < n) {
                                this.p[this.i + this.ihi * n] = this.p2star[this.i];
                                ++this.i;
                            }
                            this.y[this.ihi] = this.y2star.copy();
                        }
                    } else {
                        this.l = 0;
                        this.i = 0;
                        while (this.i < this.nn) {
                            if (this.ystar.getError() < this.y[this.i].getError()) {
                                ++this.l;
                            }
                            ++this.i;
                        }
                        if (1 < this.l) {
                            this.i = 0;
                            while (this.i < n) {
                                this.p[this.i + this.ihi * n] = this.pstar[this.i];
                                ++this.i;
                            }
                            this.y[this.ihi] = this.ystar.copy();
                        } else if (this.l == 0) {
                            this.i = 0;
                            while (this.i < n) {
                                this.p2star[this.i] = this.pbar[this.i] + this.ccoeff * (this.p[this.i + this.ihi * n] - this.pbar[this.i]);
                                ++this.i;
                            }
                            this.limit(this.p2star);
                            this.y2star = fn.getValue(this.p2star).copy();
                            ++this.icount;
                            if (this.y[this.ihi].getError() < this.y2star.getError()) {
                                this.j = 0;
                                while (this.j < this.nn) {
                                    this.i = 0;
                                    while (this.i < n) {
                                        this.p[this.i + this.j * n] = (this.p[this.i + this.j * n] + this.p[this.i + this.ilo * n]) * 0.5;
                                        this.xmin[this.i] = this.p[this.i + this.j * n];
                                        ++this.i;
                                    }
                                    this.limit(this.xmin);
                                    this.y[this.j] = fn.getValue(this.xmin).copy();
                                    ++this.icount;
                                    ++this.j;
                                }
                                this.ylo = this.y[0];
                                this.ilo = 0;
                                this.i = 1;
                                while (this.i < this.nn) {
                                    if (this.y[this.i].getError() < this.ylo.getError()) {
                                        this.ylo = this.y[this.i].copy();
                                        this.ilo = this.i;
                                    }
                                    ++this.i;
                                }
                                continue;
                            }
                            this.i = 0;
                            while (this.i < n) {
                                this.p[this.i + this.ihi * n] = this.p2star[this.i];
                                ++this.i;
                            }
                            this.y[this.ihi] = this.y2star.copy();
                        } else if (this.l == 1) {
                            this.i = 0;
                            while (this.i < n) {
                                this.p2star[this.i] = this.pbar[this.i] + this.ccoeff * (this.pstar[this.i] - this.pbar[this.i]);
                                ++this.i;
                            }
                            this.limit(this.p2star);
                            this.y2star = fn.getValue(this.p2star).copy();
                            ++this.icount;
                            if (this.y2star.getError() <= this.ystar.getError()) {
                                this.i = 0;
                                while (this.i < n) {
                                    this.p[this.i + this.ihi * n] = this.p2star[this.i];
                                    ++this.i;
                                }
                                this.y[this.ihi] = this.y2star.copy();
                            } else {
                                this.i = 0;
                                while (this.i < n) {
                                    this.p[this.i + this.ihi * n] = this.pstar[this.i];
                                    ++this.i;
                                }
                                this.y[this.ihi] = this.ystar.copy();
                            }
                        }
                    }
                    if (this.y[this.ihi].getError() < this.ylo.getError()) {
                        this.ylo = this.y[this.ihi].copy();
                        this.ilo = this.ihi;
                    }
                    --this.jcount;
                    if (this.jcount > 0 || kcount != -1 && this.icount > kcount) continue;
                    this.jcount = konvge;
                    this.z = 0.0;
                    this.i = 0;
                    while (this.i < this.nn) {
                        this.z += this.y[this.i].getError();
                        ++this.i;
                    }
                    this.x = this.z / this.dnn;
                    this.z = 0.0;
                    this.i = 0;
                    while (this.i < this.nn) {
                        this.z += Math.pow(this.y[this.i].getError() - this.x, 2.0);
                        ++this.i;
                    }
                    if (!(this.z <= this.rq)) continue;
                }
                this.i = 0;
                while (this.i < n) {
                    this.xmin[this.i] = this.p[this.i + this.ilo * n];
                    ++this.i;
                }
                this.ynewlo = this.y[this.ilo].copy();
            }
        }
    }

    private void limit(double[] vals) {
        int i = 0;
        while (i < vals.length) {
            if (vals[i] < this.minParamValues.get(i)) {
                vals[i] = this.minParamValues.get(i);
            } else if (vals[i] > this.maxParamValues.get(i)) {
                vals[i] = this.maxParamValues.get(i);
            }
            ++i;
        }
    }

    @Override
    public double getMinimumFunctionValue() {
        if (this.ynewlo != null) {
            return this.ynewlo.getError();
        }
        return -1.0;
    }

    @Override
    public ErrorResult getMinimumErrorResult() {
        return this.ynewlo;
    }

    @Override
    public double[] getMinimumParametersValues() {
        return this.xmin;
    }

    @Override
    public void setParameterLimits(int parameterIndex, double lowerBound, double upperBound) {
        int i = 0;
        while (i < parameterIndex + 1 - this.minParamValues.size()) {
            this.minParamValues.add(0.0);
            ++i;
        }
        i = 0;
        while (i < parameterIndex + 1 - this.maxParamValues.size()) {
            this.maxParamValues.add(0.0);
            ++i;
        }
        this.minParamValues.ensureCapacity(parameterIndex + 1);
        this.maxParamValues.ensureCapacity(parameterIndex + 1);
        this.minParamValues.set(parameterIndex, lowerBound);
        this.maxParamValues.set(parameterIndex, upperBound);
    }
}

