/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteAction
extends SelectionDispatchAction {
    private static final int HIDE_BUTTON = 0;
    private static final int REMOVE_BUTTON = 1;

    public DeleteAction(IWorkbenchSite site) {
        super(site);
        this.setText(ReorgMessages.DeleteAction_3);
        this.setDescription(ReorgMessages.DeleteAction_4);
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.delete_action");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
            return;
        }
        this.setEnabled(RefactoringAvailabilityTester.isDeleteAvailable(selection.toArray()));
    }

    private IAction createWorkbenchAction(IStructuredSelection selection) {
        DeleteResourceAction action = new DeleteResourceAction((IShellProvider)this.getSite());
        action.selectionChanged(selection);
        return action;
    }

    private void deleteWorkingSets(IStructuredSelection selection) {
        MessageDialog dialog;
        if (selection.size() == 1) {
            IWorkingSet workingSet = (IWorkingSet)selection.getFirstElement();
            final String workingSetID = workingSet.getId();
            String dialogMessage = this.isDefaultWorkingSet(workingSetID) ? MessageFormat.format((String)ReorgMessages.DeleteWorkingSet_hideworkingset_single, (Object[])new Object[]{workingSet.getLabel()}) : MessageFormat.format((String)ReorgMessages.DeleteWorkingSet_removeorhideworkingset_single, (Object[])new Object[]{workingSet.getLabel()});
            dialog = new MessageDialog(this.getShell(), ReorgMessages.DeleteWorkingSet_single, null, dialogMessage, 3, new String[]{ReorgMessages.DeleteWorkingSet_Hide, ReorgMessages.DeleteWorkingSet_Remove, IDialogConstants.CANCEL_LABEL}, 0){

                protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                    Button button = super.createButton(parent, id, label, defaultButton);
                    if (id == 1 && "org.eclipse.jdt.internal.ui.OthersWorkingSet".equals(workingSetID)) {
                        button.setEnabled(false);
                    }
                    return button;
                }
            };
        } else {
            dialog = new MessageDialog(this.getShell(), ReorgMessages.DeleteWorkingSet_multiple, null, MessageFormat.format((String)ReorgMessages.DeleteWorkingSet_removeorhideworkingset_multiple, (Object[])new Object[]{new Integer(selection.size())}), 3, new String[]{ReorgMessages.DeleteWorkingSet_Hide, ReorgMessages.DeleteWorkingSet_Remove, IDialogConstants.CANCEL_LABEL}, 0);
        }
        int dialogResponse = dialog.open();
        if (dialogResponse == 1) {
            Iterator iter = selection.iterator();
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            while (iter.hasNext()) {
                IWorkingSet workingSet = (IWorkingSet)iter.next();
                if (this.isDefaultWorkingSet(workingSet.getId())) {
                    this.hideWorkingSets(Collections.singletonList(workingSet));
                    continue;
                }
                manager.removeWorkingSet(workingSet);
            }
        } else if (dialogResponse == 0) {
            this.hideWorkingSets(SelectionUtil.toList((ISelection)selection));
        }
    }

    private void hideWorkingSets(List<IWorkingSet> selection) {
        IWorkbenchPart activePart;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) instanceof PackageExplorerPart) {
            PackageExplorerPart packagePart = (PackageExplorerPart)activePart;
            WorkingSetModel model = packagePart.getWorkingSetModel();
            ArrayList<IWorkingSet> activeWorkingSets = new ArrayList<IWorkingSet>(Arrays.asList(model.getActiveWorkingSets()));
            activeWorkingSets.removeAll(selection);
            model.setActiveWorkingSets(activeWorkingSets.toArray(new IWorkingSet[activeWorkingSets.size()]));
        }
    }

    private boolean isDefaultWorkingSet(String workingSetID) {
        return "org.eclipse.jdt.internal.ui.OthersWorkingSet".equals(workingSetID);
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (ReorgUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        if (ReorgUtils.containsOnlyWorkingSets(selection.toList())) {
            this.deleteWorkingSets(selection);
            return;
        }
        try {
            RefactoringExecutionStarter.startDeleteRefactoring(selection.toArray(), this.getShell());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

