/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.pde.internal.junit.runtime.MultiBundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class RemotePluginTestRunner
extends RemoteTestRunner {
    private String fTestPluginName;
    private ClassLoader fLoaderClassLoader;

    public static void main(String[] args) {
        RemotePluginTestRunner testRunner = new RemotePluginTestRunner();
        testRunner.init(args);
        ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            if (RemotePluginTestRunner.runAsJUnit5(args)) {
                Thread.currentThread().setContextClassLoader(RemotePluginTestRunner.getPluginClassLoader2(testRunner.getfTestPluginName()));
            } else {
                Thread.currentThread().setContextClassLoader(RemotePluginTestRunner.getPluginClassLoader(testRunner.getfTestPluginName()));
            }
        }
        testRunner.run();
        if (RemotePluginTestRunner.isJUnit5(args)) {
            Thread.currentThread().setContextClassLoader(currentTCCL);
        }
    }

    private static ClassLoader getPluginClassLoader2(String getfTestPluginName) {
        Bundle[] bundles;
        Bundle bundle = Platform.getBundle((String)getfTestPluginName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + getfTestPluginName + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        String pluginId = getfTestPluginName;
        ArrayList<String> engines = new ArrayList<String>();
        Bundle bund = FrameworkUtil.getBundle(RemotePluginTestRunner.class);
        Bundle[] bundleArray = bundles = bund.getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle iBundle = bundleArray[n2];
            try {
                BundleWiring bundleWiring = (BundleWiring)Platform.getBundle((String)iBundle.getSymbolicName()).adapt(BundleWiring.class);
                Collection listResources = bundleWiring.listResources("META-INF/services", "org.junit.platform.engine.TestEngine", 2);
                if (!listResources.isEmpty()) {
                    engines.add(iBundle.getSymbolicName());
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        engines.add(pluginId);
        ArrayList<Bundle> platformEngineBundles = new ArrayList<Bundle>();
        for (String string : engines) {
            Bundle bundle2 = Platform.getBundle((String)string);
            platformEngineBundles.add(bundle2);
        }
        return new MultiBundleClassLoader(platformEngineBundles);
    }

    private static ClassLoader getPluginClassLoader(String getfTestPluginName) {
        Bundle bundle = Platform.getBundle((String)getfTestPluginName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + getfTestPluginName + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        return new TestBundleClassLoader(bundle);
    }

    protected ClassLoader getTestClassLoader() {
        String pluginId = this.getfTestPluginName();
        return this.getClassLoader(pluginId);
    }

    public ClassLoader getClassLoader(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle \"" + bundleId + "\" not found. Possible causes include missing dependencies, too restrictive version ranges, or a non-matching required execution environment.");
        }
        return new BundleClassLoader(bundle);
    }

    public void init(String[] args) {
        this.readPluginArgs(args);
        boolean isJUnit5 = RemotePluginTestRunner.isJUnit5(args);
        if (isJUnit5) {
            ClassLoader currentTCCL = Thread.currentThread().getContextClassLoader();
            try {
                Bundle[] bundles;
                ArrayList<String> platformEngines = new ArrayList<String>();
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                Bundle[] bundleArray = bundles = bundle.getBundleContext().getBundles();
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle iBundle = bundleArray[n2];
                    try {
                        BundleWiring bundleWiring = (BundleWiring)Platform.getBundle((String)iBundle.getSymbolicName()).adapt(BundleWiring.class);
                        Collection listResources = bundleWiring.listResources("META-INF/services", "org.junit.platform.engine.TestEngine", 2);
                        if (!listResources.isEmpty()) {
                            platformEngines.add(iBundle.getSymbolicName());
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                Thread.currentThread().setContextClassLoader(this.getJUnit5Classloader(platformEngines));
                this.defaultInit(args);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentTCCL);
            }
            return;
        }
        this.defaultInit(args);
    }

    private ClassLoader getJUnit5Classloader(List<String> platformEngine) {
        ArrayList<Bundle> platformEngineBundles = new ArrayList<Bundle>();
        for (String string : platformEngine) {
            Bundle bundle = Platform.getBundle((String)string);
            platformEngineBundles.add(bundle);
        }
        return new MultiBundleClassLoader(platformEngineBundles);
    }

    private static boolean runAsJUnit5(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.equalsIgnoreCase("-runasjunit5")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isJUnit5(String[] args) {
        if (RemotePluginTestRunner.runAsJUnit5(args)) {
            return true;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("org.eclipse.jdt.internal.junit5.runner.JUnit5TestLoader")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void readPluginArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (this.isFlag(args, i, "-testpluginname")) {
                this.setfTestPluginName(args[i + 1]);
            }
            if (this.isFlag(args, i, "-loaderpluginname")) {
                this.fLoaderClassLoader = this.getClassLoader(args[i + 1]);
            }
            ++i;
        }
        if (this.getfTestPluginName() == null) {
            throw new IllegalArgumentException("Parameter -testpluginnname not specified.");
        }
        if (this.fLoaderClassLoader == null) {
            this.fLoaderClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    protected Class<?> loadTestLoaderClass(String className) throws ClassNotFoundException {
        return this.fLoaderClassLoader.loadClass(className);
    }

    private boolean isFlag(String[] args, int i, String wantedFlag) {
        String lowerCase = args[i].toLowerCase(Locale.ENGLISH);
        return lowerCase.equals(wantedFlag) && i < args.length - 1;
    }

    public String getfTestPluginName() {
        return this.fTestPluginName;
    }

    public void setfTestPluginName(String fTestPluginName) {
        this.fTestPluginName = fTestPluginName;
    }

    class BundleClassLoader
    extends ClassLoader {
        private Bundle bundle;

        public BundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }
    }

    static class TestBundleClassLoader
    extends ClassLoader {
        protected Bundle bundle;

        public TestBundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }

        @Override
        public Enumeration<URL> getResources(String res) throws IOException {
            Enumeration bundleResources = this.bundle.getResources(res);
            if (bundleResources == null) {
                return Collections.emptyEnumeration();
            }
            ArrayList<URL> compatibleResources = new ArrayList<URL>();
            while (bundleResources.hasMoreElements()) {
                URL nativeUrl = FileLocator.resolve((URL)((URL)bundleResources.nextElement()));
                compatibleResources.add(nativeUrl);
            }
            return Collections.enumeration(compatibleResources);
        }
    }
}

