/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.comp.CompCSPage;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;

public class CompCSFormOutlinePage
extends FormOutlinePage {
    public CompCSFormOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    protected String getObjectText(ICompCSObject obj) {
        int limit = 50;
        if (obj.getType() == 0) {
            limit = 30;
        } else if (obj.getType() == 2) {
            limit = 26;
        } else if (obj.getType() == 1) {
            limit = 22;
        }
        return PDETextHelper.truncateAndTrailOffText((String)PDETextHelper.translateReadText((String)obj.getName()), (int)limit);
    }

    protected Object[] getChildren(Object parent) {
        List list;
        if (parent instanceof CompCSPage) {
            ICompCSModel cheatsheet = (ICompCSModel)this.fEditor.getAggregateModel();
            if (cheatsheet != null && cheatsheet.isLoaded()) {
                Object[] list2 = new Object[]{cheatsheet.getCompCS()};
                return list2;
            }
        } else if (parent instanceof ICompCSObject && (list = ((ICompCSObject)parent).getChildren()).size() > 0) {
            return list.toArray();
        }
        return super.getChildren(parent);
    }

    public ILabelProvider createLabelProvider() {
        return new CompCSLabelProvider((ILabelProvider)PDEUserAssistanceUIPlugin.getDefault().getLabelProvider());
    }

    protected String getParentPageId(Object item) {
        return "compCSPage";
    }

    private class CompCSLabelProvider
    extends FormOutlinePage.BasicLabelProvider {
        public CompCSLabelProvider(ILabelProvider ilp) {
            super((FormOutlinePage)CompCSFormOutlinePage.this, ilp);
        }

        public String getText(Object obj) {
            if (obj instanceof ICompCSObject) {
                return CompCSFormOutlinePage.this.getObjectText((ICompCSObject)obj);
            }
            return super.getText(obj);
        }
    }
}

