/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ParameterPickerDialog
extends Dialog {
    private String title;
    IProject project;
    Class<?> restrictClass;
    boolean cancelPressed = false;
    protected Shell shell;
    Composite mainComposite;
    private ArrayList<Identifiable> projectObjects;
    private ArrayList<EAttribute> objectFeatures;
    private Identifiable selectedObject;
    private EAttribute selectedAttribute;

    public ParameterPickerDialog(Shell parent, int style, String title, IProject p, Class<?> restrictClass) {
        super(parent, style);
        this.title = title;
        this.project = p;
        this.restrictClass = restrictClass;
    }

    public Object[] open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 68704);
        GridLayout gl1 = new GridLayout();
        gl1.numColumns = 1;
        this.shell.setLayout((Layout)gl1);
        this.shell.setText(this.title);
        this.mainComposite = new Composite((Composite)this.shell, 1040);
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ParameterPickerDialog.this.shell.pack();
            }
        });
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.makeColumnsEqualWidth = true;
        this.mainComposite.setLayout((Layout)mainLayout);
        Label lab1 = new Label(this.mainComposite, 0);
        lab1.setText(Messages.getString("PP.IDENTS"));
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        lab1.setLayoutData((Object)gd);
        Label lab2 = new Label(this.mainComposite, 0);
        lab2.setText(Messages.getString("PP.PROP"));
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 1;
        lab2.setLayoutData((Object)gd2);
        final Table objectTable = new Table(this.mainComposite, 0);
        GridData gd3 = new GridData();
        gd3.horizontalSpan = 1;
        gd3.grabExcessHorizontalSpace = true;
        gd3.horizontalAlignment = 4;
        gd3.grabExcessVerticalSpace = true;
        gd3.verticalAlignment = 4;
        objectTable.setLayoutData((Object)gd3);
        this.projectObjects = this.getProjectObjects(null);
        for (Identifiable id : this.projectObjects) {
            TableItem newRow = new TableItem(objectTable, 0);
            newRow.setText(id.getURI().lastSegment());
        }
        final Table propertyTable = new Table(this.mainComposite, 0);
        GridData gd4 = new GridData();
        gd4.horizontalSpan = 1;
        gd4.grabExcessHorizontalSpace = true;
        gd4.horizontalAlignment = 4;
        gd4.grabExcessVerticalSpace = true;
        gd4.verticalAlignment = 4;
        propertyTable.setLayoutData((Object)gd4);
        Button cancelButton = new Button(this.mainComposite, 0);
        GridData cg = new GridData();
        cancelButton.setText(Messages.getString("NLocWizCancel"));
        cancelButton.setLayoutData((Object)cg);
        final Button okayButton = new Button(this.mainComposite, 0);
        GridData okg = new GridData();
        okayButton.setText(Messages.getString("NLocWizOk"));
        okayButton.setLayoutData((Object)okg);
        okayButton.setEnabled(false);
        objectTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = objectTable.getSelectionIndex();
                Identifiable selectedIdent = ParameterPickerDialog.this.projectObjects.get(index);
                ParameterPickerDialog.this.populateObjectProperties(selectedIdent);
                propertyTable.removeAll();
                for (EStructuralFeature eStructuralFeature : ParameterPickerDialog.this.objectFeatures) {
                    TableItem newRow = new TableItem(propertyTable, 0);
                    newRow.setText(eStructuralFeature.getName());
                }
                okayButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        propertyTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = propertyTable.getSelectionIndex();
                ParameterPickerDialog.this.selectedAttribute = ParameterPickerDialog.this.objectFeatures.get(index);
                int index2 = objectTable.getSelectionIndex();
                ParameterPickerDialog.this.selectedObject = ParameterPickerDialog.this.projectObjects.get(index2);
                okayButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.shell.pack();
        this.shell.open();
        okayButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ParameterPickerDialog.this.cancelPressed = false;
                ParameterPickerDialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ParameterPickerDialog.this.cancelPressed = true;
                ParameterPickerDialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.cancelPressed) {
            return null;
        }
        Object[] ret = new Object[]{this.selectedObject, this.selectedAttribute};
        return ret;
    }

    void populateObjectProperties(Identifiable selectedIdent) {
        this.objectFeatures = new ArrayList();
        for (EAttribute ea : selectedIdent.eClass().getEAllAttributes()) {
            EDataType esf = ea.getEAttributeType();
            if (!esf.getName().equals("EDouble")) continue;
            this.objectFeatures.add(ea);
        }
    }

    private ArrayList<Identifiable> getProjectObjects(IFolder folder) {
        ArrayList<Identifiable> result = new ArrayList<Identifiable>();
        try {
            IResource[] resources = null;
            resources = folder == null ? this.project.members() : folder.members();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Identifiable ident;
                IResource re = iResourceArray[n2];
                if (re instanceof IFolder && !re.getName().equals("Recorded Simulations")) {
                    result.addAll(this.getProjectObjects((IFolder)re));
                } else if (re instanceof IFile && !re.getResourceAttributes().isHidden() && !re.getName().startsWith(".") && (ident = Utility.getIdentifiableIgnoreException((IFile)re)) != null && this.isClass(ident.getClass(), this.restrictClass)) {
                    result.add(ident);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean isClass(Class<?> c, Class<?> target) {
        if (target.equals(c)) {
            return true;
        }
        Class<?> superC = c.getSuperclass();
        if (superC == null) {
            return false;
        }
        return this.isClass(superC, target);
    }
}

