/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PointValues;

public abstract class PointsWriter
implements Closeable {
    protected PointsWriter() {
    }

    public abstract void writeField(FieldInfo var1, PointsReader var2) throws IOException;

    protected void mergeOneField(final MergeState mergeState, final FieldInfo fieldInfo) throws IOException {
        long maxPointCount = 0L;
        int docCount = 0;
        for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
            PointValues values;
            FieldInfo readerFieldInfo;
            PointsReader pointsReader = mergeState.pointsReaders[i];
            if (pointsReader == null || (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldInfo.name)) == null || readerFieldInfo.getPointDataDimensionCount() <= 0 || (values = pointsReader.getValues(fieldInfo.name)) == null) continue;
            maxPointCount += values.size();
            docCount += values.getDocCount();
        }
        final long finalMaxPointCount = maxPointCount;
        final int finalDocCount = docCount;
        this.writeField(fieldInfo, new PointsReader(){

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public PointValues getValues(final String fieldName) {
                if (!fieldName.equals(fieldInfo.name)) {
                    throw new IllegalArgumentException("field name must match the field being merged");
                }
                return new PointValues(){

                    @Override
                    public void intersect(final PointValues.IntersectVisitor mergedVisitor) throws IOException {
                        for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
                            PointValues values;
                            FieldInfo readerFieldInfo;
                            PointsReader pointsReader = mergeState.pointsReaders[i];
                            if (pointsReader == null || (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldName)) == null || readerFieldInfo.getPointDataDimensionCount() == 0 || (values = pointsReader.getValues(fieldName)) == null) continue;
                            final MergeState.DocMap docMap = mergeState.docMaps[i];
                            values.intersect(new PointValues.IntersectVisitor(){

                                @Override
                                public void visit(int docID) {
                                    throw new IllegalStateException();
                                }

                                @Override
                                public void visit(int docID, byte[] packedValue) throws IOException {
                                    int newDocID = docMap.get(docID);
                                    if (newDocID != -1) {
                                        mergedVisitor.visit(newDocID, packedValue);
                                    }
                                }

                                @Override
                                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                                    return PointValues.Relation.CELL_CROSSES_QUERY;
                                }
                            });
                        }
                    }

                    @Override
                    public long estimatePointCount(PointValues.IntersectVisitor visitor) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public byte[] getMinPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public byte[] getMaxPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getNumDataDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getNumIndexDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int getBytesPerDimension() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long size() {
                        return finalMaxPointCount;
                    }

                    @Override
                    public int getDocCount() {
                        return finalDocCount;
                    }
                };
            }

            @Override
            public void checkIntegrity() throws IOException {
                throw new UnsupportedOperationException();
            }
        });
    }

    public void merge(MergeState mergeState) throws IOException {
        for (PointsReader reader : mergeState.pointsReaders) {
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (fieldInfo.getPointDataDimensionCount() == 0) continue;
            this.mergeOneField(mergeState, fieldInfo);
        }
        this.finish();
    }

    public abstract void finish() throws IOException;
}

