/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.fd.presentation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyEditor;
import org.eclipse.stem.solvers.fd.FdFactory;
import org.eclipse.stem.solvers.fd.FdPackage;
import org.eclipse.stem.solvers.fd.FiniteDifference;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FdSolverPropertyEditor
extends SolverPropertyEditor {
    protected final Map<EStructuralFeature, Text> map = new HashMap<EStructuralFeature, Text>();
    protected String errorMessage;

    public FdSolverPropertyEditor(Composite parent, int style, Solver solver, ModifyListener projectValidator) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        PropertyStringProviderAdapter pspa = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)solver, PropertyStringProvider.class);
        ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)solver, IItemPropertySource.class);
        List properties = propertySource.getPropertyDescriptors((Object)solver);
        for (IItemPropertyDescriptor descriptor : properties) {
            EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
            if (!FdSolverPropertyEditor.isUserSpecifiedSolverProperty(feature)) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(pspa.getPropertyName(descriptor));
            GridData labelGD = new GridData(1);
            labelGD.grabExcessHorizontalSpace = true;
            labelGD.horizontalAlignment = 4;
            labelGD.horizontalIndent = 0;
            label.setLayoutData((Object)labelGD);
            String defaultValueString = this.getPropertyDefaultValueString(descriptor);
            Text text = new Text((Composite)this, 133120);
            text.setText(defaultValueString);
            text.setToolTipText(pspa.getPropertyToolTip(descriptor));
            this.map.put(feature, text);
            GridData textGD = new GridData(3);
            textGD.grabExcessHorizontalSpace = true;
            textGD.horizontalAlignment = 4;
            text.setLayoutData((Object)textGD);
            text.addModifyListener(projectValidator);
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText(pspa.getPropertyUnits(descriptor));
            GridData unitLabelGD = new GridData(3);
            unitLabelGD.verticalAlignment = 2;
            unitLabel.setLayoutData((Object)unitLabelGD);
        }
    }

    public static boolean isUserSpecifiedSolverProperty(EStructuralFeature feature) {
        boolean retValue = false;
        EClass containingClass = feature.getEContainingClass();
        if (containingClass.equals(FdPackage.eINSTANCE.getFiniteDifference())) {
            retValue = true;
        }
        return retValue;
    }

    public FdSolverPropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    public void populate(Solver solver) {
        super.populate(solver);
        for (Map.Entry<EStructuralFeature, Text> entry : this.map.entrySet()) {
            entry.getKey().getFeatureID();
        }
    }

    public boolean validate() {
        boolean retValue = true;
        return retValue;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public Solver createAndPopulateSolver() {
        FiniteDifference retValue = FdFactory.eINSTANCE.createFiniteDifference();
        retValue.setURI(STEMURI.createURI((String)("FiniteDifferenceSolver/" + STEMURI.generateUniquePart())));
        this.populate((Solver)retValue);
        return retValue;
    }
}

