/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.ui;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jsch.internal.ui.KeyboardInteractiveDialog;
import org.eclipse.jsch.internal.ui.Messages;
import org.eclipse.jsch.internal.ui.UserValidationDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserInfoPrompter
implements UserInfo,
UIKeyboardInteractive {
    private String passphrase;
    private String password;
    private final Session session;
    private int attemptCount;

    public UserInfoPrompter(Session session) {
        this.session = session;
        session.setUserInfo((UserInfo)this);
    }

    public Session getSession() {
        return this.session;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean promptPassphrase(String message) {
        String _passphrase = this.promptSecret(message);
        if (_passphrase != null) {
            this.setPassphrase(_passphrase);
        }
        return _passphrase != null;
    }

    public boolean promptPassword(String message) {
        String _password = this.promptSecret(message);
        if (_password != null) {
            this.setPassword(_password);
        }
        return _password != null;
    }

    private String promptSecret(final String message) {
        final String[] result = new String[1];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this.promptForPassword(message);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = UserInfoPrompter.this.promptForPassword(message);
                }
            });
        }
        if (result[0] == null) {
            throw new OperationCanceledException();
        }
        return result[0];
    }

    String promptForPassword(String message) {
        String username = this.getSession().getUserName();
        UserValidationDialog dialog = new UserValidationDialog(null, null, username == null ? "" : username, message);
        dialog.setUsernameMutable(false);
        dialog.open();
        return dialog.getPassword();
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        String[] result;
        block6: {
            if (prompt.length == 0) {
                return new String[0];
            }
            try {
                if (this.attemptCount == 0 && this.password != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    ++this.attemptCount;
                    return new String[]{this.password};
                }
                result = this.promptForKeyboradInteractiveInUI(destination, name, instruction, prompt, echo);
                if (result != null) break block6;
                return null;
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
        }
        if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
            this.password = result[0];
        }
        ++this.attemptCount;
        return result;
    }

    private String[] promptForKeyboradInteractiveInUI(final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) {
        final String[][] result = new String[1][];
        Display display = Display.getCurrent();
        if (display != null) {
            result[0] = this.internalPromptForUserInteractive(destination, name, instruction, prompt, echo);
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    result[0] = UserInfoPrompter.this.internalPromptForUserInteractive(destination, name, instruction, prompt, echo);
                }
            });
        }
        return result[0];
    }

    String[] internalPromptForUserInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        String domain = null;
        String userName = this.getSession().getUserName();
        KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, domain, destination, name, userName, instruction, prompt, echo);
        dialog.open();
        String[] _result = dialog.getResult();
        return _result;
    }

    public boolean promptYesNo(String question) {
        int prompt = this.prompt(3, Messages.UserInfoPrompter_0, question, new int[]{2, 3}, 0);
        return prompt == 0;
    }

    public void showMessage(String message) {
        this.prompt(2, Messages.UserInfoPrompter_1, message, new int[1], 0);
    }

    private int prompt(final int promptType, final String title, final String message, int[] promptResponses, final int defaultResponse) {
        final Display display = this.getStandardDisplay();
        final int[] retval = new int[1];
        final String[] buttons = new String[promptResponses.length];
        int i = 0;
        while (i < promptResponses.length) {
            int prompt = promptResponses[i];
            switch (prompt) {
                case 0: {
                    buttons[i] = IDialogConstants.OK_LABEL;
                    break;
                }
                case 1: {
                    buttons[i] = IDialogConstants.CANCEL_LABEL;
                    break;
                }
                case 3: {
                    buttons[i] = IDialogConstants.NO_LABEL;
                    break;
                }
                case 2: {
                    buttons[i] = IDialogConstants.YES_LABEL;
                }
            }
            ++i;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(new Shell(display), title, null, message, promptType, buttons, defaultResponse);
                retval[0] = dialog.open();
            }
        });
        return retval[0];
    }

    private Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

