/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.views.markers.DescriptionFieldFilter;
import org.eclipse.ui.views.markers.FilterConfigurationArea;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerSupportConstants;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class DescriptionConfigurationArea
extends FilterConfigurationArea {
    private Combo descriptionCombo;
    private Text descriptionText;

    @Override
    public void apply(MarkerFieldFilter filter) {
        DescriptionFieldFilter desc = (DescriptionFieldFilter)filter;
        if (this.descriptionCombo.getSelectionIndex() == 0) {
            desc.setContainsModifier("CONTAINS");
        } else {
            desc.setContainsModifier(MarkerSupportConstants.DOES_NOT_CONTAIN_KEY);
        }
        desc.setContainsText(this.descriptionText.getText());
    }

    @Override
    public void createContents(Composite parent) {
        this.createDescriptionGroup(parent);
    }

    @Override
    public void initialize(MarkerFieldFilter filter) {
        DescriptionFieldFilter desc = (DescriptionFieldFilter)filter;
        if (desc.getContainsModifier().equals("CONTAINS")) {
            this.descriptionCombo.select(0);
        } else {
            this.descriptionCombo.select(1);
        }
        this.descriptionText.setText(desc.getContainsText());
    }

    private void createDescriptionGroup(Composite parent) {
        Composite descriptionComposite = new Composite(parent, 0);
        descriptionComposite.setLayout((Layout)new GridLayout(3, false));
        descriptionComposite.setLayoutData((Object)new GridData(768));
        Label descriptionLabel = new Label(descriptionComposite, 0);
        descriptionLabel.setText(MarkerMessages.filtersDialog_descriptionLabel);
        this.descriptionCombo = new Combo(descriptionComposite, 8);
        this.descriptionCombo.add(MarkerMessages.filtersDialog_contains);
        this.descriptionCombo.add(MarkerMessages.filtersDialog_doesNotContain);
        this.descriptionCombo.addTraverseListener(e -> {
            if (e.detail == 2 || e.detail == 4) {
                e.doit = false;
            }
        });
        GC gc = new GC((Drawable)descriptionComposite);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.descriptionText = new Text(descriptionComposite, 2052);
        GridData data = new GridData(768);
        data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)25);
        this.descriptionText.setLayoutData((Object)data);
    }

    @Override
    public String getTitle() {
        return MarkerMessages.filtersDialog_description;
    }
}

