/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.headless;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.ui.headless.Activator;
import org.eclipse.stem.ui.headless.HeadlessSimulationRunner;
import org.eclipse.stem.ui.launcher.Launcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class HeadlessLauncher
extends Launcher {
    private static final String DISTRIBUTED_CONTROLLER_PLUGIN_NAME = "org.eclipse.stem.graphsynchronizer";
    private Boolean workspacePluginsLoadSuccess = false;
    BundleListener workspaceLoadBundleListener = new BundleListener(){

        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 2 && event.getBundle().getLocation().contains("org.eclipse.stem.model.common")) {
                HeadlessLauncher.this.workspacePluginsLoadSuccess = Boolean.TRUE;
            }
        }
    };

    protected void checkDistributed() {
        if (this.args.containsKey("distributed")) {
            try {
                System.out.println("Enabling STEM distributed mode.");
                Bundle distBundle = Platform.getBundle((String)DISTRIBUTED_CONTROLLER_PLUGIN_NAME);
                if (distBundle != null) {
                    distBundle.start(1);
                } else {
                    System.err.println("Distributed STEM plugin not found.  Distributed mode not enabled.");
                }
            }
            catch (Exception e) {
                System.err.println("Error launching distributed STEM plugin.  Will continue in standalone.");
                e.printStackTrace(System.err);
            }
        }
    }

    protected void setStreams() {
        if (this.args.containsKey("quiet")) {
            System.setOut(new PrintStream(new NullOutputStream()));
        }
    }

    public Object launch() {
        DisplaySafeExecutor.forceHeadless();
        org.eclipse.stem.model.common.Activator plugin = null;
        if (this.args.containsKey("loadWorkspacePlugins")) {
            Activator.getContext().addBundleListener(this.workspaceLoadBundleListener);
            System.out.println("Loading workspace plugins");
            plugin = org.eclipse.stem.model.common.Activator.getPlugin();
            if (plugin != null) {
                try {
                    int i = 0;
                    while (i < 60) {
                        if (this.workspacePluginsLoadSuccess.booleanValue()) {
                            System.out.println("**** success loading plugin after attempts = " + i);
                            break;
                        }
                        Thread.sleep(500L);
                        ++i;
                    }
                }
                catch (InterruptedException interruptedException) {}
                if (!this.workspacePluginsLoadSuccess.booleanValue()) {
                    System.out.println("Loading workspace plugins: Warning plugin not loaded. Possible Race Condition");
                } else {
                    System.out.println("Loading workspace plugins SUCCESS");
                }
            }
            Activator.getContext().removeBundleListener(this.workspaceLoadBundleListener);
            this.workspaceLoadBundleListener = null;
            this.context.applicationRunning();
        }
        this.setStreams();
        this.checkDistributed();
        boolean log = this.args.containsKey("log");
        String logDir = null;
        if (log && ((List)this.args.get("log")).size() > 0) {
            logDir = (String)((List)this.args.get("log")).get(0);
        }
        HeadlessSimulationRunner runner = new HeadlessSimulationRunner(log, logDir);
        runner.run(this.args);
        return IApplication.EXIT_OK;
    }

    private class NullOutputStream
    extends OutputStream {
        NullOutputStream() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(int b) {
        }
    }
}

