/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl.scoping;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stem.model.ctdl.CTDLUtils;
import org.eclipse.stem.model.ctdl.ContextSensitiveResourceWrapper;
import org.eclipse.stem.model.ctdl.ctdl.AbsoluteCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.Block;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentTransitionDefinitions;
import org.eclipse.stem.model.ctdl.ctdl.CtdlFactory;
import org.eclipse.stem.model.ctdl.ctdl.DefStatement;
import org.eclipse.stem.model.ctdl.ctdl.MetamodelResource;
import org.eclipse.stem.model.ctdl.ctdl.ModelParamReference;
import org.eclipse.stem.model.ctdl.ctdl.RelativeCompartmentValueReference;
import org.eclipse.stem.model.ctdl.ctdl.ScopedVariableReference;
import org.eclipse.stem.model.ctdl.ctdl.TransitionBlock;
import org.eclipse.stem.model.ctdl.scoping.ExtensionAwareScope;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.FilteringScope;
import org.eclipse.xtext.scoping.impl.MultimapBasedScope;

public class CTDLScopeProvider
extends AbstractDeclarativeScopeProvider {
    private Model model;

    public void setTransition(Transition transition) {
        this.model = transition != null ? transition.getContainerModel() : null;
    }

    public IScope getScope(EObject context, EReference reference) {
        IScope scope = super.getScope(context, reference);
        return scope;
    }

    IScope scope_ScopedVariableReference(Block context, EReference reference) {
        ScopedVariableReference ref;
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(URI.createURI((String)"empty.sctd"));
        ArrayList<EObjectDescription> objs = new ArrayList<EObjectDescription>();
        for (DefStatement s : context.getStatements()) {
            ref = CtdlFactory.eINSTANCE.createDefStatementReference();
            ref.setName(s.getVarname());
            ref.setObj(s);
            objs.add(new EObjectDescription(QualifiedName.create((String)s.getVarname()), (EObject)ref, Collections.emptyMap()));
            resource.getContents().add((Object)ref);
        }
        for (Map.Entry<String, Class<?>> param : CTDLUtils.getGlobalUserVariables().entrySet()) {
            ref = CtdlFactory.eINSTANCE.createGlobalVariableReference();
            ref.setName(param.getKey());
            objs.add(new EObjectDescription(QualifiedName.create((String)param.getKey()), (EObject)ref, Collections.emptyMap()));
            resource.getContents().add((Object)ref);
        }
        Model model = this.getModelForContext(context);
        if (model == null) {
            model = this.model;
        }
        if (model != null) {
            for (ModelParam param : CTDLUtils.getAllParametersForModel(model)) {
                ModelParamReference ref2 = CtdlFactory.eINSTANCE.createModelParamReference();
                ref2.setObj(param);
                ref2.setName(param.getName());
                objs.add(new EObjectDescription(QualifiedName.create((String)param.getName()), (EObject)ref2, Collections.emptyMap()));
                resource.getContents().add((Object)ref2);
            }
            for (Compartment compartment : CTDLUtils.getAllCompartmentsForModel(model)) {
                RelativeCompartmentValueReference rcvRef = CtdlFactory.eINSTANCE.createRelativeCompartmentValueReference();
                rcvRef.setObj(compartment);
                rcvRef.setName(CTDLUtils.lcfirst(compartment.getName()));
                objs.add(new EObjectDescription(QualifiedName.create((String)rcvRef.getName()), (EObject)rcvRef, Collections.emptyMap()));
                resource.getContents().add((Object)rcvRef);
                AbsoluteCompartmentValueReference avcRef = CtdlFactory.eINSTANCE.createAbsoluteCompartmentValueReference();
                avcRef.setObj(compartment);
                avcRef.setName(CTDLUtils.ucfirst(compartment.getName()));
                objs.add(new EObjectDescription(QualifiedName.create((String)avcRef.getName()), (EObject)avcRef, Collections.emptyMap()));
                resource.getContents().add((Object)avcRef);
            }
        }
        return new FilteringScope(MultimapBasedScope.createScope((IScope)this.getDelegate().getScope((EObject)context, reference), objs, (boolean)false), (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return true;
            }
        });
    }

    IScope scope_FunctionReference(Block context, EReference reference) {
        IScope parent = this.getDelegate().getScope((EObject)context, reference);
        return new ExtensionAwareScope(parent, context);
    }

    private Model getModelForContext(EObject context) {
        EObject root = context;
        while (root.eContainer() != null) {
            root = root.eContainer();
        }
        CompartmentTransitionDefinitions def = null;
        if (root instanceof CompartmentTransitionDefinitions) {
            def = (CompartmentTransitionDefinitions)root;
        } else {
            TreeIterator te = root.eAllContents();
            while (te.hasNext()) {
                EObject obj = (EObject)te.next();
                if (!(obj instanceof CompartmentTransitionDefinitions)) continue;
                return ((CompartmentTransitionDefinitions)obj).getMetamodel().getModel();
            }
        }
        Model model = null;
        if (def != null && def.getMetamodel() != null) {
            model = def.getMetamodel().getModel();
        }
        if (model == null && context.eResource() instanceof ContextSensitiveResourceWrapper) {
            model = ((ContextSensitiveResourceWrapper)context.eResource()).getModel();
        }
        return model;
    }

    IScope scope_Transition(TransitionBlock context, EReference reference) {
        Model model = ((CompartmentTransitionDefinitions)context.eContainer()).getMetamodel().getModel();
        ArrayList<EObjectDescription> objs = new ArrayList<EObjectDescription>();
        if (model != null) {
            for (Transition t : model.getTransitions()) {
                objs.add(new EObjectDescription(QualifiedName.create((String)(String.valueOf(t.getSource().getName()) + "->" + t.getTarget().getName())), (EObject)t, Collections.emptyMap()));
            }
        }
        return MultimapBasedScope.createScope((IScope)IScope.NULLSCOPE, objs, (boolean)true);
    }

    IScope scope_Package(MetamodelResource context, EReference reference) {
        ArrayList objs = new ArrayList();
        return MultimapBasedScope.createScope((IScope)IScope.NULLSCOPE, objs, (boolean)true);
    }

    IScope scope_Model(MetamodelResource context, EReference reference) {
        ArrayList<EObjectDescription> objs = new ArrayList<EObjectDescription>();
        if (context.getPackage() != null) {
            for (Model model : context.getPackage().getModels()) {
                objs.add(new EObjectDescription(QualifiedName.create((String)model.getName()), (EObject)model, Collections.emptyMap()));
            }
        }
        return MultimapBasedScope.createScope((IScope)IScope.NULLSCOPE, objs, (boolean)true);
    }
}

