/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.analysis.AnalysisFactory;
import org.eclipse.stem.analysis.AnalysisPackage;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.ThresholdErrorFunction;
import org.eclipse.stem.analysis.impl.AnalysisFactoryImpl;
import org.eclipse.stem.analysis.impl.ErrorFunctionImpl;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

public class ThresholdErrorFunctionImpl
extends ErrorFunctionImpl
implements ThresholdErrorFunction {
    Map<String, List<Double>> commonInfectiousLocationsA = new HashMap<String, List<Double>>();
    Map<String, List<Double>> commonInfectiousLocationsB = new HashMap<String, List<Double>>();
    Map<String, Double> maxInfA = new HashMap<String, Double>();
    Map<String, Double> maxInfB = new HashMap<String, Double>();
    public double[] meanSqDiff;
    public double[] time;
    protected AnalysisFactory aFactory = new AnalysisFactoryImpl();
    protected static double THRESHOLD = 0.1;

    @Override
    protected EClass eStaticClass() {
        return AnalysisPackage.Literals.THRESHOLD_ERROR_FUNCTION;
    }

    @Override
    public ErrorResult calculateError(ReferenceScenarioDataMap reference, ReferenceScenarioDataMap data) {
        ReferenceScenarioDataMapImpl _ref = (ReferenceScenarioDataMapImpl)reference;
        ReferenceScenarioDataMapImpl _data = (ReferenceScenarioDataMapImpl)data;
        double denominator = 0.0;
        this.time = null;
        Iterator<String> iteratorA = _ref.getLocations().iterator();
        int maxTime = -1;
        while (iteratorA.hasNext()) {
            String id = iteratorA.next();
            if (!_data.containsLocation(id)) continue;
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapA = _ref.getLocation(id);
            List<Double> dataAI = this.getInfectious(dataMapA);
            this.commonInfectiousLocationsA.put(id, dataAI);
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapB = _data.getLocation(id);
            List<Double> dataBI = this.getInfectious(dataMapB);
            this.commonInfectiousLocationsB.put(id, dataBI);
            double maxA = -1.0;
            for (double d : dataAI) {
                if (!(d > maxA)) continue;
                maxA = d;
            }
            double maxB = -1.0;
            for (double d : dataBI) {
                if (!(d > maxB)) continue;
                maxB = d;
            }
            this.maxInfA.put(id, maxA);
            this.maxInfB.put(id, maxB);
            if (maxTime == -1) {
                maxTime = dataAI.size();
            }
            if (maxTime >= dataBI.size()) {
                maxTime = dataBI.size();
            }
            if (maxTime < dataAI.size()) continue;
            maxTime = dataAI.size();
        }
        if (maxTime <= 0) {
            maxTime = 0;
        }
        if (this.time == null) {
            this.time = new double[maxTime];
            this.meanSqDiff = new double[maxTime];
            int i = 0;
            while (i < maxTime) {
                this.time[i] = i;
                this.meanSqDiff[i] = 0.0;
                ++i;
            }
        }
        double[] maxPopulation = new double[this.time.length];
        int icount = 0;
        while (icount < this.time.length) {
            maxPopulation[icount] = 0.0;
            for (String id : this.commonInfectiousLocationsA.keySet()) {
                List<Double> dataAI = this.commonInfectiousLocationsA.get(id);
                List<Double> dataBI = this.commonInfectiousLocationsB.get(id);
                double iA = dataAI.get(icount);
                double iB = dataBI.get(icount);
                double maxA = this.maxInfA.get(id);
                double maxB = this.maxInfB.get(id);
                if (!(iA > maxA * THRESHOLD) && !(iB > maxB * THRESHOLD)) continue;
                double term = Math.abs(iA - iB);
                int n = icount;
                this.meanSqDiff[n] = this.meanSqDiff[n] + term;
                if (iA > iB) {
                    denominator += iA;
                    continue;
                }
                denominator += iB;
            }
            ++icount;
        }
        double result = 0.0;
        BasicEList list = new BasicEList();
        int i = 0;
        while (i < this.time.length) {
            this.meanSqDiff[i] = this.meanSqDiff[i] / denominator;
            result += this.meanSqDiff[i];
            list.add((Object)this.meanSqDiff[i]);
            ++i;
        }
        ErrorResult resultobj = this.aFactory.createErrorResult();
        resultobj.setErrorByTimeStep((EList<Double>)list);
        resultobj.setError(result);
        return resultobj;
    }
}

