/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPartitioner;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.jobs.execution.ExecutableManager;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListenerSync;
import org.eclipse.stem.jobs.simulation.Messages;
import org.eclipse.stem.jobs.simulation.Simulation;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;

public class SimulationManager
extends ExecutableManager
implements ISimulationListener {
    private static volatile SimulationManager INSTANCE = null;
    private static int sequenceNumber = 0;
    private final List<ISimulationManagerListener> listeners = new CopyOnWriteArrayList<ISimulationManagerListener>();
    private final List<ISimulationManagerListenerSync> listenersSync = new CopyOnWriteArrayList<ISimulationManagerListenerSync>();
    public static final ISimulation[] NONE = new Simulation[0];
    private List<ISimulation> activeSimulations = new ArrayList<ISimulation>();
    private GraphPartitioner partitioner;

    private SimulationManager() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("scenario", new XMIResourceFactoryImpl());
        this.partitioner = GraphFactory.eINSTANCE.createSimpleGraphPartitioner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SimulationManager getManager() {
        if (INSTANCE != null) return INSTANCE;
        Class<SimulationManager> clazz = SimulationManager.class;
        synchronized (SimulationManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SimulationManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static final synchronized int getAndIncrementSimulationSequenceNumber() {
        return sequenceNumber++;
    }

    public static final void resetSimulationManager() {
        INSTANCE = null;
        sequenceNumber = 0;
    }

    public final List<ISimulation> getActiveSimulations() {
        return this.activeSimulations;
    }

    public void setGraphPartitioner(GraphPartitioner p) {
        this.partitioner = p;
    }

    public GraphPartitioner getGraphPartitioner() {
        return this.partitioner;
    }

    private final void addActiveSimulation(ISimulation simulation) {
        this.activeSimulations.add(simulation);
        simulation.addSimulationListener(this);
        this.fireSimulationManagerChanged(new ISimulation[]{simulation}, NONE);
    }

    private final void removeActiveSimulation(ISimulation simulation) {
        this.activeSimulations.remove(simulation);
        simulation.removeSimulationListener(this);
        this.fireSimulationManagerChanged(NONE, new ISimulation[]{simulation});
    }

    public ISimulation createSimulation(IConfigurationElement configurationElement, IProgressMonitor monitor) {
        ISimulation retValue = null;
        String scenarioURIString = configurationElement.getAttribute("identifier");
        try {
            retValue = this.createSimulation(URI.createURI((String)scenarioURIString), monitor);
        }
        catch (Exception e) {
            Activator.logError(MessageFormat.format(Messages.getString("SimMgr.Deserialization_Error"), scenarioURIString), e);
            retValue = null;
        }
        return retValue;
    }

    public ISimulation createSimulation(URI scenarioURI, IProgressMonitor monitor) {
        ISimulation retValue = null;
        try {
            monitor.subTask("Reading Scenario from file");
            Scenario simulationScenario = (Scenario)Utility.getIdentifiable((URI)scenarioURI);
            monitor.subTask("Creating Simulation from Scenario");
            retValue = this.createSimulation(simulationScenario, monitor);
        }
        catch (Exception e) {
            Activator.logError(MessageFormat.format(Messages.getString("SimMgr.Deserialization_Error"), scenarioURI.toString()), e);
            retValue = null;
        }
        return retValue;
    }

    public ISimulation createSimulation(Scenario scenario, IProgressMonitor monitor) {
        Simulation retValue = null;
        try {
            Scenario copiedScenario = (Scenario)EcoreUtil.copy((EObject)scenario);
            if (scenario.getModel() != null) {
                copiedScenario.setModel((Model)EcoreUtil.copy((EObject)scenario.getModel()));
            }
            if (scenario.getSequencer() != null) {
                copiedScenario.setSequencer((Sequencer)EcoreUtil.copy((EObject)scenario.getSequencer()));
            }
            GraphPartitioner copiedPartition = (GraphPartitioner)EcoreUtil.copy((EObject)this.partitioner);
            Simulation simulation = new Simulation(copiedScenario, SimulationManager.getAndIncrementSimulationSequenceNumber(), copiedPartition);
            if (copiedScenario.getCanonicalGraph() == null) {
                copiedScenario.initialize();
            } else {
                copiedScenario.reset();
            }
            simulation.setPriority(30);
            retValue = simulation;
            this.addActiveSimulation(retValue);
        }
        catch (ScenarioInitializationException se) {
            Simulation.handleException(se, true);
            retValue = null;
        }
        return retValue;
    }

    public void createAndRunSimulation(final IConfigurationElement configurationElement) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("SimMgr.CrtSim"), -1);
                try {
                    ISimulation simulation = SimulationManager.this.createSimulation(configurationElement, monitor);
                    monitor.subTask(Messages.getString("SimMgr.Run"));
                    simulation.run();
                }
                catch (NullPointerException nullPointerException) {
                    monitor.done();
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndRunSimulation(final Scenario scenario) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISimulation simulation = SimulationManager.this.createSimulation(scenario, monitor);
                    monitor.subTask(Messages.getString("SimMgr.Run"));
                    simulation.run();
                }
                catch (Exception e) {
                    monitor.done();
                    Activator.logError(e.getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndStepSimulation(final IConfigurationElement configurationElement) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISimulation simulation = SimulationManager.this.createSimulation(configurationElement, monitor);
                    monitor.subTask(Messages.getString("SimMgr.Run"));
                    simulation.step();
                }
                catch (NullPointerException nullPointerException) {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndStepSimulation(final Scenario scenario) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISimulation simulation = SimulationManager.this.createSimulation(scenario, monitor);
                    monitor.subTask(Messages.getString("SimMgr.Run"));
                    simulation.step();
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public ISimulation mapGraphToSimulation(Graph graph) {
        ISimulation retValue = null;
        for (ISimulation simulation : this.activeSimulations) {
            Graph simulationGraph = simulation.getScenario().getCanonicalGraph();
            if (graph != simulationGraph) continue;
            retValue = simulation;
            break;
        }
        return retValue;
    }

    public void addSimulationManagerListener(ISimulationManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addSimulationManagerListenerSync(ISimulationManagerListenerSync listener) {
        if (!this.listenersSync.contains(listener)) {
            this.listenersSync.add(listener);
        }
    }

    public void removeListener(ISimulationManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListenerSync(ISimulationManagerListenerSync listener) {
        this.listenersSync.remove(listener);
    }

    private void fireSimulationManagerChanged(ISimulation[] simulationsAdded, ISimulation[] simulationsRemoved) {
        final SimulationManagerEvent event = new SimulationManagerEvent(this, simulationsAdded, simulationsRemoved);
        for (final ISimulationManagerListener iSimulationManagerListener : this.listeners) {
            DisplaySafeExecutor.executeAsync(new Runnable(){

                @Override
                public void run() {
                    iSimulationManagerListener.simulationsChanged(event);
                }
            });
        }
        for (final ISimulationManagerListenerSync iSimulationManagerListenerSync : this.listenersSync) {
            DisplaySafeExecutor.executeSync(new Runnable(){

                @Override
                public void run() {
                    iSimulationManagerListenerSync.simulationsChangedSync(event);
                }
            });
        }
    }

    @Override
    public void simulationChanged(SimulationEvent event) {
        if (event.getSimulationState().equals((Object)SimulationState.STOPPED)) {
            this.removeActiveSimulation(event.getSimulation());
            event.getSimulation().destroy();
        }
    }
}

