/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.contentassist.ManifestContentAssistProcessor;
import org.eclipse.pde.internal.ui.editor.text.AnnotationHover;
import org.eclipse.pde.internal.ui.editor.text.BasePDEScanner;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.ManifestPartitionScanner;
import org.eclipse.pde.internal.ui.editor.text.ManifestTextHover;

public class ManifestConfiguration
extends ChangeAwareSourceViewerConfiguration {
    private IAnnotationHover fAnnotationHover;
    private BasePDEScanner fPropertyKeyScanner = new ManifestHeaderScanner();
    private BasePDEScanner fPropertyValueScanner = new ManifestValueScanner();
    private ContentAssistant fContentAssistant;
    private ManifestContentAssistProcessor fContentAssistantProcessor;
    private ManifestTextHover fTextHover;
    private String fDocumentPartitioning;

    public ManifestConfiguration(IColorManager manager) {
        this(manager, null, null);
    }

    public ManifestConfiguration(IColorManager manager, PDESourcePage page) {
        this(manager, page, null);
    }

    public ManifestConfiguration(IColorManager manager, PDESourcePage page, String documentPartitioning) {
        super(page, manager);
        this.fDocumentPartitioning = documentPartitioning;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        String[] partitions = ManifestPartitionScanner.PARTITIONS;
        String[] all = new String[partitions.length + 1];
        all[0] = "__dftl_partition_content_type";
        System.arraycopy(partitions, 0, all, 1, partitions.length);
        return all;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationHover();
        }
        return this.fAnnotationHover;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fPropertyKeyScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fPropertyValueScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__mf_bundle_header_value");
        reconciler.setRepairer((IPresentationRepairer)dr, "__mf_bundle_header_value");
        return reconciler;
    }

    @Override
    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.startsWith("editor.color.header_key") || property.startsWith("editor.color.header_osgi") || property.startsWith("editor.color.header_value") || property.startsWith("editor.color.header_attributes") || property.startsWith("editor.color.header_assignment");
    }

    @Override
    public boolean affectsColorPresentation(PropertyChangeEvent event) {
        String property = event.getProperty();
        return property.equals("editor.color.header_key") || property.equals("editor.color.header_osgi") || property.equals("editor.color.header_value") || property.equals("editor.color.header_attributes") || property.equals("editor.color.header_assignment");
    }

    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.affectsColorPresentation(event)) {
            this.fColorManager.handlePropertyChangeEvent(event);
        }
        this.fPropertyKeyScanner.adaptToPreferenceChange(event);
        this.fPropertyValueScanner.adaptToPreferenceChange(event);
    }

    @Override
    public void dispose() {
        if (this.fContentAssistantProcessor != null) {
            this.fContentAssistantProcessor.dispose();
        }
        super.dispose();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fSourcePage != null && this.fSourcePage.isEditable()) {
            if (this.fContentAssistant == null) {
                this.fContentAssistant = new ContentAssistant(true);
                this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
                this.fContentAssistantProcessor = new ManifestContentAssistProcessor(this.fSourcePage);
                this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fContentAssistantProcessor, "__dftl_partition_content_type");
                this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fContentAssistantProcessor, "__mf_bundle_header_value");
                this.fContentAssistant.addCompletionListener((ICompletionListener)this.fContentAssistantProcessor);
                this.fContentAssistant.enableAutoInsert(true);
                this.fContentAssistant.setInformationControlCreator(parent -> new DefaultInformationControl(parent, false));
                this.fContentAssistant.setContextInformationPopupOrientation(20);
                this.fContentAssistant.enableAutoActivation(true);
            }
            return this.fContentAssistant;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fTextHover == null && this.fSourcePage != null) {
            this.fTextHover = new ManifestTextHover(this.fSourcePage);
        }
        return this.fTextHover;
    }

    @Override
    protected int getInfoImplementationType() {
        return 2;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    class AssignmentDetector
    implements IWordDetector {
        AssignmentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == ':' || c == '=';
        }

        public boolean isWordPart(char c) {
            return false;
        }
    }

    class KeywordDetector
    implements IWordDetector {
        KeywordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return c != ':' && c != '=' && !Character.isSpaceChar(c);
        }
    }

    class ManifestHeaderScanner
    extends BasePDEScanner {
        private Token fToken;

        public ManifestHeaderScanner() {
            super(ManifestConfiguration.this.fColorManager);
        }

        @Override
        public boolean affectsTextPresentation(String property) {
            return property.startsWith("editor.color.header_key") || property.startsWith("editor.color.header_osgi");
        }

        @Override
        protected Token getTokenAffected(PropertyChangeEvent event) {
            if (event.getProperty().startsWith("editor.color.header_osgi")) {
                return this.fToken;
            }
            return (Token)this.fDefaultReturnToken;
        }

        @Override
        protected void initialize() {
            this.fToken = new Token((Object)this.createTextAttribute("editor.color.header_osgi"));
            WordRule rule = new WordRule((IWordDetector)new KeywordDetector(), Token.UNDEFINED, true);
            rule.addWord("Bundle-Activator", (IToken)this.fToken);
            rule.addWord("Bundle-Category", (IToken)this.fToken);
            rule.addWord("Bundle-ClassPath", (IToken)this.fToken);
            rule.addWord("Bundle-ContactAddress", (IToken)this.fToken);
            rule.addWord("Bundle-Copyright", (IToken)this.fToken);
            rule.addWord("Bundle-Description", (IToken)this.fToken);
            rule.addWord("Bundle-DocURL", (IToken)this.fToken);
            rule.addWord("Bundle-Localization", (IToken)this.fToken);
            rule.addWord("Bundle-ManifestVersion", (IToken)this.fToken);
            rule.addWord("Bundle-Name", (IToken)this.fToken);
            rule.addWord("Bundle-NativeCode", (IToken)this.fToken);
            rule.addWord("Bundle-RequiredExecutionEnvironment", (IToken)this.fToken);
            rule.addWord("Bundle-SymbolicName", (IToken)this.fToken);
            rule.addWord("Bundle-UpdateLocation", (IToken)this.fToken);
            rule.addWord("Bundle-Vendor", (IToken)this.fToken);
            rule.addWord("Bundle-Version", (IToken)this.fToken);
            rule.addWord("Require-Bundle", (IToken)this.fToken);
            rule.addWord("DynamicImport-Package", (IToken)this.fToken);
            rule.addWord("Export-Package", (IToken)this.fToken);
            rule.addWord("Export-Service", (IToken)this.fToken);
            rule.addWord("Fragment-Host", (IToken)this.fToken);
            rule.addWord("Import-Package", (IToken)this.fToken);
            rule.addWord("Import-Service", (IToken)this.fToken);
            rule.addWord("Provide-Package", (IToken)this.fToken);
            rule.addWord("Bundle-ActivationPolicy", (IToken)this.fToken);
            rule.addWord("Automatic-Module-Name", (IToken)this.fToken);
            rule.addWord("Manifest-Version", (IToken)this.fToken);
            this.setRules(new IRule[]{rule});
            this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("editor.color.header_key")));
        }
    }

    class ManifestValueScanner
    extends BasePDEScanner {
        private Token fAssignmentToken;
        private Token fAttributeToken;

        public ManifestValueScanner() {
            super(ManifestConfiguration.this.fColorManager);
        }

        @Override
        public boolean affectsTextPresentation(String property) {
            return property.startsWith("editor.color.header_assignment") || property.startsWith("editor.color.header_value") || property.startsWith("editor.color.header_attributes");
        }

        @Override
        protected Token getTokenAffected(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.startsWith("editor.color.header_assignment")) {
                return this.fAssignmentToken;
            }
            if (property.startsWith("editor.color.header_attributes")) {
                return this.fAttributeToken;
            }
            return (Token)this.fDefaultReturnToken;
        }

        @Override
        protected void initialize() {
            IRule[] rules = new IRule[2];
            this.fAssignmentToken = new Token((Object)this.createTextAttribute("editor.color.header_assignment"));
            rules[0] = new WordRule((IWordDetector)new AssignmentDetector(), (IToken)this.fAssignmentToken);
            this.fAttributeToken = new Token((Object)this.createTextAttribute("editor.color.header_attributes"));
            WordRule rule = new WordRule((IWordDetector)new KeywordDetector());
            rule.addWord("language", (IToken)this.fAttributeToken);
            rule.addWord("osname", (IToken)this.fAttributeToken);
            rule.addWord("osversion", (IToken)this.fAttributeToken);
            rule.addWord("processor", (IToken)this.fAttributeToken);
            rule.addWord("bundle-symbolic-name", (IToken)this.fAttributeToken);
            rule.addWord("bundle-version", (IToken)this.fAttributeToken);
            rule.addWord("exclude", (IToken)this.fAttributeToken);
            rule.addWord("fragment-attachment", (IToken)this.fAttributeToken);
            rule.addWord("include", (IToken)this.fAttributeToken);
            rule.addWord("mandatory", (IToken)this.fAttributeToken);
            rule.addWord("resolution", (IToken)this.fAttributeToken);
            rule.addWord("singleton", (IToken)this.fAttributeToken);
            rule.addWord("uses", (IToken)this.fAttributeToken);
            rule.addWord("version", (IToken)this.fAttributeToken);
            rule.addWord("visibility", (IToken)this.fAttributeToken);
            rule.addWord("x-friends", (IToken)this.fAttributeToken);
            rule.addWord("x-internal", (IToken)this.fAttributeToken);
            rule.addWord("specification-version", (IToken)this.fAttributeToken);
            String[] stringArray = ICoreConstants.EE_TOKENS;
            int n = ICoreConstants.EE_TOKENS.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                rule.addWord(token, (IToken)this.fAttributeToken);
                ++n2;
            }
            rules[1] = rule;
            this.setRules(rules);
            this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("editor.color.header_value")));
        }
    }
}

