/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.adapters.time.TimeProviderAdapterFactory;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.widgets.PropertySelector;
import org.eclipse.stem.util.loggers.views.LogWriter;
import org.eclipse.stem.util.loggers.views.LoggerControl;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DataHistoryLogger
extends LoggerControl
implements ISimulationListenerSync {
    Label loggerTypeLabel;
    Label loggerDiseaseLabel;
    LogWriter logWriter;
    Graph graph = null;
    TimeProvider timeProvider = null;
    PropertySelector propertySelector;
    private final PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (rvp != null) {
                rvp.setTarget((Notifier)dynamicLabel);
                for (Object element : rvp.getProperties()) {
                    ItemPropertyDescriptor property = (ItemPropertyDescriptor)element;
                    retValue.add(property);
                }
            }
            return retValue;
        }
    };

    public DataHistoryLogger(Composite parent, LogWriter logWriter, ISimulation simulation, IntegrationDecorator dm) {
        super(parent, 0);
        this.logWriter = logWriter;
        this.setSimulation(simulation);
        this.setDiseaseModel(dm);
        this.createContents();
    }

    private void createContents() {
        FillLayout layout = new FillLayout(256);
        this.setLayout((Layout)layout);
        Composite inner = new Composite((Composite)this, 0);
        FormLayout innerLayout = new FormLayout();
        inner.setLayout((Layout)innerLayout);
        Display display = this.getDisplay();
        Color colorColumn1 = new Color((Device)display, new RGB(180, 180, 200));
        Color colorColumn2 = new Color((Device)display, new RGB(190, 190, 220));
        Color colorColumn3 = new Color((Device)display, new RGB(180, 180, 200));
        Color bgColor = new Color((Device)display, new RGB(170, 170, 190));
        inner.setBackground(bgColor);
        this.propertySelector = new PropertySelector(inner, 0, true);
        this.loggerTypeLabel = new Label(inner, 0x1000000);
        this.loggerTypeLabel.setBackground(colorColumn1);
        this.loggerTypeLabel.setText("CSV Logger");
        this.loggerTypeLabel.setAlignment(0x1000000);
        if (this.simulationNameLabel == null) {
            this.simulationNameLabel = new Label(inner, 0x1000000);
            this.simulationNameLabel.setText(this.simulation.getName());
            this.simulationNameLabel.setBackground(colorColumn2);
            this.simulationNameLabel.setAlignment(0x1000000);
        }
        this.loggerDiseaseLabel = new Label(inner, 0x1000000);
        this.loggerDiseaseLabel.setBackground(colorColumn3);
        String idtext = null;
        if (this.diseaseModel instanceof DiseaseModel) {
            idtext = ((DiseaseModel)this.diseaseModel).getDiseaseName();
        } else if (this.diseaseModel instanceof PopulationModel) {
            idtext = ((PopulationModel)this.diseaseModel).getName();
        }
        this.loggerDiseaseLabel.setText(idtext);
        this.loggerDiseaseLabel.setAlignment(0x1000000);
        FormData loggerNameLabelFormData = new FormData();
        loggerNameLabelFormData.top = new FormAttachment(0, 0);
        loggerNameLabelFormData.left = new FormAttachment(0, 0);
        loggerNameLabelFormData.right = new FormAttachment(25, 0);
        loggerNameLabelFormData.bottom = new FormAttachment(0, 100);
        this.loggerTypeLabel.setLayoutData((Object)loggerNameLabelFormData);
        FormData simulationNameLabelFormData = new FormData();
        simulationNameLabelFormData.top = new FormAttachment(0, 0);
        simulationNameLabelFormData.left = new FormAttachment(25, 0);
        simulationNameLabelFormData.right = new FormAttachment(50, 0);
        simulationNameLabelFormData.bottom = new FormAttachment(0, 100);
        this.simulationNameLabel.setLayoutData((Object)simulationNameLabelFormData);
        FormData loggerIdLabelFormData = new FormData();
        loggerIdLabelFormData.top = new FormAttachment(0, 0);
        loggerIdLabelFormData.left = new FormAttachment(50, 0);
        loggerIdLabelFormData.right = new FormAttachment(90, 0);
        loggerIdLabelFormData.bottom = new FormAttachment(0, 100);
        this.loggerDiseaseLabel.setLayoutData((Object)loggerIdLabelFormData);
        this.propertySelector.setSize(0, 0);
        FormData propertySelectorFormData = new FormData();
        propertySelectorFormData.top = new FormAttachment(0, 0);
        propertySelectorFormData.left = new FormAttachment(100, 0);
        propertySelectorFormData.right = new FormAttachment(100, 0);
        this.propertySelector.setLayoutData((Object)propertySelectorFormData);
        this.propertySelector.setVisible(false);
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator) {
        ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            retValue.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
        }
        return retValue;
    }

    @Override
    public void remove() {
        if (this.logWriter != null) {
            this.logWriter.closeLoggerData();
        }
        this.logWriter = null;
        this.removeListeners.clear();
        this.propertySelector.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    public void setIdentifiable() {
    }

    @Override
    protected void initializeFromSimulation(ISimulation simulation) {
        this.graph = simulation.getScenario().getCanonicalGraph();
        this.timeProvider = (TimeProvider)TimeProviderAdapterFactory.INSTANCE.adapt((Notifier)this.graph, TimeProvider.class);
    }

    @Override
    public void refresh2() {
        if (this.logWriter != null) {
            this.logWriter.flushLoggerData();
        }
    }

    public void simulationChangedSync(SimulationEvent event) {
        if (event.getSimulationState() == SimulationState.RUNNING) {
            if (this.logWriter != null && this.logWriter.needsHeader) {
                this.logWriter.logHeader(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider);
                this.logWriter.logData(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider, true);
            }
        } else if (event.getSimulationState() == SimulationState.COMPLETED_CYCLE) {
            if (this.logWriter != null) {
                this.logWriter.logData(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider, false);
            }
        } else if (event.getSimulationState() == SimulationState.PAUSED) {
            if (this.logWriter != null) {
                this.logWriter.flushLoggerData();
            }
        } else if (event.getSimulationState() == SimulationState.STOPPED) {
            if (this.logWriter != null) {
                LogWriter logRef = this.logWriter;
                this.logWriter = null;
                logRef.closeLoggerData();
            }
            this.dispose();
        }
    }

    public void dispose() {
        if (this.logWriter != null) {
            this.logWriter.closeLoggerData();
        }
        this.logWriter = null;
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        super.dispose();
    }

    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

