/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard;

import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TaskRegistrationEntry;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IRegistrationListener;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.birt.core.ui.i18n.Messages;
import org.eclipse.birt.core.ui.utils.UIHelper;

public class TasksManager {
    private transient LinkedHashMap<String, TaskRegistrationEntry> registeredTasks = new LinkedHashMap();
    private transient Hashtable<String, Vector<String>> registeredWizards = new Hashtable();
    private transient Vector<IRegistrationListener> registeredListeners = new Vector();
    private static TasksManager thisInstance = null;

    public static TasksManager instance() {
        if (thisInstance == null) {
            thisInstance = new TasksManager();
        }
        return thisInstance;
    }

    private TasksManager() {
        this.processExtensions();
    }

    private void processExtensions() {
        if (UIHelper.isEclipseMode()) {
            String sID;
            int i;
            IConfigurationElement[] elements;
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.birt.core.ui", "tasks").getExtensions();
            int iC = 0;
            while (iC < extensions.length) {
                elements = extensions[iC].getConfigurationElements();
                i = 0;
                while (i < elements.length) {
                    try {
                        TaskRegistrationEntry entry;
                        sID = elements[i].getAttribute("taskID");
                        String strPriority = elements[i].getAttribute("priority");
                        int priority = 0;
                        try {
                            priority = Integer.valueOf(strPriority);
                        }
                        catch (NumberFormatException numberFormatException) {
                            priority = 0;
                        }
                        if (!this.registeredTasks.containsKey(sID) || (entry = this.registeredTasks.get(sID)).getPriority() < priority) {
                            ITask task = (ITask)elements[i].createExecutableExtension("classDefinition");
                            TaskRegistrationEntry entry2 = new TaskRegistrationEntry(sID, task, priority);
                            this.registeredTasks.put(sID, entry2);
                        }
                    }
                    catch (FrameworkException e) {
                        WizardBase.displayException(e);
                    }
                    ++i;
                }
                ++iC;
            }
            extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.birt.core.ui", "taskWizards").getExtensions();
            iC = 0;
            while (iC < extensions.length) {
                elements = extensions[iC].getConfigurationElements();
                i = 0;
                while (i < elements.length) {
                    sID = elements[i].getAttribute("wizardID");
                    String sTaskList = elements[i].getAttribute("tasklist");
                    String[] sTasks = new String[]{};
                    if (sTaskList != null) {
                        sTasks = sTaskList.split(",");
                    }
                    if (this.registeredWizards.containsKey(sID)) {
                        int iInsertionPosition;
                        int insertIndex;
                        String sInsertionKey = elements[i].getAttribute("positionBefore");
                        try {
                            insertIndex = Integer.parseInt(sInsertionKey);
                        }
                        catch (NumberFormatException numberFormatException) {
                            insertIndex = -1;
                        }
                        Vector<String> vTemp = this.registeredWizards.get(sID);
                        if (sInsertionKey != null && sInsertionKey.trim().length() > 0 && insertIndex < 0 && (iInsertionPosition = this.registeredWizards.get(sID).indexOf(sInsertionKey)) != -1) {
                            int iTaskIndex = 0;
                            while (iTaskIndex < sTasks.length) {
                                vTemp.add(iInsertionPosition + iTaskIndex, sTasks[iTaskIndex].trim());
                                ++iTaskIndex;
                            }
                        } else {
                            this.registeredWizards.put(sID, this.addAllTasks(vTemp, sTasks, insertIndex));
                        }
                    } else if (sTaskList != null && sTaskList.trim().length() > 0) {
                        this.registeredWizards.put(sID, this.addAllTasks(new Vector<String>(), sTasks, -1));
                    } else {
                        this.registeredWizards.put(sID, new Vector());
                    }
                    ++i;
                }
                ++iC;
            }
        }
    }

    private Vector<String> addAllTasks(Vector<String> vTemp, String[] sTasks, int insertIndex) {
        int iTaskIndex = 0;
        while (iTaskIndex < sTasks.length) {
            if (insertIndex >= 0) {
                vTemp.add(iTaskIndex + insertIndex, sTasks[iTaskIndex].trim());
            } else {
                vTemp.add(sTasks[iTaskIndex].trim());
            }
            ++iTaskIndex;
        }
        return vTemp;
    }

    private void updateWizard(String sWizardID, String sTasks, String sPosition) {
        Vector<Object> vTaskList = new Vector();
        if (this.registeredWizards.containsKey(sWizardID)) {
            vTaskList = this.registeredWizards.get(sWizardID);
        }
        if (sTasks != null && sTasks.trim().length() > 0) {
            String[] sTaskArr = sTasks.split(",");
            int i = 0;
            while (i < sTaskArr.length) {
                vTaskList.add(sTaskArr[i]);
                ++i;
            }
        }
        this.registeredWizards.put(sWizardID, vTaskList);
    }

    public void registerTask(String sTaskID, ITask task) throws IllegalArgumentException {
        if (this.registeredTasks.containsKey(sTaskID) || task == null) {
            throw new IllegalArgumentException(Messages.getFormattedString("TasksManager.Exception.RegisterTask", sTaskID));
        }
        this.registeredTasks.put(sTaskID, new TaskRegistrationEntry(sTaskID, task, 0));
        this.fireTaskRegisteredEvent(sTaskID);
    }

    public void deregisterTask(String sTaskID) throws IllegalArgumentException {
        if (!this.registeredTasks.containsKey(sTaskID)) {
            throw new IllegalArgumentException(Messages.getFormattedString("TasksManager.Exception.DeregisterTask", sTaskID));
        }
        this.registeredTasks.remove(sTaskID);
        this.fireTaskDeregisteredEvent(sTaskID);
    }

    public void registerWizard(String sWizardID, String sTasks, String sPosition) throws IllegalArgumentException {
        if (sWizardID == null) {
            throw new IllegalArgumentException(Messages.getString("TasksManager.Excepion.RegisterWizard"));
        }
        this.updateWizard(sWizardID, sTasks, sPosition);
    }

    public ITask getTask(String sTaskID) {
        if (!this.isRegistered(sTaskID)) {
            return null;
        }
        return this.registeredTasks.get(sTaskID).getClassDefinition();
    }

    public String[] getTasksForWizard(String sWizardID) {
        if (this.registeredWizards.containsKey(sWizardID)) {
            Vector<String> vTemp = this.registeredWizards.get(sWizardID);
            String[] sTasks = new String[vTemp.size()];
            int iTaskCount = 0;
            while (iTaskCount < vTemp.size()) {
                sTasks[iTaskCount] = vTemp.get(iTaskCount);
                ++iTaskCount;
            }
            return sTasks;
        }
        return new String[0];
    }

    public boolean isRegistered(String sTaskID) {
        boolean b = this.registeredTasks.containsKey(sTaskID);
        return b;
    }

    public void addRegistrationListener(IRegistrationListener listener) {
        this.registeredListeners.add(listener);
    }

    public void removeRegistrationListener(IRegistrationListener listener) {
        this.registeredListeners.remove(listener);
    }

    private void fireTaskRegisteredEvent(String sTaskID) {
        int i = 0;
        while (i < this.registeredListeners.size()) {
            this.registeredListeners.get(i).taskRegistered(sTaskID);
            ++i;
        }
    }

    private void fireTaskDeregisteredEvent(String sTaskID) {
        int i = 0;
        while (i < this.registeredListeners.size()) {
            this.registeredListeners.get(i).taskDeregistered(sTaskID);
            ++i;
        }
    }
}

