/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.stem.analysis.Activator;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.common.util.LogInitializationException;

public class CSVScenarioStreamer
extends CSVscenarioLoader {
    public static final int NUM_LEAD_COLS = 2;
    private int bufferSize;
    private boolean restart = true;
    TreeMap<Integer, RowData> rowData = new TreeMap();
    Map<String, Map<Integer, Map<String, BufferedReader>>> streamReaders = new HashMap<String, Map<Integer, Map<String, BufferedReader>>>();
    Map<String, Map<Integer, Map<String, File>>> streamReaderFiles = new HashMap<String, Map<Integer, Map<String, File>>>();
    Map<String, Map<Integer, Map<String, Integer>>> streamReaderCurrentRow = new HashMap<String, Map<Integer, Map<String, Integer>>>();
    Map<String, Map<Integer, Map<String, List<Double>>>> streamReadersAggregateRows = new HashMap<String, Map<Integer, Map<String, List<Double>>>>();
    Map<String, Map<Integer, List<String>>> headersMap = new HashMap<String, Map<Integer, List<String>>>();
    private long timeStepMS = -1L;
    private Map<String, Map<String, Map<Integer, List<Double>>>> cumulativeOffsets = new HashMap<String, Map<String, Map<Integer, List<Double>>>>();
    private String[] dateFormatStrings = new String[]{"yyyy-MM-dd HH:mm:ss", "EEE d MMM yy", "M/d/yyyy"};

    public CSVScenarioStreamer(String path, int bufferSize, boolean restart, String[] cumulativeStates) throws LogInitializationException {
        super(path);
        this.bufferSize = bufferSize;
        this.restart = restart;
        int i = 0;
        while (i < cumulativeStates.length) {
            this.cumulativeOffsets.put(cumulativeStates[i], new HashMap());
            ++i;
        }
    }

    public void prepareForStreaming(String populationId, int resolution) throws IOException, LogInitializationException {
        if (!this.csvDataFiles.containsKey(populationId)) {
            throw new LogInitializationException("Population not found: " + populationId);
        }
        List fileList = (List)this.csvDataFiles.get(populationId);
        int i = 0;
        while (i < fileList.size()) {
            File f = (File)fileList.get(i);
            String name = f.getName();
            if (!f.getName().startsWith(".")) {
                int _idx = name.lastIndexOf(95);
                int dotidx = name.lastIndexOf(46);
                if (_idx >= 0 && dotidx >= 0 && dotidx >= _idx) {
                    String state = name.substring(0, _idx);
                    CSVScenarioStreamer.registerKey(state);
                    int res = Integer.parseInt(name.substring(_idx + 1, dotidx));
                    if (resolution == -1 || res == resolution) {
                        this.openFile(populationId, state, f, res);
                    }
                }
            }
            ++i;
        }
    }

    public void openFile(String population, String state, File f, int adminLevel) throws IOException, LogInitializationException {
        int i;
        Iterator<String> date;
        StringTokenizer st;
        BufferedReader reader = new BufferedReader(new FileReader(f));
        SimpleDateFormat[] dateFormats = new SimpleDateFormat[this.dateFormatStrings.length];
        int i2 = 0;
        while (i2 < this.dateFormatStrings.length) {
            dateFormats[i2] = new SimpleDateFormat(this.dateFormatStrings[i2], Locale.getDefault());
            ++i2;
        }
        Date date1 = null;
        Date date2 = null;
        String data = reader.readLine();
        if (data == null) {
            if (reader != null) {
                reader.close();
            }
            throw new LogInitializationException("Empty file" + f.getAbsolutePath());
        }
        data = reader.readLine();
        if (data != null) {
            st = new StringTokenizer(data, ",");
            st.nextToken();
            date = st.nextToken().trim();
            i = 0;
            while (i < dateFormats.length) {
                try {
                    date1 = dateFormats[i].parse((String)((Object)date));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                ++i;
            }
            if (date1 == null) {
                if (reader != null) {
                    reader.close();
                }
                throw new LogInitializationException("Unable to parse date string " + (String)((Object)date));
            }
        } else {
            if (reader != null) {
                reader.close();
            }
            throw new LogInitializationException("Unable to determine time step from log file " + f.getAbsolutePath());
        }
        data = reader.readLine();
        if (data != null) {
            st = new StringTokenizer(data, ",");
            st.nextToken().trim();
            date = st.nextToken().trim();
            i = 0;
            while (i < dateFormats.length) {
                try {
                    date2 = dateFormats[i].parse((String)((Object)date));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                ++i;
            }
            if (date2 == null) {
                if (reader != null) {
                    reader.close();
                }
                throw new LogInitializationException("Unable to parse date string " + (String)((Object)date));
            }
        } else {
            if (reader != null) {
                reader.close();
            }
            throw new LogInitializationException("Unable to determine time step from log file " + f.getAbsolutePath());
        }
        if (this.timeStepMS == -1L) {
            this.timeStepMS = date2.getTime() - date1.getTime();
        } else if (this.timeStepMS != date2.getTime() - date1.getTime()) {
            if (reader != null) {
                reader.close();
            }
            throw new LogInitializationException("Inconsistent time step (compared to other log files) found in " + f.getAbsolutePath());
        }
        reader.close();
        reader = new BufferedReader(new FileReader(f));
        if (!this.streamReaders.containsKey(population)) {
            this.streamReaders.put(population, new HashMap());
            this.streamReaderFiles.put(population, new HashMap());
            this.streamReaderCurrentRow.put(population, new HashMap());
            this.streamReadersAggregateRows.put(population, new HashMap());
            for (String s : this.cumulativeOffsets.keySet()) {
                this.cumulativeOffsets.get(s).put(population, new HashMap());
            }
        }
        if (!this.streamReaders.get(population).containsKey(adminLevel)) {
            this.streamReaders.get(population).put(adminLevel, new HashMap());
            this.streamReaderFiles.get(population).put(adminLevel, new HashMap());
            this.streamReaderCurrentRow.get(population).put(adminLevel, new HashMap());
            this.streamReadersAggregateRows.get(population).put(adminLevel, new HashMap());
            for (String s : this.cumulativeOffsets.keySet()) {
                this.cumulativeOffsets.get(s).get(population).put(adminLevel, null);
            }
        }
        Map<String, BufferedReader> stateReaderMap = this.streamReaders.get(population).get(adminLevel);
        Map<String, File> stateReadeFilesMap = this.streamReaderFiles.get(population).get(adminLevel);
        Map<String, Integer> stateRowMap = this.streamReaderCurrentRow.get(population).get(adminLevel);
        Map<String, List<Double>> stateAggregateRows = this.streamReadersAggregateRows.get(population).get(adminLevel);
        stateReaderMap.put(state, reader);
        stateReadeFilesMap.put(state, f);
        stateRowMap.put(state, -1);
        stateAggregateRows.put(state, null);
        String header = reader.readLine();
        if (header != null) {
            Map<Integer, List<String>> adminMap;
            if (!this.headersMap.containsKey(population)) {
                this.headersMap.put(population, new HashMap());
            }
            if (!(adminMap = this.headersMap.get(population)).containsKey(adminLevel)) {
                ArrayList<String> headerElements = new ArrayList<String>();
                adminMap.put(adminLevel, headerElements);
                StringTokenizer st2 = new StringTokenizer(header, ",");
                int col = 0;
                while (st2.hasMoreTokens()) {
                    String val = st2.nextToken().trim();
                    if (col < 2) {
                        ++col;
                        continue;
                    }
                    headerElements.add(val);
                    ++col;
                }
            }
        }
    }

    public List<Double> streamRow(String population, int adminLevel, String state) throws IOException {
        List<Double> internalRow = this.internalStreamRow(population, adminLevel, state);
        if (internalRow != null) {
            return internalRow;
        }
        if (this.restart) {
            for (Map.Entry<String, Map<Integer, Map<String, BufferedReader>>> entry : this.streamReaders.entrySet()) {
                for (Map.Entry<Integer, Map<String, BufferedReader>> entry2 : entry.getValue().entrySet()) {
                    for (Map.Entry<String, BufferedReader> entry3 : entry2.getValue().entrySet()) {
                        while (this.internalStreamRow(entry.getKey(), entry2.getKey(), entry3.getKey()) != null) {
                        }
                        if (entry3.getValue() == null) continue;
                        BufferedReader reader = entry3.getValue();
                        File f = this.streamReaderFiles.get(entry.getKey()).get(entry2.getKey()).get(entry3.getKey());
                        reader.close();
                        reader = new BufferedReader(new FileReader(f));
                        entry3.setValue(reader);
                        reader.readLine();
                    }
                }
            }
            RowData rd = this.rowData.lastEntry().getValue();
            for (Map.Entry<String, Map<String, Map<Integer, List<Double>>>> entry : this.cumulativeOffsets.entrySet()) {
                for (Map.Entry<String, Map<Integer, List<Double>>> entry2 : entry.getValue().entrySet()) {
                    for (Map.Entry<Integer, List<Double>> entry3 : entry2.getValue().entrySet()) {
                        List<Double> dataList = rd.getData(entry2.getKey(), entry3.getKey(), entry.getKey());
                        entry3.setValue(dataList);
                    }
                }
            }
            return this.streamRow(population, adminLevel, state);
        }
        RowData last = this.rowData.lastEntry().getValue();
        return last.getData(population, adminLevel, state);
    }

    private List<Double> internalStreamRow(String population, int adminLevel, String state) throws IOException {
        BufferedReader br = this.streamReaders.get(population).get(adminLevel).get(state);
        if (br == null) {
            return null;
        }
        String data = br.readLine();
        if (data != null) {
            int currentRow = this.streamReaderCurrentRow.get(population).get(adminLevel).get(state) + 1;
            RowData currentRowData = null;
            if (!this.rowData.containsKey(currentRow)) {
                currentRowData = new RowData();
                this.rowData.put(currentRow, currentRowData);
                if (this.rowData.size() > this.bufferSize) {
                    this.rowData.remove(this.rowData.firstEntry().getKey());
                }
            } else {
                currentRowData = this.rowData.get(currentRow);
            }
            if (!currentRowData.hasPopulation(population)) {
                currentRowData.addPopulation(population);
            }
            if (!currentRowData.hasAdminLevel(population, adminLevel)) {
                currentRowData.addAdminLevel(population, adminLevel);
            }
            if (!currentRowData.hasState(population, adminLevel, state)) {
                currentRowData.addState(population, adminLevel, state);
            }
            if (this.streamReadersAggregateRows.get(population).get(adminLevel).get(state) == null) {
                this.streamReadersAggregateRows.get(population).get(adminLevel).put(state, new ArrayList());
            }
            List<Double> result = currentRowData.getData(population, adminLevel, state);
            List<Double> aggregateResult = this.streamReadersAggregateRows.get(population).get(adminLevel).get(state);
            result.clear();
            StringTokenizer st = new StringTokenizer(data, ",");
            int col = 0;
            while (st.hasMoreTokens()) {
                List<Double> offsetData;
                String val = st.nextToken().trim();
                if (col < 2) {
                    ++col;
                    continue;
                }
                double d = Double.parseDouble(val);
                Map<String, Map<Integer, List<Double>>> offsets = this.cumulativeOffsets.get(state);
                if (offsets != null && (offsetData = this.cumulativeOffsets.get(state).get(population).get(adminLevel)) != null) {
                    d += offsetData.get(col - 2).doubleValue();
                }
                result.add(d);
                if (aggregateResult.size() <= col - 2) {
                    aggregateResult.add(d);
                } else {
                    aggregateResult.set(col - 2, aggregateResult.get(col - 2) + d);
                }
                ++col;
            }
            this.streamReaderCurrentRow.get(population).get(adminLevel).put(state, currentRow);
            return result;
        }
        return null;
    }

    public void resetAggregate(String population, int adminLevel, String state, List<Double> initState) {
        List<Double> aggregateResult = this.streamReadersAggregateRows.get(population).get(adminLevel).get(state);
        if (aggregateResult == null) {
            return;
        }
        if (initState == null || initState.size() == 0) {
            aggregateResult.clear();
        } else {
            aggregateResult.clear();
            for (Double d : initState) {
                aggregateResult.add(d);
            }
        }
    }

    public boolean reachedEndOfFile(String population, int adminLevel, String state) throws IOException {
        BufferedReader br = this.streamReaders.get(population).get(adminLevel).get(state);
        if (br == null) {
            return true;
        }
        boolean markSupported = br.markSupported();
        if (!markSupported) {
            System.err.println("Stream does not support mark!");
        } else {
            char[] c = new char[16];
            br.mark(16);
            int n = br.read(c);
            br.reset();
            if (n == 0 || n == -1) {
                br.close();
                this.streamReaders.get(population).get(adminLevel).put(state, null);
                return true;
            }
        }
        return false;
    }

    public int getCurrentRow(String population, int adminLevel, String state) {
        return this.streamReaderCurrentRow.get(population).get(adminLevel).get(state);
    }

    public boolean containsState(String population, int adminLevel, String state) {
        return this.streamReaderCurrentRow.get(population).get(adminLevel).containsKey(state);
    }

    public List<Double> getNthFetchedRow(String population, int adminLevel, String state, int row) {
        if (!this.rowData.containsKey(row)) {
            Activator.logError("Row not available " + row + ". Increasing buffersize is recommended.", new Exception());
        }
        RowData rd = this.rowData.get(row);
        List<Double> result = rd.getData(population, adminLevel, state);
        return result;
    }

    public List<Double> getAggregateResult(String population, int adminLevel, String state) {
        List<Double> result = this.streamReadersAggregateRows.get(population).get(adminLevel).get(state);
        return result;
    }

    public int getDataPosition(String population, int adminLevel, String key) {
        return this.headersMap.get(population).get(adminLevel).indexOf(key);
    }

    public void close() throws IOException {
        if (this.streamReaders == null) {
            return;
        }
        for (Map.Entry<String, Map<Integer, Map<String, BufferedReader>>> entry : this.streamReaders.entrySet()) {
            for (Map.Entry<Integer, Map<String, BufferedReader>> entry2 : entry.getValue().entrySet()) {
                for (Map.Entry<String, BufferedReader> entry3 : entry2.getValue().entrySet()) {
                    if (entry3.getValue() == null) continue;
                    entry3.getValue().close();
                }
            }
        }
        this.rowData.clear();
        this.streamReaders.clear();
        this.streamReaderCurrentRow.clear();
        this.streamReadersAggregateRows.clear();
    }

    public long getTimeStepMS() {
        return this.timeStepMS;
    }

    public class RowData {
        Map<String, Map<Integer, Map<String, List<Double>>>> streamReadersRowData = new HashMap<String, Map<Integer, Map<String, List<Double>>>>();

        public void addPopulation(String population) {
            this.streamReadersRowData.put(population, new HashMap());
        }

        public boolean hasPopulation(String population) {
            return this.streamReadersRowData.containsKey(population);
        }

        public void addAdminLevel(String population, int adminLevel) {
            this.streamReadersRowData.get(population).put(adminLevel, new HashMap());
        }

        public boolean hasAdminLevel(String population, int adminLevel) {
            return this.streamReadersRowData.get(population).containsKey(adminLevel);
        }

        public void addState(String population, int adminLevel, String state) {
            this.streamReadersRowData.get(population).get(adminLevel).put(state, new ArrayList());
        }

        public boolean hasState(String population, int adminLevel, String state) {
            return this.streamReadersRowData.get(population).get(adminLevel).containsKey(state);
        }

        public List<Double> getData(String population, int adminLevel, String state) {
            return this.streamReadersRowData.get(population).get(adminLevel).get(state);
        }
    }
}

