/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.Parameter;
import org.eclipse.stem.util.analysis.SEIRparameterEstimator;

public class NonLinearSEIRParameterEstimator
extends SEIRparameterEstimator {
    double[] e;
    double[] r;

    public NonLinearSEIRParameterEstimator(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        super(data);
        ArrayList<Double> sToFit = new ArrayList<Double>();
        ArrayList<Double> eToFit = new ArrayList<Double>();
        ArrayList<Double> iToFit = new ArrayList<Double>();
        ArrayList<Double> rToFit = new ArrayList<Double>();
        List sList = data.getStotals();
        List eList = data.getEtotals();
        List iList = data.getItotals();
        List rList = data.getRtotals();
        int icount = 1;
        while (icount < iList.size()) {
            iToFit.add((Double)iList.get(icount));
            eToFit.add((Double)eList.get(icount));
            sToFit.add((Double)sList.get(icount));
            rToFit.add((Double)rList.get(icount));
            ++icount;
        }
        this.numDataPoints = iToFit.size();
        if (this.numDataPoints < 7) {
            return;
        }
        this.dataValid = true;
        this.s = new double[this.numDataPoints];
        this.e = new double[this.numDataPoints];
        this.i = new double[this.numDataPoints];
        this.r = new double[this.numDataPoints];
        this.t = new double[this.numDataPoints];
        int npts = this.numDataPoints;
        double[][] dataS = new double[2][npts - 1];
        double[][] dataE = new double[2][npts - 1];
        double[][] dataI = new double[2][npts - 1];
        double[][] dataR = new double[2][npts - 1];
        int icount2 = 0;
        while (icount2 < this.numDataPoints) {
            this.s[icount2] = (Double)sToFit.get(icount2);
            this.e[icount2] = (Double)eToFit.get(icount2);
            this.i[icount2] = (Double)iToFit.get(icount2);
            this.r[icount2] = (Double)rToFit.get(icount2);
            this.t[icount2] = icount2;
            if (icount2 < this.numDataPoints - 1) {
                dataS[0][icount2] = (this.s[icount2] + this.s[icount2 + 1]) / 2.0;
                dataE[0][icount2] = (this.e[icount2] + this.e[icount2 + 1]) / 2.0;
                dataI[0][icount2] = (this.i[icount2] + this.i[icount2 + 1]) / 2.0;
                dataR[0][icount2] = (this.r[icount2] + this.r[icount2 + 1]) / 2.0;
                dataS[1][icount2] = (this.s[icount2] + this.s[icount2 + 1]) / 2.0;
                dataE[1][icount2] = (this.e[icount2] + this.e[icount2 + 1]) / 2.0;
                dataI[1][icount2] = (this.i[icount2] + this.i[icount2 + 1]) / 2.0;
                dataR[1][icount2] = (this.r[icount2] + this.r[icount2 + 1]) / 2.0;
                int chartIndex = 0;
                while (chartIndex < 4) {
                    dataS[1][icount2] = 0.0;
                    dataE[1][icount2] = 0.0;
                    dataI[1][icount2] = 0.0;
                    dataR[1][icount2] = 0.0;
                    ++chartIndex;
                }
            }
            ++icount2;
        }
    }

    @Override
    public ModelParameters estimate(double localDensity, double localPopulation, String locationID) {
        ModelParameters fittedParms = null;
        double CRITICAL_SUSCEPTIBLE = 0.3;
        int npts = this.s.length;
        assert (npts == this.e.length);
        assert (npts == this.i.length);
        assert (npts == this.r.length);
        double[] dS = new double[npts];
        double[] lnE = new double[npts];
        double[] dlnE = new double[npts];
        int j = 0;
        while (j < npts) {
            lnE[j] = Math.log(this.e[j]);
            ++j;
        }
        dS[0] = this.s[1] - this.s[0];
        dS[npts - 1] = this.s[npts - 1] - this.s[npts - 2];
        dlnE[0] = lnE[1] - lnE[0];
        dlnE[npts - 1] = lnE[npts - 1] - lnE[npts - 2];
        j = 1;
        while (j < npts - 1) {
            dS[j] = (this.s[j + 1] - this.s[j - 1]) / 2.0;
            dlnE[j] = (lnE[j + 1] - lnE[j - 1]) / 2.0;
            ++j;
        }
        double[] x = new double[npts];
        double[] y = new double[npts];
        int j2 = 0;
        while (j2 < npts) {
            x[j2] = this.r[j2] / this.e[j2];
            y[j2] = 1.0 / this.e[j2] * dS[j2] + dlnE[j2];
            ++j2;
        }
        double sumx = 0.0;
        double sumy = 0.0;
        double sumxy = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        double sum = 0.0;
        int j3 = 0;
        while (j3 < npts) {
            sumx += x[j3];
            sumy += y[j3];
            sumxy += x[j3] * y[j3];
            sumx2 += x[j3] * x[j3];
            sumy2 += y[j3] * y[j3];
            sum += 1.0;
            ++j3;
        }
        double delta = -(sum * sumx2 - sumx * sumx);
        double alpha = -(sum * sumxy - sumx * sumy) / delta;
        double epsilon = (sumx2 * sumy - sumx * sumxy) / delta;
        double variance = (sumy2 + sum * epsilon * epsilon + alpha * alpha * sumx2 - 2.0 * (alpha * sumxy - epsilon * sumy + epsilon * alpha * sumx)) / (double)(npts - 2);
        double varAlpha = -(variance / delta) * sum;
        double varEpsilon = -(variance / delta) * sumx2;
        double stdAlpha = Math.sqrt(varAlpha);
        double stdEpsilon = Math.sqrt(varEpsilon);
        int j4 = 0;
        while (j4 < npts) {
            x[j4] = Math.log((this.s[j4] + this.e[j4] + this.i[j4] - 0.3) / 0.7);
            y[j4] = Math.log((alpha * this.r[j4] - dS[j4]) / (this.s[j4] * this.i[j4]));
            ++j4;
        }
        sumx = 0.0;
        sumy = 0.0;
        sumxy = 0.0;
        sumx2 = 0.0;
        sumy2 = 0.0;
        sum = 0.0;
        j4 = 0;
        while (j4 < npts) {
            sumx += x[j4];
            sumy += y[j4];
            sumxy += x[j4] * y[j4];
            sumx2 += x[j4] * x[j4];
            sumy2 += y[j4] * y[j4];
            sum += 1.0;
            ++j4;
        }
        delta = sum * sumx2 - sumx * sumx;
        double lnBeta = (sumy * sumx2 - sumx * sumxy) / delta;
        double lambda = (sum * sumxy - sumx * sumy) / delta;
        double beta = Math.exp(lnBeta);
        variance = (sumy2 + lnBeta * lnBeta * sum + lambda * lambda * sumx2 - 2.0 * (lnBeta * sumy + lambda * sumxy + lnBeta * lambda * sumx)) / (double)(npts - 2);
        double varLnBeta = variance / delta * sumx2;
        double varLambda = variance / delta * sum;
        double stdLnBeta = Math.sqrt(varLnBeta);
        double stdLambda = Math.sqrt(varLambda);
        fittedParms = new ModelParameters();
        double newbeta = beta;
        if (!useFreqDependantBeta) {
            newbeta *= 100.0 / localDensity;
        }
        fittedParms.addParameter("beta", new Parameter("beta", newbeta));
        fittedParms.addParameter("lnbeta", new Parameter("lnbeta", lnBeta, stdLnBeta, varLnBeta));
        fittedParms.addParameter("alpha", new Parameter("alpha", alpha, stdAlpha, varAlpha));
        fittedParms.addParameter("epsilon", new Parameter("epsilon", epsilon, stdEpsilon, varEpsilon));
        fittedParms.addParameter("lambda", new Parameter("lambda", lambda, stdLambda, varLambda));
        return fittedParms;
    }
}

