/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.AreaLabelValue;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapter;

public class AreaRelativeValueColorProviderAdapter
extends AbstractRelativeValueColorProviderAdapter {
    private static Map<String, Double> areaValueMap = new HashMap<String, Double>();

    @Override
    public float getRelativeValue() {
        Graph graph = this.selectedDecorator.getGraph();
        URI areaLabelURI = STEMURI.createURI((String)"label/area");
        HashMap<String, Double> tempAreaValueMap = new HashMap<String, Double>();
        for (URI labelUri : graph.getNodeLabels().keySet()) {
            String indexUri;
            if (!labelUri.toString().startsWith(areaLabelURI.toString()) || !tempAreaValueMap.containsKey(indexUri = String.valueOf(labelUri.segment(2)) + "/" + labelUri.segment(3))) continue;
            Double prevValue = (Double)tempAreaValueMap.remove(indexUri);
            AreaLabel areaLabel = (AreaLabel)graph.getNodeLabel(labelUri);
            Double newValue = prevValue + areaLabel.getCurrentAreaValue().getArea();
            tempAreaValueMap.put(indexUri, newValue);
        }
        return 0.7f;
    }

    private double getArea() {
        if (!(this.getTarget() instanceof Region)) {
            return -1.0;
        }
        double retVal = -1.0;
        Region region = (Region)this.getTarget();
        for (NodeLabel nodeLabel : region.getLabels()) {
            if (!(nodeLabel instanceof AreaLabel)) continue;
            AreaLabel label = (AreaLabel)nodeLabel;
            AreaLabelValue value = (AreaLabelValue)label.getCurrentValue();
            retVal = value.getArea();
        }
        return retVal;
    }

    @Override
    public void setSelectedProperty(ItemPropertyDescriptor selectedProperty) {
    }
}

