/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.DoubleValueMatrix;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.foodproduction.DiseaseCarryingTransformer;
import org.eclipse.stem.foodproduction.FoodproductionPackage;
import org.eclipse.stem.foodproduction.SlaughterHouse;
import org.eclipse.stem.foodproduction.impl.FoodProducerImpl;
import org.eclipse.stem.populationmodels.Activator;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;

public class SlaughterHouseImpl
extends FoodProducerImpl
implements SlaughterHouse {
    protected IntegrationDecorator sourceDecorator;
    protected IntegrationDecorator targetDecorator;
    protected DoubleValueMatrix stateTransitionsMap;
    protected EList<EAttribute> sourceAttributes;
    protected EList<EAttribute> targetAttributes;

    @Override
    protected EClass eStaticClass() {
        return FoodproductionPackage.Literals.SLAUGHTER_HOUSE;
    }

    @Override
    public IntegrationDecorator getSourceDecorator() {
        if (this.sourceDecorator != null && this.sourceDecorator.eIsProxy()) {
            InternalEObject oldSourceDecorator = (InternalEObject)this.sourceDecorator;
            this.sourceDecorator = (IntegrationDecorator)this.eResolveProxy(oldSourceDecorator);
            if (this.sourceDecorator != oldSourceDecorator && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 15, (Object)oldSourceDecorator, (Object)this.sourceDecorator));
            }
        }
        return this.sourceDecorator;
    }

    public IntegrationDecorator basicGetSourceDecorator() {
        return this.sourceDecorator;
    }

    @Override
    public void setSourceDecorator(IntegrationDecorator newSourceDecorator) {
        IntegrationDecorator oldSourceDecorator = this.sourceDecorator;
        this.sourceDecorator = newSourceDecorator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldSourceDecorator, (Object)this.sourceDecorator));
        }
    }

    @Override
    public IntegrationDecorator getTargetDecorator() {
        if (this.targetDecorator != null && this.targetDecorator.eIsProxy()) {
            InternalEObject oldTargetDecorator = (InternalEObject)this.targetDecorator;
            this.targetDecorator = (IntegrationDecorator)this.eResolveProxy(oldTargetDecorator);
            if (this.targetDecorator != oldTargetDecorator && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 16, (Object)oldTargetDecorator, (Object)this.targetDecorator));
            }
        }
        return this.targetDecorator;
    }

    public IntegrationDecorator basicGetTargetDecorator() {
        return this.targetDecorator;
    }

    @Override
    public void setTargetDecorator(IntegrationDecorator newTargetDecorator) {
        IntegrationDecorator oldTargetDecorator = this.targetDecorator;
        this.targetDecorator = newTargetDecorator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldTargetDecorator, (Object)this.targetDecorator));
        }
    }

    @Override
    public DoubleValueMatrix getStateTransitionsMap() {
        return this.stateTransitionsMap;
    }

    public NotificationChain basicSetStateTransitionsMap(DoubleValueMatrix newStateTransitionsMap, NotificationChain msgs) {
        DoubleValueMatrix oldStateTransitionsMap = this.stateTransitionsMap;
        this.stateTransitionsMap = newStateTransitionsMap;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldStateTransitionsMap, (Object)newStateTransitionsMap);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStateTransitionsMap(DoubleValueMatrix newStateTransitionsMap) {
        if (newStateTransitionsMap != this.stateTransitionsMap) {
            NotificationChain msgs = null;
            if (this.stateTransitionsMap != null) {
                msgs = ((InternalEObject)this.stateTransitionsMap).eInverseRemove((InternalEObject)this, -18, null, msgs);
            }
            if (newStateTransitionsMap != null) {
                msgs = ((InternalEObject)newStateTransitionsMap).eInverseAdd((InternalEObject)this, -18, null, msgs);
            }
            if ((msgs = this.basicSetStateTransitionsMap(newStateTransitionsMap, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)newStateTransitionsMap, (Object)newStateTransitionsMap));
        }
    }

    @Override
    public EList<EAttribute> getSourceAttributes() {
        if (this.sourceAttributes == null) {
            this.sourceAttributes = new EObjectResolvingEList(EAttribute.class, (InternalEObject)this, 18);
        }
        return this.sourceAttributes;
    }

    @Override
    public EList<EAttribute> getTargetAttributes() {
        if (this.targetAttributes == null) {
            this.targetAttributes = new EObjectResolvingEList(EAttribute.class, (InternalEObject)this, 19);
        }
        return this.targetAttributes;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 17: {
                return this.basicSetStateTransitionsMap(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 15: {
                if (resolve) {
                    return this.getSourceDecorator();
                }
                return this.basicGetSourceDecorator();
            }
            case 16: {
                if (resolve) {
                    return this.getTargetDecorator();
                }
                return this.basicGetTargetDecorator();
            }
            case 17: {
                return this.getStateTransitionsMap();
            }
            case 18: {
                return this.getSourceAttributes();
            }
            case 19: {
                return this.getTargetAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 15: {
                this.setSourceDecorator((IntegrationDecorator)newValue);
                return;
            }
            case 16: {
                this.setTargetDecorator((IntegrationDecorator)newValue);
                return;
            }
            case 17: {
                this.setStateTransitionsMap((DoubleValueMatrix)newValue);
                return;
            }
            case 18: {
                this.getSourceAttributes().clear();
                this.getSourceAttributes().addAll((Collection)newValue);
                return;
            }
            case 19: {
                this.getTargetAttributes().clear();
                this.getTargetAttributes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 15: {
                this.setSourceDecorator(null);
                return;
            }
            case 16: {
                this.setTargetDecorator(null);
                return;
            }
            case 17: {
                this.setStateTransitionsMap(null);
                return;
            }
            case 18: {
                this.getSourceAttributes().clear();
                return;
            }
            case 19: {
                this.getTargetAttributes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 15: {
                return this.sourceDecorator != null;
            }
            case 16: {
                return this.targetDecorator != null;
            }
            case 17: {
                return this.stateTransitionsMap != null;
            }
            case 18: {
                return this.sourceAttributes != null && !this.sourceAttributes.isEmpty();
            }
            case 19: {
                return this.targetAttributes != null && !this.targetAttributes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == DiseaseCarryingTransformer.class) {
            switch (derivedFeatureID) {
                case 15: {
                    return 0;
                }
                case 16: {
                    return 1;
                }
                case 17: {
                    return 2;
                }
                case 18: {
                    return 3;
                }
                case 19: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == DiseaseCarryingTransformer.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 15;
                }
                case 1: {
                    return 16;
                }
                case 2: {
                    return 17;
                }
                case 3: {
                    return 18;
                }
                case 4: {
                    return 19;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public void updateLabels(STEMTime time, long timeDelta, int cycle) {
        String sourcePopulation = this.getSourcePopulationName();
        String foodPopulation = this.getTargetPopulationName();
        for (DynamicLabel dl : this.getSourceLabels()) {
            String targetPop;
            double sourceConsumed;
            PopulationModelLabel pml;
            if (!(dl instanceof PopulationModelLabel) || !(pml = (PopulationModelLabel)dl).getPopulationIdentifier().equals(sourcePopulation)) continue;
            StandardPopulationModelLabelValue source = (StandardPopulationModelLabelValue)pml.getCurrentValue();
            double sourcePopulationCount = source.getCount();
            double remainingSourcePopulationCount = sourcePopulationCount - (sourceConsumed = this.sourceProcessingRate * ((double)timeDelta / (double)this.getTimePeriod()));
            if (remainingSourcePopulationCount < 0.0) {
                remainingSourcePopulationCount = 0.0;
                sourceConsumed = sourcePopulationCount;
            }
            source.setCount(remainingSourcePopulationCount);
            Node n = (Node)pml.getIdentifiable();
            StandardPopulationModelLabelValue foodPopValue = (StandardPopulationModelLabelValue)n.getLabel(StandardPackage.eINSTANCE.getStandardPopulationModelLabel(), GraphPackage.eINSTANCE.getIntegrationLabel_Identifier(), (Object)foodPopulation).getCurrentValue();
            if (foodPopValue == null) {
                Activator.logError((String)"Cannot find food population label", (Throwable)new Exception());
                continue;
            }
            double foodCreated = sourceConsumed * this.getFoodYieldPopulationMultiplier();
            foodPopValue.setCount(foodPopValue.getCount() + foodCreated);
            double fractionSourceRemaining = (sourcePopulationCount - sourceConsumed) / sourcePopulationCount;
            if (Double.isNaN(fractionSourceRemaining)) {
                fractionSourceRemaining = 0.0;
            }
            Node node = ((PopulationModelLabel)dl).getNode();
            DiseaseModelLabel sourceDiseaseLabel = null;
            EList nlList = node.getLabels();
            for (NodeLabel nl : nlList) {
                DiseaseModelLabel dml;
                if (!(nl instanceof DiseaseModelLabel) || !(targetPop = (dml = (DiseaseModelLabel)nl).getIdentifier()).equalsIgnoreCase(this.sourcePopulationName)) continue;
                sourceDiseaseLabel = dml;
                break;
            }
            nlList = node.getLabels();
            for (NodeLabel nl : nlList) {
                DiseaseModelLabel foodDiseaseLabel;
                if (!(nl instanceof DiseaseModelLabel) || !(targetPop = (foodDiseaseLabel = (DiseaseModelLabel)nl).getIdentifier()).equalsIgnoreCase(this.targetPopulationName)) continue;
                EList<EAttribute> sourceAttrList = this.getSourceAttributes();
                int row = 0;
                int col = 0;
                for (EAttribute sAttr : sourceAttrList) {
                    Double compartmentVal = (Double)sourceDiseaseLabel.getCurrentValue().eGet((EStructuralFeature)sAttr);
                    double originalSourceVal = compartmentVal;
                    double compartmentValueToMove = originalSourceVal * this.getFoodYieldPopulationMultiplier() * (sourceConsumed / sourcePopulationCount);
                    if (Double.isNaN(compartmentValueToMove)) {
                        compartmentValueToMove = 0.0;
                    }
                    EList<EAttribute> foodAttrList = this.getTargetAttributes();
                    for (EAttribute fAttr : foodAttrList) {
                        double compartmentMapFraction = ((DoubleValue)((DoubleValueList)this.getStateTransitionsMap().getValueLists().get(row)).getValues().get(col)).getValue();
                        Double currentCompartmentVal = (Double)foodDiseaseLabel.getCurrentValue().eGet((EStructuralFeature)fAttr);
                        double newCompartmentVal = compartmentValueToMove * compartmentMapFraction + currentCompartmentVal;
                        foodDiseaseLabel.getCurrentValue().eSet((EStructuralFeature)fAttr, (Object)newCompartmentVal);
                        ++col;
                    }
                    col = 0;
                    ++row;
                }
            }
            IntegrationLabelValue ilv = (IntegrationLabelValue)sourceDiseaseLabel.getCurrentValue();
            ilv.scale(fractionSourceRemaining);
        }
    }
}

