/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

public class ArabicNormalizer {
    public static final char ALEF = '\u0627';
    public static final char ALEF_MADDA = '\u0622';
    public static final char ALEF_HAMZA_ABOVE = '\u0623';
    public static final char ALEF_HAMZA_BELOW = '\u0625';
    public static final char YEH = '\u064a';
    public static final char DOTLESS_YEH = '\u0649';
    public static final char TEH_MARBUTA = '\u0629';
    public static final char HEH = '\u0647';
    public static final char TATWEEL = '\u0640';
    public static final char FATHATAN = '\u064b';
    public static final char DAMMATAN = '\u064c';
    public static final char KASRATAN = '\u064d';
    public static final char FATHA = '\u064e';
    public static final char DAMMA = '\u064f';
    public static final char KASRA = '\u0650';
    public static final char SHADDA = '\u0651';
    public static final char SUKUN = '\u0652';

    public int normalize(char[] s, int len) {
        for (int i = 0; i < len; ++i) {
            if (s[i] == '\u0622' || s[i] == '\u0623' || s[i] == '\u0625') {
                s[i] = 1575;
            }
            if (s[i] == '\u0649') {
                s[i] = 1610;
            }
            if (s[i] == '\u0629') {
                s[i] = 1607;
            }
            if (s[i] != '\u0640' && s[i] != '\u064d' && s[i] != '\u064c' && s[i] != '\u064b' && s[i] != '\u064e' && s[i] != '\u064f' && s[i] != '\u0650' && s[i] != '\u0651' && s[i] != '\u0652') continue;
            len = this.delete(s, i, len);
            --i;
        }
        return len;
    }

    protected int delete(char[] s, int pos, int len) {
        if (pos < len) {
            System.arraycopy(s, pos + 1, s, pos, len - pos - 1);
        }
        return len - 1;
    }
}

