/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.stem.util.analysis.views.TimeSeriesCanvas;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EpidemicControl
extends AnalysisControl {
    private static final String CONSUMER = "EPIDEMIC_CONTROL";
    private static final String AGGREGATE_FOLDER_KEY = "EPIDEMIC_CONTROL_AGGREGATE";
    private static final String REFERENCE_FOLDER_KEY = "EPIDEMIC_CONTROL_REFERENCE";
    static Label statusLabel;
    static Label scenarioFolderLabel;
    static Label aggregateFileLabel;
    public static Text aggregateDirtext;
    public static Text referenceDirtext;
    public static Text filetextAggregate;
    protected static double alpha;
    TimeSeriesCanvas aggregateDataCanvas;
    TimeSeriesCanvas newIncidenceCanvas;
    protected static final String[] incidenceStates;
    private static final String[] OMIT_LIST;
    static final ColorDefinition foreGround;
    static final ColorDefinition backgroundGround;
    static final ColorDefinition frameColor;
    final Color white = this.getDisplay().getSystemColor(1);
    final Color grey = this.getDisplay().getSystemColor(15);
    ScenarioAnalysisSuite analyzer = new ScenarioAnalysisSuite(this);
    private static String TITLE_TEXT;
    public List<List<Double>> aggregateData = new ArrayList<List<Double>>();
    public List<List<Double>> incidenceData = new ArrayList<List<Double>>();
    public List<String> primaryPropertiesToPlot = new ArrayList<String>();
    public List<String> secondaryPropertiesToPlot = new ArrayList<String>();
    private Button aggregateButton;
    protected Button useReferenceCheckbox;
    protected Button pickRefButton;
    private Button plotButton;

    static {
        alpha = 0.003;
        incidenceStates = new String[]{"Incidence", "deltaBirths", "deltaDeaths"};
        OMIT_LIST = new String[]{"time", "#iteration", "Incidence"};
        foreGround = ColorDefinitionImpl.create((int)180, (int)0, (int)0);
        backgroundGround = ColorDefinitionImpl.create((int)255, (int)255, (int)225);
        frameColor = ColorDefinitionImpl.WHITE();
        TITLE_TEXT = Messages.getString("COMMON.AGGREGATE_TITLE");
    }

    public EpidemicControl(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    void createContents() {
        this.setLayout((Layout)new FormLayout());
        Display display = this.getDisplay();
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(TITLE_TEXT);
        Font newFont = this.getLargerFont(18, display);
        this.identifiableTitle.setFont(newFont);
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(100, 0);
        int spacer = 10;
        int buttonspacer = 5;
        scenarioFolderLabel = new Label((Composite)this, 2048);
        scenarioFolderLabel.setText(Messages.getString("EPIVIEW.SCENARIOFOLDERLABEL"));
        FormData scenarioLabelFormData = new FormData();
        scenarioFolderLabel.setLayoutData((Object)scenarioLabelFormData);
        scenarioLabelFormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        scenarioLabelFormData.left = new FormAttachment(0, 0);
        scenarioLabelFormData.right = new FormAttachment(15, 0);
        aggregateDirtext = new Text((Composite)this, 2048);
        aggregateDirtext.setBounds(10, 10, 100, 20);
        String recentFolder = this.prefs.getRecentFolder(CONSUMER);
        if (recentFolder == null) {
            recentFolder = ScenarioAnalysisSuite.REFERENCE_TESTING_DIRECTORY;
        }
        aggregateDirtext.setText(recentFolder);
        FormData dirTextFormData = new FormData();
        aggregateDirtext.setLayoutData((Object)dirTextFormData);
        dirTextFormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        dirTextFormData.left = new FormAttachment((Control)scenarioFolderLabel, 5);
        dirTextFormData.right = new FormAttachment(80, 0);
        Button pickDirButton = new Button((Composite)this, 0);
        pickDirButton.setText(Messages.getString("EPIVIEW.SELECTDIR"));
        FormData pickDirButtonFormData = new FormData();
        pickDirButtonFormData.top = new FormAttachment((Control)this.identifiableTitle, buttonspacer);
        pickDirButtonFormData.left = new FormAttachment((Control)aggregateDirtext, 5);
        pickDirButton.setLayoutData((Object)pickDirButtonFormData);
        pickDirButton.setEnabled(true);
        final Shell shell = this.getShell();
        pickDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(Messages.getString("EPIVIEW.SELECTSCENARIOFOLDER"));
                String beginSearch = aggregateDirtext.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                dd.setFilterPath(beginSearch);
                String selected = dd.open();
                if (selected != null) {
                    aggregateDirtext.setText(selected);
                }
            }
        });
        this.useReferenceCheckbox = new Button((Composite)this, 32);
        this.useReferenceCheckbox.setText(Messages.getString("EPIVIEW.REFERENCEFOLDERLABEL"));
        this.useReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EpidemicControl.this.useReferenceCheckbox.getSelection()) {
                    referenceDirtext.setBackground(EpidemicControl.this.white);
                    String refFolder = EpidemicControl.this.prefs.getRecentFolder(EpidemicControl.REFERENCE_FOLDER_KEY);
                    if (refFolder == null && ((refFolder = aggregateDirtext.getText()) == null || refFolder.length() < 1)) {
                        refFolder = ROOT_PATH;
                    }
                    referenceDirtext.setText(refFolder);
                    EpidemicControl.this.pickRefButton.setEnabled(true);
                } else {
                    referenceDirtext.setBackground(EpidemicControl.this.grey);
                    EpidemicControl.this.pickRefButton.setEnabled(false);
                }
            }
        });
        FormData referenceLabelFormData = new FormData();
        this.useReferenceCheckbox.setLayoutData((Object)referenceLabelFormData);
        referenceLabelFormData.top = new FormAttachment((Control)scenarioFolderLabel, spacer);
        referenceLabelFormData.left = new FormAttachment(0, 0);
        referenceLabelFormData.right = new FormAttachment(15, 0);
        referenceDirtext = new Text((Composite)this, 2048);
        referenceDirtext.setBounds(10, 10, 100, 20);
        String refFolder = this.prefs.getRecentFolder(REFERENCE_FOLDER_KEY);
        if (refFolder == null) {
            refFolder = recentFolder;
        }
        referenceDirtext.setText(refFolder);
        FormData refDirTextFormData = new FormData();
        referenceDirtext.setLayoutData((Object)refDirTextFormData);
        refDirTextFormData.top = new FormAttachment((Control)scenarioFolderLabel, spacer);
        refDirTextFormData.left = new FormAttachment((Control)this.useReferenceCheckbox, 5);
        refDirTextFormData.right = new FormAttachment(80, 0);
        this.pickRefButton = new Button((Composite)this, 0);
        this.pickRefButton.setText(Messages.getString("EPIVIEW.SELECTDIR"));
        FormData pickRefButtonFormData = new FormData();
        pickRefButtonFormData.top = new FormAttachment((Control)scenarioFolderLabel, buttonspacer);
        pickRefButtonFormData.left = new FormAttachment((Control)referenceDirtext, 5);
        this.pickRefButton.setLayoutData((Object)pickRefButtonFormData);
        this.pickRefButton.setEnabled(true);
        this.pickRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(Messages.getString("EPIVIEW.SELECTREFERENCEFOLDER"));
                String beginSearch = referenceDirtext.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                dd.setFilterPath(beginSearch);
                String selected = dd.open();
                if (selected != null) {
                    referenceDirtext.setText(selected);
                }
            }
        });
        this.useReferenceCheckbox.setSelection(false);
        referenceDirtext.setBackground(this.grey);
        this.pickRefButton.setEnabled(false);
        Composite aggregateComposite = this.getAggregateButtonComposite(this, Messages.getString("EPIVIEW.AGGREGATEDATA"));
        FormData aggregateButtonFormData = new FormData();
        aggregateButtonFormData.top = new FormAttachment((Control)this.useReferenceCheckbox, spacer);
        aggregateButtonFormData.left = new FormAttachment(0, 0);
        aggregateButtonFormData.right = new FormAttachment(100, 0);
        aggregateComposite.setLayoutData((Object)aggregateButtonFormData);
        final ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        this.aggregateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String referenceDirectory = aggregateDirtext.getText();
                if (!EpidemicControl.this.analyzer.validate(referenceDirectory)) {
                    EpidemicControl.this.identifiableTitle.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    return;
                }
                EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.WORKING_MSG);
                String aggregateFilename = null;
                try {
                    aggregateFilename = EpidemicControl.this.useReferenceCheckbox.getSelection() ? EpidemicControl.this.analyzer.aggregateByFilter(referenceDirtext.getText(), aggregateDirtext.getText(), (IRunnableContext)progressDialog, alpha) : EpidemicControl.this.analyzer.aggregateData(aggregateDirtext.getText(), (IRunnableContext)progressDialog, alpha);
                    EpidemicControl.this.prefs.setRecentFolder(EpidemicControl.CONSUMER, aggregateDirtext.getText());
                    EpidemicControl.this.prefs.setRecentFolder(EpidemicControl.REFERENCE_FOLDER_KEY, referenceDirtext.getText());
                    EpidemicControl.this.prefs.setRecentFolder(EpidemicControl.AGGREGATE_FOLDER_KEY, aggregateFilename);
                }
                catch (LogInitializationException sie) {
                    EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.INVALID_DATA_MSG);
                    Activator.logError(sie.getMessage(), sie);
                }
                filetextAggregate.setText(aggregateFilename);
                EpidemicControl.this.updateMessage(ScenarioAnalysisSuite.READY_MSG);
            }
        });
        aggregateFileLabel = new Label((Composite)this, 2048);
        aggregateFileLabel.setText(Messages.getString("EPIVIEW.AGGFILELABEL"));
        FormData aggregateFileLabelFormData = new FormData();
        aggregateFileLabel.setLayoutData((Object)aggregateFileLabelFormData);
        aggregateFileLabelFormData.top = new FormAttachment((Control)aggregateComposite, spacer);
        aggregateFileLabelFormData.left = new FormAttachment(0, 0);
        aggregateFileLabelFormData.right = new FormAttachment(15, 0);
        filetextAggregate = new Text((Composite)this, 2048);
        filetextAggregate.setBounds(10, 10, 100, 20);
        String aggregateDir = this.prefs.getRecentFolder(AGGREGATE_FOLDER_KEY);
        filetextAggregate.setText(aggregateDir);
        FormData fileTextAggregateFormData = new FormData();
        filetextAggregate.setLayoutData((Object)fileTextAggregateFormData);
        fileTextAggregateFormData.top = new FormAttachment((Control)aggregateComposite, spacer);
        fileTextAggregateFormData.left = new FormAttachment((Control)aggregateFileLabel, 5);
        fileTextAggregateFormData.right = new FormAttachment(80, 0);
        Button pickAggregateFileButton = new Button((Composite)this, 0);
        pickAggregateFileButton.setText(Messages.getString("EPIVIEW.SELECTAGGFILE"));
        FormData pickAggregateFileButtonFormData = new FormData();
        pickAggregateFileButtonFormData.top = new FormAttachment((Control)aggregateComposite, buttonspacer);
        pickAggregateFileButtonFormData.left = new FormAttachment((Control)filetextAggregate, 5);
        pickAggregateFileButton.setLayoutData((Object)pickAggregateFileButtonFormData);
        pickAggregateFileButton.setEnabled(true);
        pickAggregateFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dd = new FileDialog(shell, 4096);
                dd.setText(Messages.getString("EPIVIEW.SELECTAGGFILE"));
                String beginSearch = filetextAggregate.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                dd.setFilterPath(beginSearch);
                String selected = dd.open();
                if (selected != null) {
                    filetextAggregate.setText(selected);
                }
            }
        });
        Composite plotButtonComposite = this.getPlotButtonComposite(this, Messages.getString("EPIVIEW.PLOTTEXT"));
        FormData plotButtonFormData = new FormData();
        plotButtonFormData.top = new FormAttachment((Control)aggregateFileLabel, spacer);
        plotButtonFormData.left = new FormAttachment(0, 0);
        plotButtonFormData.right = new FormAttachment(100, 0);
        plotButtonComposite.setLayoutData((Object)plotButtonFormData);
        final EpidemicControl aCtrl = this;
        this.plotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EpidemicControl.this.aggregateData.clear();
                EpidemicControl.this.primaryPropertiesToPlot.clear();
                EpidemicControl.this.secondaryPropertiesToPlot.clear();
                EpidemicControl.this.aggregateDataCanvas.reset();
                EpidemicControl.this.newIncidenceCanvas.reset();
                CSVscenarioLoader loader = new CSVscenarioLoader();
                ReferenceScenarioDataMapImpl aggregateMap = null;
                try {
                    aggregateMap = loader.parseAggregateFile(filetextAggregate.getText());
                }
                catch (LogInitializationException e1) {
                    Activator.logError(e1.getMessage(), e1);
                }
                for (String location : aggregateMap.getLocations()) {
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance instance = aggregateMap.getLocation(location);
                    Map rawdata = instance.getData();
                    Object[] states = EpidemicControl.this.filterDisplayableStates(rawdata.keySet());
                    Arrays.sort(states);
                    int i = 0;
                    while (i < states.length) {
                        if (rawdata.get(states[i]) != null) {
                            EpidemicControl.this.aggregateData.add((List)rawdata.get(states[i]));
                            EpidemicControl.this.primaryPropertiesToPlot.add((String)states[i]);
                        }
                        ++i;
                    }
                    aCtrl.aggregateDataCanvas.draw();
                }
                Map dataMap = null;
                try {
                    dataMap = loader.processIncidenceFile(filetextAggregate.getText());
                }
                catch (LogInitializationException e1) {
                    Activator.logError(e1.getMessage(), e1);
                }
                EpidemicControl.this.incidenceData = new ArrayList<List<Double>>();
                int i = 0;
                while (i < incidenceStates.length) {
                    if (dataMap.get(incidenceStates[i]) != null) {
                        ArrayList<Double> nextData = new ArrayList<Double>();
                        List dataList = (List)dataMap.get(incidenceStates[i]);
                        int j = 0;
                        while (j < dataList.size()) {
                            try {
                                Double dbl = new Double((String)dataList.get(j));
                                if (dbl != null) {
                                    nextData.add(dbl);
                                }
                            }
                            catch (Exception exception) {}
                            ++j;
                        }
                        if (nextData.size() >= 1) {
                            EpidemicControl.this.incidenceData.add(nextData);
                        }
                        EpidemicControl.this.secondaryPropertiesToPlot.add(incidenceStates[i]);
                    }
                    ++i;
                }
                aCtrl.newIncidenceCanvas.draw();
            }
        });
        statusLabel = new Label((Composite)this, 2048);
        statusLabel.setText("");
        this.aggregateDataCanvas = new TimeSeriesCanvas(this, Messages.getString("EPIVIEW.AGGREGATELEGEND"), Messages.getString("EPIVIEW.YAXIS"), AggregateDataWriter.getKeyS(), foreGround, backgroundGround, frameColor, 0);
        FormData analysisChartFormData = new FormData();
        this.aggregateDataCanvas.setLayoutData(analysisChartFormData);
        analysisChartFormData.top = new FormAttachment((Control)pickAggregateFileButton, spacer);
        analysisChartFormData.bottom = new FormAttachment(100, 0);
        analysisChartFormData.left = new FormAttachment(0, 0);
        analysisChartFormData.right = new FormAttachment(50, 0);
        this.newIncidenceCanvas = new TimeSeriesCanvas(this, Messages.getString("INCVIEW.INCIDENCELEGEND"), Messages.getString("INCVIEW.YAXIS"), incidenceStates[0], foreGround, backgroundGround, frameColor, 1);
        FormData incidenceChartFormData = new FormData();
        this.newIncidenceCanvas.setLayoutData(incidenceChartFormData);
        incidenceChartFormData.top = new FormAttachment((Control)pickAggregateFileButton, 0);
        incidenceChartFormData.bottom = new FormAttachment(100, 0);
        incidenceChartFormData.left = new FormAttachment(50, 0);
        incidenceChartFormData.right = new FormAttachment(100, 0);
    }

    Composite getAggregateButtonComposite(AnalysisControl control, String label) {
        Composite aggregateComposite = new Composite((Composite)control, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        aggregateComposite.setLayout((Layout)fillLayout);
        Label leftLabel = new Label(aggregateComposite, 0);
        leftLabel.setText(" ");
        this.aggregateButton = new Button(aggregateComposite, 0);
        this.aggregateButton.setText(label);
        Label rightLabel = new Label(aggregateComposite, 0);
        rightLabel.setText(" ");
        this.aggregateButton.setEnabled(true);
        return aggregateComposite;
    }

    Composite getPlotButtonComposite(AnalysisControl control, String label) {
        Composite plotComposite = new Composite((Composite)control, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        plotComposite.setLayout((Layout)fillLayout);
        this.userMessageLabel = new Label(plotComposite, 0);
        this.userMessageLabel.setText(this.userMessage);
        this.plotButton = new Button(plotComposite, 0);
        this.plotButton.setText(label);
        Label rightLabel = new Label(plotComposite, 0);
        rightLabel.setText(" ");
        this.plotButton.setEnabled(true);
        return plotComposite;
    }

    public void enableAnalysis(boolean b) {
        if (b) {
            this.analyzeButton.setEnabled(true);
        } else {
            this.analyzeButton.setEnabled(false);
        }
    }

    @Override
    public void remove() {
        this.updateStatusLabel();
    }

    protected void updateStatusLabel() {
        statusLabel.setText(Messages.getString("COMMON.STATUS"));
    }

    @Override
    protected void initializeHeader(String folderName) {
        this.simulationNameLabel.setText("analyzing " + folderName);
    }

    public void dispose() {
        super.dispose();
    }

    public Identifiable getIdentifiable() {
        return null;
    }

    @Override
    public double[] getValues(int chartIndex, int state) {
        List<List<Double>> data = this.aggregateData;
        if (chartIndex >= 1) {
            data = this.incidenceData;
        }
        double[] result = new double[data.get(state).size()];
        int i = 0;
        for (double d : data.get(state)) {
            result[i++] = d;
        }
        return result;
    }

    @Override
    public String getProperty(int chartIndex, int state) {
        if (chartIndex == 0) {
            return this.primaryPropertiesToPlot.get(state);
        }
        return this.secondaryPropertiesToPlot.get(state);
    }

    @Override
    public int getNumProperties(int chartIndex) {
        if (chartIndex == 0) {
            return this.primaryPropertiesToPlot.size();
        }
        return this.secondaryPropertiesToPlot.size();
    }

    protected String[] filterDisplayableStates(Set<String> inputSet) {
        int i = 0;
        while (i < OMIT_LIST.length) {
            inputSet.remove(OMIT_LIST[i]);
            ++i;
        }
        Object[] retVal = new String[inputSet.size()];
        int icount = 0;
        Iterator<String> iter = inputSet.iterator();
        while (iter != null && iter.hasNext()) {
            String key = iter.next();
            retVal[icount] = key;
            ++icount;
        }
        Arrays.sort(retVal);
        return retVal;
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        return controlParametersMap;
    }
}

