/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LineDelimiterEditor {
    private Button defaultButton;
    private Button otherButton;
    private Combo choiceCombo;
    private IProject project;
    private Group group;

    public LineDelimiterEditor(Composite composite) {
        this(composite, null);
    }

    public LineDelimiterEditor(Composite composite, IProject project) {
        this.project = project;
        this.createControl(composite);
    }

    private void createControl(Composite parent) {
        Font font = parent.getFont();
        this.group = new Group(parent, 0);
        GridData data = new GridData(768);
        this.group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.group.setLayout((Layout)layout);
        this.group.setText(IDEWorkbenchMessages.IDEWorkspacePreference_fileLineDelimiter);
        this.group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.equals(LineDelimiterEditor.this.defaultButton)) {
                    LineDelimiterEditor.this.updateState(true);
                } else {
                    LineDelimiterEditor.this.updateState(false);
                }
            }
        };
        this.defaultButton = new Button((Composite)this.group, 16);
        String key = this.getKeyForValue(this.getDefaultValue());
        if (this.project == null) {
            this.defaultButton.setText(NLS.bind((String)IDEWorkbenchMessages.IDEWorkspacePreference_defaultLineDelim, (Object)key));
        } else {
            this.defaultButton.setText(NLS.bind((String)IDEWorkbenchMessages.IDEWorkspacePreference_defaultLineDelimProj, (Object)key));
        }
        data = new GridData();
        data.horizontalSpan = 2;
        this.defaultButton.setLayoutData((Object)data);
        this.defaultButton.addSelectionListener((SelectionListener)buttonListener);
        this.defaultButton.setFont(font);
        this.otherButton = new Button((Composite)this.group, 16);
        this.otherButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_otherLineDelim);
        this.otherButton.addSelectionListener((SelectionListener)buttonListener);
        this.otherButton.setFont(font);
        this.choiceCombo = new Combo((Composite)this.group, 8);
        data = new GridData();
        this.choiceCombo.setFont(font);
        this.choiceCombo.setLayoutData((Object)data);
    }

    public void doLoad() {
        if (this.choiceCombo != null) {
            this.choiceCombo.setItems(this.getChoices());
            String resourcePreference = this.getStoredValue(this.getPreferences(this.project));
            this.selectChoice(this.getKeyForValue(resourcePreference));
            this.updateState(resourcePreference == null);
        }
    }

    public void loadDefault() {
        if (this.choiceCombo != null) {
            this.updateState(true);
        }
    }

    private String getDefaultValue() {
        String value = null;
        if (this.project != null) {
            value = this.getStoredValue(this.getPreferences(null));
        }
        return value != null ? value : System.getProperty("line.separator");
    }

    private String getKeyForValue(String value) {
        Map knownValues = Platform.knownPlatformLineSeparators();
        Set keys = knownValues.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!knownValues.get(key).equals(value)) continue;
            return key;
        }
        return null;
    }

    private String getStoredValue(Preferences node) {
        try {
            if (node.nodeExists("org.eclipse.core.runtime")) {
                return node.node("org.eclipse.core.runtime").get("line.separator", null);
            }
        }
        catch (BackingStoreException backingStoreException) {}
        return null;
    }

    private Preferences getPreferences(IProject project) {
        if (project != null) {
            return Platform.getPreferencesService().getRootNode().node("project").node(project.getName());
        }
        return Platform.getPreferencesService().getRootNode().node("instance");
    }

    private String[] getChoices() {
        Set keys = Platform.knownPlatformLineSeparators().keySet();
        String[] keyArray = new String[keys.size()];
        keys.toArray(keyArray);
        return keyArray;
    }

    private void updateState(boolean useDefault) {
        if (useDefault) {
            this.defaultButton.setSelection(true);
            this.otherButton.setSelection(false);
            this.choiceCombo.setEnabled(false);
            this.selectChoice(this.getKeyForValue(this.getDefaultValue()));
        } else {
            this.defaultButton.setSelection(false);
            this.otherButton.setSelection(true);
            this.choiceCombo.setEnabled(true);
        }
    }

    private void selectChoice(String selection) {
        String[] items = this.choiceCombo.getItems();
        int i = 0;
        while (i < items.length) {
            String item = items[i];
            if (item.equals(selection)) {
                this.choiceCombo.select(i);
                break;
            }
            ++i;
        }
    }

    public void store() {
        String val;
        if (this.defaultButton.getSelection() || this.choiceCombo.getText().equals("")) {
            val = null;
        } else {
            Map lineSeparators = Platform.knownPlatformLineSeparators();
            val = (String)lineSeparators.get(this.choiceCombo.getText());
        }
        Preferences node = this.getPreferences(this.project).node("org.eclipse.core.runtime");
        if (val == null) {
            node.remove("line.separator");
        } else {
            node.put("line.separator", val);
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
    }

    public void setEnabled(boolean enabled) {
        this.group.setEnabled(enabled);
        Control[] children = this.group.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enabled);
            ++i;
        }
    }
}

