/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.builder.builderState.IMarkerUpdater;
import org.eclipse.xtext.builder.builderState.Messages;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.validation.IResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.MarkerEraser;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.CheckMode;

public class MarkerUpdaterImpl
implements IMarkerUpdater {
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IStorage2UriMapper mapper;

    public void updateMarkers(IResourceDescription.Delta delta, @Nullable ResourceSet resourceSet, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarkerUpdaterImpl_ValidateResources, (int)1);
        subMonitor.subTask(Messages.MarkerUpdaterImpl_ValidateResources);
        if (subMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.processDelta(delta, resourceSet, subMonitor.newChild(1));
    }

    private void processDelta(IResourceDescription.Delta delta, @Nullable ResourceSet resourceSet, SubMonitor childMonitor) {
        URI uri = delta.getUri();
        IResourceUIValidatorExtension validatorExtension = this.getResourceUIValidatorExtension(uri);
        CheckMode normalAndFastMode = CheckMode.NORMAL_AND_FAST;
        for (Pair pair : this.mapper.getStorages(uri)) {
            if (!(pair.getFirst() instanceof IFile)) continue;
            IFile file = (IFile)pair.getFirst();
            if (validatorExtension != null) {
                if (delta.getNew() != null) {
                    if (resourceSet == null) {
                        throw new IllegalArgumentException("resourceSet may not be null for changed resources.");
                    }
                    validatorExtension.updateValidationMarkers(file, resourceSet.getResource(uri, true), normalAndFastMode, (IProgressMonitor)childMonitor);
                    continue;
                }
                validatorExtension.deleteValidationMarkers(file, normalAndFastMode, (IProgressMonitor)childMonitor);
                continue;
            }
            this.fallBackDeleteMarker(file, normalAndFastMode, (IProgressMonitor)childMonitor);
        }
    }

    private void fallBackDeleteMarker(IFile file, CheckMode checkMode, IProgressMonitor monitor) {
        MarkerEraser markerEraser = new MarkerEraser();
        markerEraser.deleteValidationMarkers(file, checkMode, monitor);
    }

    protected IResourceUIValidatorExtension getResourceUIValidatorExtension(URI uri) {
        IResourceServiceProvider provider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri);
        if (provider != null) {
            return (IResourceUIValidatorExtension)provider.get(IResourceUIValidatorExtension.class);
        }
        return null;
    }
}

