/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnection;
import org.eclipse.tcf.te.tcf.remote.core.TCFEclipseFileSystem;
import org.eclipse.tcf.te.tcf.remote.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.remote.ui.nls.Messages;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;
import org.osgi.framework.Bundle;

public class TCFFileSystemContributor
extends FileSystemContributor {
    private static final String REMOTE_CORE_PLUGIN_ID = "org.eclipse.remote.core";

    public URI browseFileSystem(String initialPath, Shell shell) {
        block6: {
            IRemoteServices services = RemoteServices.getRemoteServices((String)"org.eclipse.tcf.te.tcf.remote.core.TCFService");
            IRemoteUIServices uiServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)services);
            IRemoteUIFileManager uiFileMgr = uiServices.getUIFileManager();
            uiFileMgr.showConnections(true);
            String original = this.setPreferredService("org.eclipse.tcf.te.tcf.remote.core.TCFService");
            try {
                IRemoteConnection conn;
                String path = uiFileMgr.browseDirectory(shell, Messages.TCFFileSystemContributor_browseFileSystem_title, initialPath, 0);
                if (path == null || !((conn = uiFileMgr.getConnection()) instanceof TCFConnection)) break block6;
                TCFConnection tcfConn = (TCFConnection)conn;
                try {
                    URI uRI = TCFEclipseFileSystem.getURIFor((TCFConnection)tcfConn, (String)path);
                    return uRI;
                }
                catch (URISyntaxException e) {
                    Platform.getLog((Bundle)UIPlugin.getDefault().getBundle()).log((IStatus)new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.TCFFileSystemContributor_errorCreateURIForPath, (Object)conn.getName(), (Object)path), (Throwable)e));
                }
            }
            finally {
                this.setPreferredService(original);
            }
        }
        return null;
    }

    private String setPreferredService(String id) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(REMOTE_CORE_PLUGIN_ID);
        String key = "remoteServicesId";
        String old = node.get(key, null);
        if (id == null) {
            node.remove(key);
        } else {
            node.put(key, id);
        }
        return old;
    }

    public URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

