/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCopyBase;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCopy
extends OpCopyBase<FSTreeNode> {
    private final boolean fCopyPermissions;
    private final boolean fCopyOwnership;

    public OpCopy(List<? extends IFSTreeNode> nodes, FSTreeNode dest, boolean cpPerm, boolean cpOwn, IConfirmCallback confirmCallback) {
        super(nodes, dest, confirmCallback);
        this.fCopyOwnership = cpOwn;
        this.fCopyPermissions = cpPerm;
    }

    @Override
    protected FSTreeNode findChild(FSTreeNode destination, String name) {
        return destination.findChild(name);
    }

    @Override
    protected void notifyChange(FSTreeNode destination) {
        destination.notifyChange();
    }

    @Override
    protected IStatus refreshDestination(FSTreeNode destination, long startTime, IProgressMonitor monitor) {
        return this.refresh(destination, startTime, monitor);
    }

    @Override
    protected boolean isDirectory(FSTreeNode node) {
        return node.isDirectory();
    }

    @Override
    protected boolean isFile(FSTreeNode node) {
        return node.isFile();
    }

    @Override
    protected String getLocation(FSTreeNode node) {
        return node.getLocation();
    }

    @Override
    protected IStatus performCopy(final FSTreeNode source, final FSTreeNode destination, final String newName, final FSTreeNode existing, IProgressMonitor monitor) {
        final TCFOperationMonitor result = new TCFOperationMonitor();
        monitor.subTask(NLS.bind((String)Messages.OpCopy_Copying, (Object)source.getLocation()));
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpCopy.this.tcfPerformCopy(source, destination, newName, existing, result);
            }
        });
        return result.waitDone(monitor);
    }

    protected void tcfPerformCopy(FSTreeNode source, FSTreeNode destination, String newName, FSTreeNode existing, TCFOperationMonitor<?> result) {
        if (result.checkCancelled()) {
            return;
        }
        if (source.isFile()) {
            this.tcfCopyFile(source, destination, newName, existing, result);
        } else if (source.isDirectory()) {
            this.tcfCopyFolder(source, destination, newName, result);
        } else {
            result.setDone(null);
        }
    }

    private void tcfCopyFolder(final FSTreeNode source, final FSTreeNode dest, final String newName, final TCFOperationMonitor<?> result) {
        final IFileSystem fileSystem = dest.getRuntimeModel().getFileSystem();
        if (fileSystem == null) {
            result.setCancelled();
            return;
        }
        final String path = this.getPath(dest, newName);
        fileSystem.mkdir(path, source.getAttributes(), new IFileSystem.DoneMkDir(){

            public void doneMkDir(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    result.setError(MessageFormat.format(Messages.Operation_CannotCreateDirectory, newName), (Throwable)error);
                } else if (!result.checkCancelled()) {
                    fileSystem.lstat(path, new IFileSystem.DoneStat(){

                        public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                            if (error != null) {
                                result.setError(MessageFormat.format(Messages.Operation_CannotCreateDirectory, newName), (Throwable)error);
                            } else if (!result.checkCancelled()) {
                                FSTreeNode copy = new FSTreeNode(dest, newName, false, attrs);
                                copy.setContent(new FSTreeNode[0], false);
                                dest.addNode(copy, false);
                                OpCopy.this.addWorkItem(source.getChildren(), copy);
                                result.setDone(null);
                            }
                        }
                    });
                }
            }
        });
    }

    private void tcfCopyFile(final FSTreeNode source, final FSTreeNode dest, final String newName, final FSTreeNode existing, final TCFOperationMonitor<?> result) {
        final IFileSystem fileSystem = dest.getRuntimeModel().getFileSystem();
        if (fileSystem == null) {
            result.setCancelled();
            return;
        }
        String sourcePath = source.getLocation(true);
        final String path = this.getPath(dest, newName);
        fileSystem.copy(sourcePath, path, this.fCopyPermissions, this.fCopyOwnership, new IFileSystem.DoneCopy(){

            public void doneCopy(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    result.setError(MessageFormat.format(Messages.OpCopy_CannotCopyFile, source.getName()), (Throwable)error);
                } else if (!result.checkCancelled()) {
                    fileSystem.stat(path, new IFileSystem.DoneStat(){

                        public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                            if (error != null) {
                                result.setError(MessageFormat.format(Messages.OpCopy_CannotCopyFile, source.getName()), (Throwable)error);
                            } else if (!result.checkCancelled()) {
                                if (existing != null) {
                                    existing.setAttributes(attrs, false);
                                } else {
                                    dest.addNode(new FSTreeNode(dest, newName, false, attrs), false);
                                }
                                result.setDone(null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public String getName() {
        return Messages.OpCopy_CopyingFile;
    }
}

