/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;

public class TCFChildrenExpressions
extends TCFChildren {
    TCFChildrenExpressions(TCFNode node) {
        super(node, 128);
    }

    void onSuspended(boolean func_call) {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onSuspended(func_call);
        }
    }

    void onRegisterValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onRegisterValueChanged();
        }
    }

    void onMemoryChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryChanged();
        }
    }

    void onMemoryMapChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeExpression)n).onMemoryMapChanged();
        }
    }

    private TCFNodeExpression findScript(String text, IExpression e) {
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression node = (TCFNodeExpression)n;
            if (!text.equals(node.getScript()) || node.getPlatformExpression() != null && !node.getPlatformExpression().equals(e)) continue;
            return node;
        }
        return null;
    }

    private TCFNodeExpression findEmpty() {
        for (TCFNode n : this.getNodes()) {
            TCFNodeExpression e = (TCFNodeExpression)n;
            if (!e.isEmpty()) continue;
            return e;
        }
        return null;
    }

    protected boolean startDataRetrieval() {
        int cnt = 0;
        HashMap<String, TCFNode> data = new HashMap<String, TCFNode>();
        IExpression[] iExpressionArray = this.node.model.getExpressionManager().getExpressions();
        int n = iExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression e = iExpressionArray[n2];
            String text = e.getExpressionText();
            TCFNodeExpression n3 = this.findScript(text, e);
            if (n3 == null) {
                n3 = new TCFNodeExpression(this.node, text, null, null, null, -1, false);
                this.add(n3);
            }
            n3.setPlatformExpression(e);
            n3.setSortPosition(cnt++);
            if (e instanceof IWatchExpression) {
                n3.setEnabled(((IWatchExpression)e).isEnabled());
            }
            data.put(n3.id, n3);
            ++n2;
        }
        TCFNodeExpression n4 = this.findEmpty();
        if (n4 == null) {
            n4 = new TCFNodeExpression(this.node, null, null, null, null, -1, false);
            this.add(n4);
        }
        n4.setSortPosition(cnt++);
        data.put(n4.id, n4);
        this.set(null, null, data);
        return true;
    }
}

