/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.internal.services;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.selection.LaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.RemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.runtime.services.interfaces.IDebugService;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.launch.core.delegates.Launch;
import org.eclipse.tcf.te.tcf.launch.ui.internal.services.DebugServicesLaunchesListener;
import org.eclipse.tcf.te.ui.swt.DisplayUtil;

public class DebugService
extends AbstractService
implements IDebugService {
    private final ILaunchesListener listener = new DebugServicesLaunchesListener();

    public DebugService() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.listener);
    }

    public void attach(final Object context, final IPropertiesContainer data, final IProgressMonitor monitor, final ICallback callback) {
        if (!Protocol.isDispatchThread()) {
            this.internalAttach(context, data, monitor, callback);
        } else {
            ExecutorsUtil.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    DebugService.this.internalAttach(context, data, monitor, callback);
                }
            });
        }
    }

    protected void internalAttach(Object context, IPropertiesContainer data, final IProgressMonitor monitor, final ICallback callback) {
        block9: {
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
            Assert.isNotNull((Object)context);
            Assert.isNotNull((Object)data);
            Assert.isNotNull((Object)callback);
            if (context instanceof IModelNode) {
                ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.tcf.te.tcf.launch.type.attach");
                try {
                    LaunchSelection launchSelection = new LaunchSelection("debug", (ISelectionContext)new RemoteSelectionContext((IModelNode)context, true));
                    ILaunchManagerDelegate delegate = LaunchManager.getInstance().getLaunchManagerDelegate(launchConfigType, "debug");
                    if (delegate == null) break block9;
                    ILaunchSpecification launchSpec = delegate.getLaunchSpecification(launchConfigType.getIdentifier(), (ILaunchSelection)launchSelection);
                    for (String key : data.getProperties().keySet()) {
                        launchSpec.addAttribute(key, data.getProperty(key));
                    }
                    delegate.validate(launchSpec);
                    if (launchSpec == null || !launchSpec.isValid()) break block9;
                    ILaunchConfiguration[] launchConfigs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(launchConfigType);
                    ILaunchConfiguration config = (launchConfigs = delegate.getMatchingLaunchConfigurations(launchSpec, launchConfigs)) != null && launchConfigs.length > 0 ? launchConfigs[0] : null;
                    boolean skip = false;
                    ILaunch activeLaunch = null;
                    if (config != null) {
                        ILaunch[] launches;
                        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                        int n = launches.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IModelNode[] contexts;
                            ILaunch launch = iLaunchArray[n2];
                            if (launch.getLaunchConfiguration().getType().getIdentifier().equals("org.eclipse.tcf.te.tcf.launch.type.attach") && !launch.isTerminated() && (contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)launch.getLaunchConfiguration())) != null && contexts.length == 1 && contexts[0].equals(context)) {
                                callback.setProperty("launch", (Object)launch);
                                activeLaunch = launch;
                                skip = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!skip) {
                        final ILaunchConfiguration finConfig = LaunchManager.getInstance().createOrUpdateLaunchConfiguration(config, launchSpec);
                        delegate.validate("debug", finConfig);
                        ILaunchListener listener = new ILaunchListener(){

                            public void launchAdded(ILaunch launch) {
                                if (launch != null && finConfig.equals(launch.getLaunchConfiguration())) {
                                    DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
                                    callback.setProperty("launch", (Object)launch);
                                    if (launch instanceof Launch) {
                                        ((Launch)launch).setCallback(callback);
                                    } else {
                                        callback.done((Object)this, Status.OK_STATUS);
                                    }
                                }
                            }

                            public void launchChanged(ILaunch launch) {
                            }

                            public void launchRemoved(ILaunch launch) {
                            }
                        };
                        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(listener);
                        DisplayUtil.safeAsyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    DebugUITools.buildAndLaunch((ILaunchConfiguration)finConfig, (String)"debug", (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
                                }
                                catch (Exception e) {
                                    callback.done((Object)DebugService.this, StatusHelper.getStatus((Throwable)e));
                                }
                            }
                        });
                        break block9;
                    }
                    DebugUIPlugin.getDefault().getPerspectiveManager().launchAdded(activeLaunch);
                    callback.done((Object)this, Status.OK_STATUS);
                }
                catch (Exception e) {
                    callback.done((Object)this, StatusHelper.getStatus((Throwable)e));
                }
            } else {
                callback.done((Object)this, Status.OK_STATUS);
            }
        }
    }

    public void detach(Object context, IPropertiesContainer data, IProgressMonitor monitor, ICallback callback) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)callback);
        if (context instanceof IModelNode) {
            ILaunch[] launches;
            ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                try {
                    IModelNode[] contexts;
                    if (launch.getLaunchConfiguration().getType().getIdentifier().equals("org.eclipse.tcf.te.tcf.launch.type.attach") && (contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)launch.getLaunchConfiguration())) != null && contexts.length == 1 && contexts[0].equals(context)) {
                        if (launch instanceof IDisconnect && !((IDisconnect)launch).isDisconnected()) {
                            ((IDisconnect)launch).disconnect();
                            data.setProperty("debuggerDetached", true);
                        } else if (launch instanceof Launch) {
                            data.setProperty("debuggerDetached", !((Launch)launch).isManualDisconnected());
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof ExecutionException && "TCF task aborted".equals(e.getMessage()) || e.getCause() instanceof CancellationException) {
                        callback.done((Object)this, Status.OK_STATUS);
                    } else {
                        callback.done((Object)this, StatusHelper.getStatus((Throwable)e));
                    }
                    return;
                }
                ++n2;
            }
        }
        callback.done((Object)this, Status.OK_STATUS);
    }

    public boolean isLaunched(Object context) {
        Assert.isNotNull((Object)context);
        boolean isLaunched = false;
        if (context instanceof IModelNode) {
            ILaunch[] launches;
            ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    ILaunch launch = iLaunchArray[n2];
                    if (launch != null) {
                        try {
                            IModelNode[] contexts;
                            if (launch.getLaunchConfiguration() != null && launch.getLaunchConfiguration().getType() != null && launch.getLaunchConfiguration().getType().getIdentifier() != null && launch.getLaunchConfiguration().getType().getIdentifier().equals("org.eclipse.tcf.te.tcf.launch.type.attach") && !launch.isTerminated() && (contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)launch.getLaunchConfiguration())) != null && contexts.length == 1 && contexts[0].equals(context)) {
                                isLaunched = true;
                                break;
                            }
                        }
                        catch (CoreException e) {
                            if (!Platform.inDebugMode()) break block6;
                            e.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
        }
        return isLaunched;
    }
}

